% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_reboot_db_instance}
\alias{docdb_reboot_db_instance}
\title{You might need to reboot your instance, usually for maintenance reasons}
\usage{
docdb_reboot_db_instance(DBInstanceIdentifier, ForceFailover)
}
\arguments{
\item{DBInstanceIdentifier}{[required] The instance identifier. This parameter is stored as a lowercase string.

Constraints:
\itemize{
\item Must match the identifier of an existing \code{DBInstance}.
}}

\item{ForceFailover}{When \code{true}, the reboot is conducted through a Multi-AZ failover.

Constraint: You can\'t specify \code{true} if the instance is not configured
for Multi-AZ.}
}
\description{
You might need to reboot your instance, usually for maintenance reasons.
For example, if you make certain changes, or if you change the cluster
parameter group that is associated with the instance, you must reboot
the instance for the changes to take effect.
}
\details{
Rebooting an instance restarts the database engine service. Rebooting an
instance results in a momentary outage, during which the instance status
is set to \emph{rebooting}.
}
\section{Request syntax}{
\preformatted{svc$reboot_db_instance(
  DBInstanceIdentifier = "string",
  ForceFailover = TRUE|FALSE
)
}
}

\keyword{internal}
