% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloud9_operations.R
\name{cloud9_create_environment_ec2}
\alias{cloud9_create_environment_ec2}
\title{Creates an AWS Cloud9 development environment, launches an Amazon
Elastic Compute Cloud (Amazon EC2) instance, and then connects from the
instance to the environment}
\usage{
cloud9_create_environment_ec2(name, description, clientRequestToken,
  instanceType, subnetId, automaticStopTimeMinutes, ownerArn, tags,
  connectionType)
}
\arguments{
\item{name}{[required] The name of the environment to create.

This name is visible to other AWS IAM users in the same AWS account.}

\item{description}{The description of the environment to create.}

\item{clientRequestToken}{A unique, case-sensitive string that helps AWS Cloud9 to ensure this
operation completes no more than one time.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Client Tokens}
in the \emph{Amazon EC2 API Reference}.}

\item{instanceType}{[required] The type of instance to connect to the environment (for example,
\code{t2.micro}).}

\item{subnetId}{The ID of the subnet in Amazon VPC that AWS Cloud9 will use to
communicate with the Amazon EC2 instance.}

\item{automaticStopTimeMinutes}{The number of minutes until the running instance is shut down after the
environment has last been used.}

\item{ownerArn}{The Amazon Resource Name (ARN) of the environment owner. This ARN can be
the ARN of any AWS IAM principal. If this value is not specified, the
ARN defaults to this environment's creator.}

\item{tags}{An array of key-value pairs that will be associated with the new AWS
Cloud9 development environment.}

\item{connectionType}{The connection type used for connecting to an Amazon EC2 environment.}
}
\value{
A list with the following syntax:\preformatted{list(
  environmentId = "string"
)
}
}
\description{
Creates an AWS Cloud9 development environment, launches an Amazon
Elastic Compute Cloud (Amazon EC2) instance, and then connects from the
instance to the environment.
}
\section{Request syntax}{
\preformatted{svc$create_environment_ec2(
  name = "string",
  description = "string",
  clientRequestToken = "string",
  instanceType = "string",
  subnetId = "string",
  automaticStopTimeMinutes = 123,
  ownerArn = "string",
  tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  connectionType = "CONNECT_SSH"|"CONNECT_SSM"
)
}
}

\examples{
\dontrun{
# 
svc$create_environment_ec2(
  name = "my-demo-environment",
  automaticStopTimeMinutes = 60L,
  description = "This is my demonstration environment.",
  instanceType = "t2.micro",
  ownerArn = "arn:aws:iam::123456789012:user/MyDemoUser",
  subnetId = "subnet-1fab8aEX"
)
}

}
\keyword{internal}
