% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_start_build_batch}
\alias{codebuild_start_build_batch}
\title{Starts a batch build for a project}
\usage{
codebuild_start_build_batch(projectName, secondarySourcesOverride,
  secondarySourcesVersionOverride, sourceVersion, artifactsOverride,
  secondaryArtifactsOverride, environmentVariablesOverride,
  sourceTypeOverride, sourceLocationOverride, sourceAuthOverride,
  gitCloneDepthOverride, gitSubmodulesConfigOverride, buildspecOverride,
  insecureSslOverride, reportBuildBatchStatusOverride,
  environmentTypeOverride, imageOverride, computeTypeOverride,
  certificateOverride, cacheOverride, serviceRoleOverride,
  privilegedModeOverride, buildTimeoutInMinutesOverride,
  queuedTimeoutInMinutesOverride, encryptionKeyOverride, idempotencyToken,
  logsConfigOverride, registryCredentialOverride,
  imagePullCredentialsTypeOverride, buildBatchConfigOverride)
}
\arguments{
\item{projectName}{[required] The name of the project.}

\item{secondarySourcesOverride}{An array of \code{ProjectSource} objects that override the secondary sources
defined in the batch build project.}

\item{secondarySourcesVersionOverride}{An array of \code{ProjectSourceVersion} objects that override the secondary
source versions in the batch build project.}

\item{sourceVersion}{The version of the batch build input to be built, for this build only.
If not specified, the latest version is used. If specified, the contents
depends on the source provider:
\subsection{AWS CodeCommit}{

The commit ID, branch, or Git tag to use.
}

\subsection{GitHub}{

The commit ID, pull request ID, branch name, or tag name that
corresponds to the version of the source code you want to build. If a
pull request ID is specified, it must use the format
\code{pr/pull-request-ID} (for example \code{pr/25}). If a branch name is
specified, the branch's HEAD commit ID is used. If not specified, the
default branch's HEAD commit ID is used.
}

\subsection{Bitbucket}{

The commit ID, branch name, or tag name that corresponds to the version
of the source code you want to build. If a branch name is specified, the
branch's HEAD commit ID is used. If not specified, the default branch's
HEAD commit ID is used.
}

\subsection{Amazon Simple Storage Service (Amazon S3)}{

The version ID of the object that represents the build input ZIP file to
use.

If \code{sourceVersion} is specified at the project level, then this
\code{sourceVersion} (at the build level) takes precedence.

For more information, see \href{https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html}{Source Version Sample with CodeBuild}
in the \emph{AWS CodeBuild User Guide}.
}}

\item{artifactsOverride}{An array of \code{ProjectArtifacts} objects that contains information about
the build output artifact overrides for the build project.}

\item{secondaryArtifactsOverride}{An array of \code{ProjectArtifacts} objects that override the secondary
artifacts defined in the batch build project.}

\item{environmentVariablesOverride}{An array of \code{EnvironmentVariable} objects that override, or add to, the
environment variables defined in the batch build project.}

\item{sourceTypeOverride}{The source input type that overrides the source input defined in the
batch build project.}

\item{sourceLocationOverride}{A location that overrides, for this batch build, the source location
defined in the batch build project.}

\item{sourceAuthOverride}{A \code{SourceAuth} object that overrides the one defined in the batch build
project. This override applies only if the build project's source is
BitBucket or GitHub.}

\item{gitCloneDepthOverride}{The user-defined depth of history, with a minimum value of 0, that
overrides, for this batch build only, any previous depth of history
defined in the batch build project.}

\item{gitSubmodulesConfigOverride}{A \code{GitSubmodulesConfig} object that overrides the Git submodules
configuration for this batch build.}

\item{buildspecOverride}{A buildspec file declaration that overrides, for this build only, the
latest one already defined in the build project.

If this value is set, it can be either an inline buildspec definition,
the path to an alternate buildspec file relative to the value of the
built-in \code{CODEBUILD_SRC_DIR} environment variable, or the path to an S3
bucket. The bucket must be in the same AWS Region as the build project.
Specify the buildspec file using its ARN (for example,
\code{arn:aws:s3:::my-codebuild-sample2/buildspec.yml}). If this value is not
provided or is set to an empty string, the source code must contain a
buildspec file in its root directory. For more information, see
\href{https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage}{Buildspec File Name and Storage Location}.}

\item{insecureSslOverride}{Enable this flag to override the insecure SSL setting that is specified
in the batch build project. The insecure SSL setting determines whether
to ignore SSL warnings while connecting to the project source code. This
override applies only if the build's source is GitHub Enterprise.}

\item{reportBuildBatchStatusOverride}{Set to \code{true} to report to your source provider the status of a batch
build's start and completion. If you use this option with a source
provider other than GitHub, GitHub Enterprise, or Bitbucket, an
\code{invalidInputException} is thrown.

The status of a build triggered by a webhook is always reported to your
source provider.}

\item{environmentTypeOverride}{A container type for this batch build that overrides the one specified
in the batch build project.}

\item{imageOverride}{The name of an image for this batch build that overrides the one
specified in the batch build project.}

\item{computeTypeOverride}{The name of a compute type for this batch build that overrides the one
specified in the batch build project.}

\item{certificateOverride}{The name of a certificate for this batch build that overrides the one
specified in the batch build project.}

\item{cacheOverride}{A \code{ProjectCache} object that specifies cache overrides.}

\item{serviceRoleOverride}{The name of a service role for this batch build that overrides the one
specified in the batch build project.}

\item{privilegedModeOverride}{Enable this flag to override privileged mode in the batch build project.}

\item{buildTimeoutInMinutesOverride}{Overrides the build timeout specified in the batch build project.}

\item{queuedTimeoutInMinutesOverride}{The number of minutes a batch build is allowed to be queued before it
times out.}

\item{encryptionKeyOverride}{The AWS Key Management Service (AWS KMS) customer master key (CMK) that
overrides the one specified in the batch build project. The CMK key
encrypts the build output artifacts.

You can use a cross-account KMS key to encrypt the build output
artifacts if your service role has permission to that key.

You can specify either the Amazon Resource Name (ARN) of the CMK or, if
available, the CMK's alias (using the format \verb{alias/<alias-name>}).}

\item{idempotencyToken}{A unique, case sensitive identifier you provide to ensure the
idempotency of the \code{\link[=codebuild_start_build_batch]{start_build_batch}}
request. The token is included in the
\code{\link[=codebuild_start_build_batch]{start_build_batch}} request and is valid
for five minutes. If you repeat the
\code{\link[=codebuild_start_build_batch]{start_build_batch}} request with the same
token, but change a parameter, AWS CodeBuild returns a parameter
mismatch error.}

\item{logsConfigOverride}{A \code{LogsConfig} object that override the log settings defined in the
batch build project.}

\item{registryCredentialOverride}{A \code{RegistryCredential} object that overrides credentials for access to a
private registry.}

\item{imagePullCredentialsTypeOverride}{The type of credentials AWS CodeBuild uses to pull images in your batch
build. There are two valid values:
\subsection{CODEBUILD}{

Specifies that AWS CodeBuild uses its own credentials. This requires
that you modify your ECR repository policy to trust AWS CodeBuild's
service principal.
}

\subsection{SERVICE_ROLE}{

Specifies that AWS CodeBuild uses your build project's service role.

When using a cross-account or private registry image, you must use
\code{SERVICE_ROLE} credentials. When using an AWS CodeBuild curated image,
you must use \code{CODEBUILD} credentials.
}}

\item{buildBatchConfigOverride}{A \code{BuildBatchConfigOverride} object that contains batch build
configuration overrides.}
}
\value{
A list with the following syntax:\preformatted{list(
  buildBatch = list(
    id = "string",
    arn = "string",
    startTime = as.POSIXct(
      "2015-01-01"
    ),
    endTime = as.POSIXct(
      "2015-01-01"
    ),
    currentPhase = "string",
    buildBatchStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
    sourceVersion = "string",
    resolvedSourceVersion = "string",
    projectName = "string",
    phases = list(
      list(
        phaseType = "SUBMITTED"|"DOWNLOAD_BATCHSPEC"|"IN_PROGRESS"|"COMBINE_ARTIFACTS"|"SUCCEEDED"|"FAILED"|"STOPPED",
        phaseStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
        startTime = as.POSIXct(
          "2015-01-01"
        ),
        endTime = as.POSIXct(
          "2015-01-01"
        ),
        durationInSeconds = 123,
        contexts = list(
          list(
            statusCode = "string",
            message = "string"
          )
        )
      )
    ),
    source = list(
      type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
      location = "string",
      gitCloneDepth = 123,
      gitSubmodulesConfig = list(
        fetchSubmodules = TRUE|FALSE
      ),
      buildspec = "string",
      auth = list(
        type = "OAUTH",
        resource = "string"
      ),
      reportBuildStatus = TRUE|FALSE,
      buildStatusConfig = list(
        context = "string",
        targetUrl = "string"
      ),
      insecureSsl = TRUE|FALSE,
      sourceIdentifier = "string"
    ),
    secondarySources = list(
      list(
        type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
        location = "string",
        gitCloneDepth = 123,
        gitSubmodulesConfig = list(
          fetchSubmodules = TRUE|FALSE
        ),
        buildspec = "string",
        auth = list(
          type = "OAUTH",
          resource = "string"
        ),
        reportBuildStatus = TRUE|FALSE,
        buildStatusConfig = list(
          context = "string",
          targetUrl = "string"
        ),
        insecureSsl = TRUE|FALSE,
        sourceIdentifier = "string"
      )
    ),
    secondarySourceVersions = list(
      list(
        sourceIdentifier = "string",
        sourceVersion = "string"
      )
    ),
    artifacts = list(
      location = "string",
      sha256sum = "string",
      md5sum = "string",
      overrideArtifactName = TRUE|FALSE,
      encryptionDisabled = TRUE|FALSE,
      artifactIdentifier = "string"
    ),
    secondaryArtifacts = list(
      list(
        location = "string",
        sha256sum = "string",
        md5sum = "string",
        overrideArtifactName = TRUE|FALSE,
        encryptionDisabled = TRUE|FALSE,
        artifactIdentifier = "string"
      )
    ),
    cache = list(
      type = "NO_CACHE"|"S3"|"LOCAL",
      location = "string",
      modes = list(
        "LOCAL_DOCKER_LAYER_CACHE"|"LOCAL_SOURCE_CACHE"|"LOCAL_CUSTOM_CACHE"
      )
    ),
    environment = list(
      type = "WINDOWS_CONTAINER"|"LINUX_CONTAINER"|"LINUX_GPU_CONTAINER"|"ARM_CONTAINER"|"WINDOWS_SERVER_2019_CONTAINER",
      image = "string",
      computeType = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE"|"BUILD_GENERAL1_2XLARGE",
      environmentVariables = list(
        list(
          name = "string",
          value = "string",
          type = "PLAINTEXT"|"PARAMETER_STORE"|"SECRETS_MANAGER"
        )
      ),
      privilegedMode = TRUE|FALSE,
      certificate = "string",
      registryCredential = list(
        credential = "string",
        credentialProvider = "SECRETS_MANAGER"
      ),
      imagePullCredentialsType = "CODEBUILD"|"SERVICE_ROLE"
    ),
    serviceRole = "string",
    logConfig = list(
      cloudWatchLogs = list(
        status = "ENABLED"|"DISABLED",
        groupName = "string",
        streamName = "string"
      ),
      s3Logs = list(
        status = "ENABLED"|"DISABLED",
        location = "string",
        encryptionDisabled = TRUE|FALSE
      )
    ),
    buildTimeoutInMinutes = 123,
    queuedTimeoutInMinutes = 123,
    complete = TRUE|FALSE,
    initiator = "string",
    vpcConfig = list(
      vpcId = "string",
      subnets = list(
        "string"
      ),
      securityGroupIds = list(
        "string"
      )
    ),
    encryptionKey = "string",
    buildBatchNumber = 123,
    fileSystemLocations = list(
      list(
        type = "EFS",
        location = "string",
        mountPoint = "string",
        identifier = "string",
        mountOptions = "string"
      )
    ),
    buildBatchConfig = list(
      serviceRole = "string",
      combineArtifacts = TRUE|FALSE,
      restrictions = list(
        maximumBuildsAllowed = 123,
        computeTypesAllowed = list(
          "string"
        )
      ),
      timeoutInMins = 123
    ),
    buildGroups = list(
      list(
        identifier = "string",
        dependsOn = list(
          "string"
        ),
        ignoreFailure = TRUE|FALSE,
        currentBuildSummary = list(
          arn = "string",
          requestedOn = as.POSIXct(
            "2015-01-01"
          ),
          buildStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
          primaryArtifact = list(
            type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
            location = "string",
            identifier = "string"
          ),
          secondaryArtifacts = list(
            list(
              type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
              location = "string",
              identifier = "string"
            )
          )
        ),
        priorBuildSummaryList = list(
          list(
            arn = "string",
            requestedOn = as.POSIXct(
              "2015-01-01"
            ),
            buildStatus = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED",
            primaryArtifact = list(
              type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
              location = "string",
              identifier = "string"
            ),
            secondaryArtifacts = list(
              list(
                type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
                location = "string",
                identifier = "string"
              )
            )
          )
        )
      )
    )
  )
)
}
}
\description{
Starts a batch build for a project.
}
\section{Request syntax}{
\preformatted{svc$start_build_batch(
  projectName = "string",
  secondarySourcesOverride = list(
    list(
      type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
      location = "string",
      gitCloneDepth = 123,
      gitSubmodulesConfig = list(
        fetchSubmodules = TRUE|FALSE
      ),
      buildspec = "string",
      auth = list(
        type = "OAUTH",
        resource = "string"
      ),
      reportBuildStatus = TRUE|FALSE,
      buildStatusConfig = list(
        context = "string",
        targetUrl = "string"
      ),
      insecureSsl = TRUE|FALSE,
      sourceIdentifier = "string"
    )
  ),
  secondarySourcesVersionOverride = list(
    list(
      sourceIdentifier = "string",
      sourceVersion = "string"
    )
  ),
  sourceVersion = "string",
  artifactsOverride = list(
    type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
    location = "string",
    path = "string",
    namespaceType = "NONE"|"BUILD_ID",
    name = "string",
    packaging = "NONE"|"ZIP",
    overrideArtifactName = TRUE|FALSE,
    encryptionDisabled = TRUE|FALSE,
    artifactIdentifier = "string"
  ),
  secondaryArtifactsOverride = list(
    list(
      type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
      location = "string",
      path = "string",
      namespaceType = "NONE"|"BUILD_ID",
      name = "string",
      packaging = "NONE"|"ZIP",
      overrideArtifactName = TRUE|FALSE,
      encryptionDisabled = TRUE|FALSE,
      artifactIdentifier = "string"
    )
  ),
  environmentVariablesOverride = list(
    list(
      name = "string",
      value = "string",
      type = "PLAINTEXT"|"PARAMETER_STORE"|"SECRETS_MANAGER"
    )
  ),
  sourceTypeOverride = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
  sourceLocationOverride = "string",
  sourceAuthOverride = list(
    type = "OAUTH",
    resource = "string"
  ),
  gitCloneDepthOverride = 123,
  gitSubmodulesConfigOverride = list(
    fetchSubmodules = TRUE|FALSE
  ),
  buildspecOverride = "string",
  insecureSslOverride = TRUE|FALSE,
  reportBuildBatchStatusOverride = TRUE|FALSE,
  environmentTypeOverride = "WINDOWS_CONTAINER"|"LINUX_CONTAINER"|"LINUX_GPU_CONTAINER"|"ARM_CONTAINER"|"WINDOWS_SERVER_2019_CONTAINER",
  imageOverride = "string",
  computeTypeOverride = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE"|"BUILD_GENERAL1_2XLARGE",
  certificateOverride = "string",
  cacheOverride = list(
    type = "NO_CACHE"|"S3"|"LOCAL",
    location = "string",
    modes = list(
      "LOCAL_DOCKER_LAYER_CACHE"|"LOCAL_SOURCE_CACHE"|"LOCAL_CUSTOM_CACHE"
    )
  ),
  serviceRoleOverride = "string",
  privilegedModeOverride = TRUE|FALSE,
  buildTimeoutInMinutesOverride = 123,
  queuedTimeoutInMinutesOverride = 123,
  encryptionKeyOverride = "string",
  idempotencyToken = "string",
  logsConfigOverride = list(
    cloudWatchLogs = list(
      status = "ENABLED"|"DISABLED",
      groupName = "string",
      streamName = "string"
    ),
    s3Logs = list(
      status = "ENABLED"|"DISABLED",
      location = "string",
      encryptionDisabled = TRUE|FALSE
    )
  ),
  registryCredentialOverride = list(
    credential = "string",
    credentialProvider = "SECRETS_MANAGER"
  ),
  imagePullCredentialsTypeOverride = "CODEBUILD"|"SERVICE_ROLE",
  buildBatchConfigOverride = list(
    serviceRole = "string",
    combineArtifacts = TRUE|FALSE,
    restrictions = list(
      maximumBuildsAllowed = 123,
      computeTypesAllowed = list(
        "string"
      )
    ),
    timeoutInMins = 123
  )
)
}
}

\keyword{internal}
