% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_batch_get_repositories}
\alias{codecommit_batch_get_repositories}
\title{Returns information about one or more repositories}
\usage{
codecommit_batch_get_repositories(repositoryNames)
}
\arguments{
\item{repositoryNames}{[required] The names of the repositories to get information about.

The length constraint limit is for each string in the array. The array
itself can be empty.}
}
\value{
A list with the following syntax:\preformatted{list(
  repositories = list(
    list(
      accountId = "string",
      repositoryId = "string",
      repositoryName = "string",
      repositoryDescription = "string",
      defaultBranch = "string",
      lastModifiedDate = as.POSIXct(
        "2015-01-01"
      ),
      creationDate = as.POSIXct(
        "2015-01-01"
      ),
      cloneUrlHttp = "string",
      cloneUrlSsh = "string",
      Arn = "string"
    )
  ),
  repositoriesNotFound = list(
    "string"
  )
)
}
}
\description{
Returns information about one or more repositories.

The description field for a repository accepts all HTML characters and
all valid Unicode characters. Applications that do not HTML-encode the
description and display it in a webpage can expose users to potentially
malicious code. Make sure that you HTML-encode the description field in
any application that uses this API to display the repository description
on a webpage.
}
\section{Request syntax}{
\preformatted{svc$batch_get_repositories(
  repositoryNames = list(
    "string"
  )
)
}
}

\keyword{internal}
