% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_post_comment_for_pull_request}
\alias{codecommit_post_comment_for_pull_request}
\title{Posts a comment on a pull request}
\usage{
codecommit_post_comment_for_pull_request(pullRequestId, repositoryName,
  beforeCommitId, afterCommitId, location, content, clientRequestToken)
}
\arguments{
\item{pullRequestId}{[required] The system-generated ID of the pull request. To get this ID, use
\code{\link[=codecommit_list_pull_requests]{list_pull_requests}}.}

\item{repositoryName}{[required] The name of the repository where you want to post a comment on a pull
request.}

\item{beforeCommitId}{[required] The full commit ID of the commit in the destination branch that was the
tip of the branch at the time the pull request was created.}

\item{afterCommitId}{[required] The full commit ID of the commit in the source branch that is the
current tip of the branch for the pull request when you post the
comment.}

\item{location}{The location of the change where you want to post your comment. If no
location is provided, the comment is posted as a general comment on the
pull request difference between the before commit ID and the after
commit ID.}

\item{content}{[required] The content of your comment on the change.}

\item{clientRequestToken}{A unique, client-generated idempotency token that, when provided in a
request, ensures the request cannot be repeated with a changed
parameter. If a request is received with the same parameters and a token
is included, the request returns information about the initial request
that used that token.}
}
\value{
A list with the following syntax:\preformatted{list(
  repositoryName = "string",
  pullRequestId = "string",
  beforeCommitId = "string",
  afterCommitId = "string",
  beforeBlobId = "string",
  afterBlobId = "string",
  location = list(
    filePath = "string",
    filePosition = 123,
    relativeFileVersion = "BEFORE"|"AFTER"
  ),
  comment = list(
    commentId = "string",
    content = "string",
    inReplyTo = "string",
    creationDate = as.POSIXct(
      "2015-01-01"
    ),
    lastModifiedDate = as.POSIXct(
      "2015-01-01"
    ),
    authorArn = "string",
    deleted = TRUE|FALSE,
    clientRequestToken = "string",
    callerReactions = list(
      "string"
    ),
    reactionCounts = list(
      123
    )
  )
)
}
}
\description{
Posts a comment on a pull request.
}
\section{Request syntax}{
\preformatted{svc$post_comment_for_pull_request(
  pullRequestId = "string",
  repositoryName = "string",
  beforeCommitId = "string",
  afterCommitId = "string",
  location = list(
    filePath = "string",
    filePosition = 123,
    relativeFileVersion = "BEFORE"|"AFTER"
  ),
  content = "string",
  clientRequestToken = "string"
)
}
}

\keyword{internal}
