% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeartifact_operations.R
\name{codeartifact_associate_external_connection}
\alias{codeartifact_associate_external_connection}
\title{Adds an existing external connection to a repository}
\usage{
codeartifact_associate_external_connection(
  domain,
  domainOwner = NULL,
  repository,
  externalConnection
)
}
\arguments{
\item{domain}{[required] The name of the domain that contains the repository.}

\item{domainOwner}{The 12-digit account number of the Amazon Web Services account that owns
the domain. It does not include dashes or spaces.}

\item{repository}{[required] The name of the repository to which the external connection is added.}

\item{externalConnection}{[required] The name of the external connection to add to the repository. The
following values are supported:
\itemize{
\item \code{public:npmjs} - for the npm public repository.
\item \code{public:pypi} - for the Python Package Index.
\item \code{public:maven-central} - for Maven Central.
\item \code{public:maven-googleandroid} - for the Google Android repository.
\item \code{public:maven-gradleplugins} - for the Gradle plugins repository.
\item \code{public:maven-commonsware} - for the CommonsWare Android repository.
}}
}
\description{
Adds an existing external connection to a repository. One external connection is allowed per repository.

See \url{https://paws-r.github.io/docs/codeartifact/associate_external_connection.html} for full documentation.
}
\keyword{internal}
