% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_list_pull_requests}
\alias{codecommit_list_pull_requests}
\title{Returns a list of pull requests for a specified repository}
\usage{
codecommit_list_pull_requests(
  repositoryName,
  authorArn = NULL,
  pullRequestStatus = NULL,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{repositoryName}{[required] The name of the repository for which you want to list pull requests.}

\item{authorArn}{Optional. The Amazon Resource Name (ARN) of the user who created the
pull request. If used, this filters the results to pull requests created
by that user.}

\item{pullRequestStatus}{Optional. The status of the pull request. If used, this refines the
results to the pull requests that match the specified status.}

\item{nextToken}{An enumeration token that, when provided in a request, returns the next
batch of the results.}

\item{maxResults}{A non-zero, non-negative integer used to limit the number of returned
results.}
}
\description{
Returns a list of pull requests for a specified repository. The return list can be refined by pull request status or pull request author ARN.

See \url{https://paws-r.github.io/docs/codecommit/list_pull_requests.html} for full documentation.
}
\keyword{internal}
