% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeguruprofiler_operations.R
\name{codeguruprofiler_remove_permission}
\alias{codeguruprofiler_remove_permission}
\title{Removes permissions from a profiling group's resource-based policy that
are provided using an action group}
\usage{
codeguruprofiler_remove_permission(actionGroup, profilingGroupName, revisionId)
}
\arguments{
\item{actionGroup}{[required] Specifies an action group that contains the permissions to remove from a
profiling group's resource-based policy. One action group is supported,
\code{agentPermissions}, which grants
\code{\link[=codeguruprofiler_configure_agent]{configure_agent}} and
\code{\link[=codeguruprofiler_post_agent_profile]{post_agent_profile}} permissions.}

\item{profilingGroupName}{[required] The name of the profiling group.}

\item{revisionId}{[required] A universally unique identifier (UUID) for the revision of the
resource-based policy from which you want to remove permissions.}
}
\description{
Removes permissions from a profiling group's resource-based policy that are provided using an action group. The one supported action group that can be removed is \code{agentPermission} which grants \code{\link[=codeguruprofiler_configure_agent]{configure_agent}} and \code{PostAgent} permissions. For more information, see \href{https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html}{Resource-based policies in CodeGuru Profiler} in the \emph{Amazon CodeGuru Profiler User Guide}, \href{https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html}{\code{configure_agent}} , and \href{https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html}{\code{post_agent_profile}} .

See \url{https://paws-r.github.io/docs/codeguruprofiler/remove_permission.html} for full documentation.
}
\keyword{internal}
