% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codestarnotifications_operations.R
\name{codestarnotifications_update_notification_rule}
\alias{codestarnotifications_update_notification_rule}
\title{Updates a notification rule for a resource}
\usage{
codestarnotifications_update_notification_rule(
  Arn,
  Name = NULL,
  Status = NULL,
  EventTypeIds = NULL,
  Targets = NULL,
  DetailType = NULL
)
}
\arguments{
\item{Arn}{[required] The Amazon Resource Name (ARN) of the notification rule.}

\item{Name}{The name of the notification rule.}

\item{Status}{The status of the notification rule. Valid statuses include enabled
(sending notifications) or disabled (not sending notifications).}

\item{EventTypeIds}{A list of event types associated with this notification rule.}

\item{Targets}{The address and type of the targets to receive notifications from this
notification rule.}

\item{DetailType}{The level of detail to include in the notifications for this resource.
BASIC will include only the contents of the event as it would appear in
AWS CloudWatch. FULL will include any supplemental information provided
by AWS CodeStar Notifications and/or the service for the resource for
which the notification is created.}
}
\description{
Updates a notification rule for a resource. You can change the events that trigger the notification rule, the status of the rule, and the targets that receive the notifications.

See \url{https://paws-r.github.io/docs/codestarnotifications/update_notification_rule.html} for full documentation.
}
\keyword{internal}
