% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_get_comments_for_compared_commit}
\alias{codecommit_get_comments_for_compared_commit}
\title{Returns information about comments made on the comparison between two
commits}
\usage{
codecommit_get_comments_for_compared_commit(
  repositoryName,
  beforeCommitId = NULL,
  afterCommitId,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{repositoryName}{[required] The name of the repository where you want to compare commits.}

\item{beforeCommitId}{To establish the directionality of the comparison, the full commit ID of
the before commit.}

\item{afterCommitId}{[required] To establish the directionality of the comparison, the full commit ID of
the after commit.}

\item{nextToken}{An enumeration token that when provided in a request, returns the next
batch of the results.}

\item{maxResults}{A non-zero, non-negative integer used to limit the number of returned
results. The default is 100 comments, but you can configure up to 500.}
}
\description{
Returns information about comments made on the comparison between two commits.

See \url{https://www.paws-r-sdk.com/docs/codecommit_get_comments_for_compared_commit/} for full documentation.
}
\keyword{internal}
