% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worklink_operations.R
\name{worklink_describe_domain}
\alias{worklink_describe_domain}
\title{Provides information about the domain}
\usage{
worklink_describe_domain(FleetArn, DomainName)
}
\arguments{
\item{FleetArn}{[required] The ARN of the fleet.}

\item{DomainName}{[required] The name of the domain.}
}
\value{
A list with the following syntax:\preformatted{list(
  DomainName = "string",
  DisplayName = "string",
  CreatedTime = as.POSIXct(
    "2015-01-01"
  ),
  DomainStatus = "PENDING_VALIDATION"|"ASSOCIATING"|"ACTIVE"|"INACTIVE"|"DISASSOCIATING"|"DISASSOCIATED"|"FAILED_TO_ASSOCIATE"|"FAILED_TO_DISASSOCIATE",
  AcmCertificateArn = "string"
)
}
}
\description{
Provides information about the domain.
}
\section{Request syntax}{
\preformatted{svc$describe_domain(
  FleetArn = "string",
  DomainName = "string"
)
}
}

\keyword{internal}
