% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worklink_operations.R
\name{worklink_list_devices}
\alias{worklink_list_devices}
\title{Retrieves a list of devices registered with the specified fleet}
\usage{
worklink_list_devices(FleetArn, NextToken, MaxResults)
}
\arguments{
\item{FleetArn}{[required] The ARN of the fleet.}

\item{NextToken}{The pagination token used to retrieve the next page of results for this
operation. If this value is null, it retrieves the first page.}

\item{MaxResults}{The maximum number of results to be included in the next page.}
}
\value{
A list with the following syntax:\preformatted{list(
  Devices = list(
    list(
      DeviceId = "string",
      DeviceStatus = "ACTIVE"|"SIGNED_OUT"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Retrieves a list of devices registered with the specified fleet.
}
\section{Request syntax}{
\preformatted{svc$list_devices(
  FleetArn = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
