% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workmail_operations.R
\name{workmail_get_mobile_device_access_effect}
\alias{workmail_get_mobile_device_access_effect}
\title{Simulates the effect of the mobile device access rules for the given
attributes of a sample access event}
\usage{
workmail_get_mobile_device_access_effect(
  OrganizationId,
  DeviceType = NULL,
  DeviceModel = NULL,
  DeviceOperatingSystem = NULL,
  DeviceUserAgent = NULL
)
}
\arguments{
\item{OrganizationId}{[required] The Amazon WorkMail organization to simulate the access effect for.}

\item{DeviceType}{Device type the simulated user will report.}

\item{DeviceModel}{Device model the simulated user will report.}

\item{DeviceOperatingSystem}{Device operating system the simulated user will report.}

\item{DeviceUserAgent}{Device user agent the simulated user will report.}
}
\description{
Simulates the effect of the mobile device access rules for the given attributes of a sample access event. Use this method to test the effects of the current set of mobile device access rules for the Amazon WorkMail organization for a particular user's attributes.

See \url{https://paws-r.github.io/docs/workmail/get_mobile_device_access_effect.html} for full documentation.
}
\keyword{internal}
