% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_create_stack}
\alias{appstream_create_stack}
\title{Creates a stack to start streaming applications to users}
\usage{
appstream_create_stack(
  Name,
  Description = NULL,
  DisplayName = NULL,
  StorageConnectors = NULL,
  RedirectURL = NULL,
  FeedbackURL = NULL,
  UserSettings = NULL,
  ApplicationSettings = NULL,
  Tags = NULL,
  AccessEndpoints = NULL,
  EmbedHostDomains = NULL,
  StreamingExperienceSettings = NULL
)
}
\arguments{
\item{Name}{[required] The name of the stack.}

\item{Description}{The description to display.}

\item{DisplayName}{The stack name to display.}

\item{StorageConnectors}{The storage connectors to enable.}

\item{RedirectURL}{The URL that users are redirected to after their streaming session ends.}

\item{FeedbackURL}{The URL that users are redirected to after they click the Send Feedback
link. If no URL is specified, no Send Feedback link is displayed.}

\item{UserSettings}{The actions that are enabled or disabled for users during their
streaming sessions. By default, these actions are enabled.}

\item{ApplicationSettings}{The persistent application settings for users of a stack. When these
settings are enabled, changes that users make to applications and
Windows settings are automatically saved after each session and applied
to the next session.}

\item{Tags}{The tags to associate with the stack. A tag is a key-value pair, and the
value is optional. For example, Environment=Test. If you do not specify
a value, Environment=.

If you do not specify a value, the value is set to an empty string.

Generally allowed characters are: letters, numbers, and spaces
representable in UTF-8, and the following special characters:

_ . : / = + \\ - @

For more information about tags, see \href{https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html}{Tagging Your Resources}
in the \emph{Amazon AppStream 2.0 Administration Guide}.}

\item{AccessEndpoints}{The list of interface VPC endpoint (interface endpoint) objects. Users
of the stack can connect to AppStream 2.0 only through the specified
endpoints.}

\item{EmbedHostDomains}{The domains where AppStream 2.0 streaming sessions can be embedded in an
iframe. You must approve the domains that you want to host embedded
AppStream 2.0 streaming sessions.}

\item{StreamingExperienceSettings}{The streaming protocol you want your stack to prefer. This can be UDP or
TCP. Currently, UDP is only supported in the Windows native client.}
}
\description{
Creates a stack to start streaming applications to users. A stack consists of an associated fleet, user access policies, and storage configurations.

See \url{https://www.paws-r-sdk.com/docs/appstream_create_stack/} for full documentation.
}
\keyword{internal}
