% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_delete_tags}
\alias{sagemaker_delete_tags}
\title{Deletes the specified tags from an Amazon SageMaker resource}
\usage{
sagemaker_delete_tags(ResourceArn, TagKeys)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the resource whose tags you want to
delete.}

\item{TagKeys}{[required] An array or one or more tag keys to delete.}
}
\description{
Deletes the specified tags from an Amazon SageMaker resource.

To list a resource's tags, use the \code{ListTags} API.

When you call this API to delete tags from a hyperparameter tuning job,
the deleted tags are not removed from training jobs that the
hyperparameter tuning job launched before you called this API.
}
\section{Request syntax}{
\preformatted{svc$delete_tags(
  ResourceArn = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\keyword{internal}
