% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning_operations.R
\name{machinelearning_delete_realtime_endpoint}
\alias{machinelearning_delete_realtime_endpoint}
\title{Deletes a real time endpoint of an MLModel}
\usage{
machinelearning_delete_realtime_endpoint(MLModelId)
}
\arguments{
\item{MLModelId}{[required] The ID assigned to the \code{MLModel} during creation.}
}
\value{
A list with the following syntax:\preformatted{list(
  MLModelId = "string",
  RealtimeEndpointInfo = list(
    PeakRequestsPerSecond = 123,
    CreatedAt = as.POSIXct(
      "2015-01-01"
    ),
    EndpointUrl = "string",
    EndpointStatus = "NONE"|"READY"|"UPDATING"|"FAILED"
  )
)
}
}
\description{
Deletes a real time endpoint of an \code{MLModel}.
}
\section{Request syntax}{
\preformatted{svc$delete_realtime_endpoint(
  MLModelId = "string"
)
}
}

\keyword{internal}
