% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning_operations.R
\name{machinelearning_get_evaluation}
\alias{machinelearning_get_evaluation}
\title{Returns an Evaluation that includes metadata as well as the current
status of the Evaluation}
\usage{
machinelearning_get_evaluation(EvaluationId)
}
\arguments{
\item{EvaluationId}{[required] The ID of the \code{Evaluation} to retrieve. The evaluation of each \code{MLModel}
is recorded and cataloged. The ID provides the means to access the
information.}
}
\value{
A list with the following syntax:\preformatted{list(
  EvaluationId = "string",
  MLModelId = "string",
  EvaluationDataSourceId = "string",
  InputDataLocationS3 = "string",
  CreatedByIamUser = "string",
  CreatedAt = as.POSIXct(
    "2015-01-01"
  ),
  LastUpdatedAt = as.POSIXct(
    "2015-01-01"
  ),
  Name = "string",
  Status = "PENDING"|"INPROGRESS"|"FAILED"|"COMPLETED"|"DELETED",
  PerformanceMetrics = list(
    Properties = list(
      "string"
    )
  ),
  LogUri = "string",
  Message = "string",
  ComputeTime = 123,
  FinishedAt = as.POSIXct(
    "2015-01-01"
  ),
  StartedAt = as.POSIXct(
    "2015-01-01"
  )
)
}
}
\description{
Returns an \code{Evaluation} that includes metadata as well as the current
status of the \code{Evaluation}.
}
\section{Request syntax}{
\preformatted{svc$get_evaluation(
  EvaluationId = "string"
)
}
}

\keyword{internal}
