% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_human_task_ui}
\alias{sagemaker_create_human_task_ui}
\title{Defines the settings you will use for the human review workflow user
interface}
\usage{
sagemaker_create_human_task_ui(HumanTaskUiName, UiTemplate, Tags)
}
\arguments{
\item{HumanTaskUiName}{[required] The name of the user interface you are creating.}

\item{UiTemplate}{[required]}

\item{Tags}{An array of key-value pairs that contain metadata to help you categorize
and organize a human review workflow user interface. Each tag consists
of a key and a value, both of which you define.}
}
\value{
A list with the following syntax:\preformatted{list(
  HumanTaskUiArn = "string"
)
}
}
\description{
Defines the settings you will use for the human review workflow user
interface. Reviewers will see a three-panel interface with an
instruction area, the item to review, and an input area.
}
\section{Request syntax}{
\preformatted{svc$create_human_task_ui(
  HumanTaskUiName = "string",
  UiTemplate = list(
    Content = "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
