% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_pipeline_parameters_for_execution}
\alias{sagemaker_list_pipeline_parameters_for_execution}
\title{Gets a list of parameters for a pipeline execution}
\usage{
sagemaker_list_pipeline_parameters_for_execution(PipelineExecutionArn,
  NextToken, MaxResults)
}
\arguments{
\item{PipelineExecutionArn}{[required] The Amazon Resource Name (ARN) of the pipeline execution.}

\item{NextToken}{If the result of the previous
\code{\link[=sagemaker_list_pipeline_parameters_for_execution]{list_pipeline_parameters_for_execution}}
request was truncated, the response includes a \code{NextToken}. To retrieve
the next set of parameters, use the token in the next request.}

\item{MaxResults}{The maximum number of parameters to return in the response.}
}
\value{
A list with the following syntax:\preformatted{list(
  PipelineParameters = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Gets a list of parameters for a pipeline execution.
}
\section{Request syntax}{
\preformatted{svc$list_pipeline_parameters_for_execution(
  PipelineExecutionArn = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
