% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_stop_dominant_language_detection_job}
\alias{comprehend_stop_dominant_language_detection_job}
\title{Stops a dominant language detection job in progress}
\usage{
comprehend_stop_dominant_language_detection_job(JobId)
}
\arguments{
\item{JobId}{[required] The identifier of the dominant language detection job to stop.}
}
\value{
A list with the following syntax:\preformatted{list(
  JobId = "string",
  JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"FAILED"|"STOP_REQUESTED"|"STOPPED"
)
}
}
\description{
Stops a dominant language detection job in progress.

If the job state is \code{IN_PROGRESS} the job is marked for termination and
put into the \code{STOP_REQUESTED} state. If the job completes before it can
be stopped, it is put into the \code{COMPLETED} state; otherwise the job is
stopped and put into the \code{STOPPED} state.

If the job is in the \code{COMPLETED} or \code{FAILED} state when you call the
\code{\link[=comprehend_stop_dominant_language_detection_job]{stop_dominant_language_detection_job}}
operation, the operation returns a 400 Internal Request Exception.

When a job is stopped, any documents already processed are written to
the output location.
}
\section{Request syntax}{
\preformatted{svc$stop_dominant_language_detection_job(
  JobId = "string"
)
}
}

\keyword{internal}
