# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Lex Runtime V2
#'
#' @description
#' This section contains documentation for the Amazon Lex V2 Runtime V2 API
#' operations.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- lexruntimev2(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- lexruntimev2()
#' svc$delete_session(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=lexruntimev2_delete_session]{delete_session} \tab Removes session information for a specified bot, alias, and user ID\cr
#'  \link[=lexruntimev2_get_session]{get_session} \tab Returns session information for a specified bot, alias, and user\cr
#'  \link[=lexruntimev2_put_session]{put_session} \tab Creates a new session or modifies an existing session with an Amazon Lex V2 bot\cr
#'  \link[=lexruntimev2_recognize_text]{recognize_text} \tab Sends user input to Amazon Lex V2\cr
#'  \link[=lexruntimev2_recognize_utterance]{recognize_utterance} \tab Sends user input to Amazon Lex V2
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname lexruntimev2
#' @export
lexruntimev2 <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .lexruntimev2$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.lexruntimev2 <- list()

.lexruntimev2$operations <- list()

.lexruntimev2$metadata <- list(
  service_name = "lexruntimev2",
  endpoints = list("*" = list(endpoint = "runtime-v2-lex.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "runtime-v2-lex.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "runtime-v2-lex.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "runtime-v2-lex.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Lex Runtime V2",
  api_version = "2020-08-07",
  signing_name = "lex",
  json_version = "1.1",
  target_prefix = ""
)

.lexruntimev2$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.lexruntimev2$metadata, handlers, config)
}
