# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Personalize Events
#'
#' @description
#' Amazon Personalize can consume real-time user event data, such as
#' *stream* or *click* data, and use it for model training either alone or
#' combined with historical data. For more information see [Recording item
#' interaction
#' events](https://docs.aws.amazon.com/personalize/latest/dg/recording-item-interaction-events.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- personalizeevents(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- personalizeevents()
#' svc$put_action_interactions(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=personalizeevents_put_action_interactions]{put_action_interactions} \tab Records action interaction event data\cr
#'  \link[=personalizeevents_put_actions]{put_actions} \tab Adds one or more actions to an Actions dataset\cr
#'  \link[=personalizeevents_put_events]{put_events} \tab Records item interaction event data\cr
#'  \link[=personalizeevents_put_items]{put_items} \tab Adds one or more items to an Items dataset\cr
#'  \link[=personalizeevents_put_users]{put_users} \tab Adds one or more users to a Users dataset
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname personalizeevents
#' @export
personalizeevents <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .personalizeevents$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.personalizeevents <- list()

.personalizeevents$operations <- list()

.personalizeevents$metadata <- list(
  service_name = "personalizeevents",
  endpoints = list("*" = list(endpoint = "personalize-events.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "personalize-events.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "personalize-events.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "personalize-events.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "personalize-events.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "personalize-events.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Personalize Events",
  api_version = "2018-03-22",
  signing_name = "personalize",
  json_version = "1.1",
  target_prefix = ""
)

.personalizeevents$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.personalizeevents$metadata, handlers, config)
}
