% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frauddetector_operations.R
\name{frauddetector_get_rules}
\alias{frauddetector_get_rules}
\title{Get all rules for a detector (paginated) if ruleId and ruleVersion are
not specified}
\usage{
frauddetector_get_rules(
  ruleId = NULL,
  detectorId,
  ruleVersion = NULL,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{ruleId}{The rule ID.}

\item{detectorId}{[required] The detector ID.}

\item{ruleVersion}{The rule version.}

\item{nextToken}{The next page token.}

\item{maxResults}{The maximum number of rules to return for the request.}
}
\description{
Get all rules for a detector (paginated) if \code{ruleId} and \code{ruleVersion} are not specified. Gets all rules for the detector and the \code{ruleId} if present (paginated). Gets a specific rule if both the \code{ruleId} and the \code{ruleVersion} are specified.

See \url{https://www.paws-r-sdk.com/docs/frauddetector_get_rules/} for full documentation.
}
\keyword{internal}
