% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemakergeospatialcapabilities_operations.R
\name{sagemakergeospatialcapabilities_get_tile}
\alias{sagemakergeospatialcapabilities_get_tile}
\title{Gets a web mercator tile for the given Earth Observation job}
\usage{
sagemakergeospatialcapabilities_get_tile(
  Arn,
  ExecutionRoleArn = NULL,
  ImageAssets,
  ImageMask = NULL,
  OutputDataType = NULL,
  OutputFormat = NULL,
  PropertyFilters = NULL,
  Target,
  TimeRangeFilter = NULL,
  x,
  y,
  z
)
}
\arguments{
\item{Arn}{[required] The Amazon Resource Name (ARN) of the tile operation.}

\item{ExecutionRoleArn}{The Amazon Resource Name (ARN) of the IAM role that you specify.}

\item{ImageAssets}{[required] The particular assets or bands to tile.}

\item{ImageMask}{Determines whether or not to return a valid data mask.}

\item{OutputDataType}{The output data type of the tile operation.}

\item{OutputFormat}{The data format of the output tile. The formats include .npy, .png and
.jpg.}

\item{PropertyFilters}{Property filters for the imagery to tile.}

\item{Target}{[required] Determines what part of the Earth Observation job to tile. 'INPUT' or
'OUTPUT' are the valid options.}

\item{TimeRangeFilter}{Time range filter applied to imagery to find the images to tile.}

\item{x}{[required] The x coordinate of the tile input.}

\item{y}{[required] The y coordinate of the tile input.}

\item{z}{[required] The z coordinate of the tile input.}
}
\description{
Gets a web mercator tile for the given Earth Observation job.

See \url{https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_get_tile/} for full documentation.
}
\keyword{internal}
