% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_edge_deployment_plans}
\alias{sagemaker_list_edge_deployment_plans}
\title{Lists all edge deployment plans}
\usage{
sagemaker_list_edge_deployment_plans(
  NextToken = NULL,
  MaxResults = NULL,
  CreationTimeAfter = NULL,
  CreationTimeBefore = NULL,
  LastModifiedTimeAfter = NULL,
  LastModifiedTimeBefore = NULL,
  NameContains = NULL,
  DeviceFleetNameContains = NULL,
  SortBy = NULL,
  SortOrder = NULL
)
}
\arguments{
\item{NextToken}{The response from the last list when returning a list large enough to
need tokening.}

\item{MaxResults}{The maximum number of results to select (50 by default).}

\item{CreationTimeAfter}{Selects edge deployment plans created after this time.}

\item{CreationTimeBefore}{Selects edge deployment plans created before this time.}

\item{LastModifiedTimeAfter}{Selects edge deployment plans that were last updated after this time.}

\item{LastModifiedTimeBefore}{Selects edge deployment plans that were last updated before this time.}

\item{NameContains}{Selects edge deployment plans with names containing this name.}

\item{DeviceFleetNameContains}{Selects edge deployment plans with a device fleet name containing this
name.}

\item{SortBy}{The column by which to sort the edge deployment plans. Can be one of
\code{NAME}, \code{DEVICEFLEETNAME}, \code{CREATIONTIME}, \code{LASTMODIFIEDTIME}.}

\item{SortOrder}{The direction of the sorting (ascending or descending).}
}
\description{
Lists all edge deployment plans.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_list_edge_deployment_plans/} for full documentation.
}
\keyword{internal}
