% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_optimization_jobs}
\alias{sagemaker_list_optimization_jobs}
\title{Lists the optimization jobs in your account and their properties}
\usage{
sagemaker_list_optimization_jobs(
  NextToken = NULL,
  MaxResults = NULL,
  CreationTimeAfter = NULL,
  CreationTimeBefore = NULL,
  LastModifiedTimeAfter = NULL,
  LastModifiedTimeBefore = NULL,
  OptimizationContains = NULL,
  NameContains = NULL,
  StatusEquals = NULL,
  SortBy = NULL,
  SortOrder = NULL
)
}
\arguments{
\item{NextToken}{A token that you use to get the next set of results following a
truncated response. If the response to the previous request was
truncated, that response provides the value for this token.}

\item{MaxResults}{The maximum number of optimization jobs to return in the response. The
default is 50.}

\item{CreationTimeAfter}{Filters the results to only those optimization jobs that were created
after the specified time.}

\item{CreationTimeBefore}{Filters the results to only those optimization jobs that were created
before the specified time.}

\item{LastModifiedTimeAfter}{Filters the results to only those optimization jobs that were updated
after the specified time.}

\item{LastModifiedTimeBefore}{Filters the results to only those optimization jobs that were updated
before the specified time.}

\item{OptimizationContains}{Filters the results to only those optimization jobs that apply the
specified optimization techniques. You can specify either \code{Quantization}
or \code{Compilation}.}

\item{NameContains}{Filters the results to only those optimization jobs with a name that
contains the specified string.}

\item{StatusEquals}{Filters the results to only those optimization jobs with the specified
status.}

\item{SortBy}{The field by which to sort the optimization jobs in the response. The
default is \code{CreationTime}}

\item{SortOrder}{The sort order for results. The default is \code{Ascending}}
}
\description{
Lists the optimization jobs in your account and their properties.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_list_optimization_jobs/} for full documentation.
}
\keyword{internal}
