# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include bedrock_service.R
NULL

#' Deletes a batch of evaluation jobs
#'
#' @description
#' Deletes a batch of evaluation jobs. An evaluation job can only be deleted if it has following status `FAILED`, `COMPLETED`, and `STOPPED`. You can request up to 25 model evaluation jobs be deleted in a single request.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_batch_delete_evaluation_job/](https://www.paws-r-sdk.com/docs/bedrock_batch_delete_evaluation_job/) for full documentation.
#'
#' @param jobIdentifiers &#91;required&#93; A list of one or more evaluation job Amazon Resource Names (ARNs) you
#' want to delete.
#'
#' @keywords internal
#'
#' @rdname bedrock_batch_delete_evaluation_job
bedrock_batch_delete_evaluation_job <- function(jobIdentifiers) {
  op <- new_operation(
    name = "BatchDeleteEvaluationJob",
    http_method = "POST",
    http_path = "/evaluation-jobs/batch-delete",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$batch_delete_evaluation_job_input(jobIdentifiers = jobIdentifiers)
  output <- .bedrock$batch_delete_evaluation_job_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$batch_delete_evaluation_job <- bedrock_batch_delete_evaluation_job

#' Creates an evaluation job
#'
#' @description
#' Creates an evaluation job.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_create_evaluation_job/](https://www.paws-r-sdk.com/docs/bedrock_create_evaluation_job/) for full documentation.
#'
#' @param jobName &#91;required&#93; A name for the evaluation job. Names must unique with your Amazon Web
#' Services account, and your account's Amazon Web Services region.
#' @param jobDescription A description of the evaluation job.
#' @param clientRequestToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than one time. If this token matches a previous
#' request, Amazon Bedrock ignores the request, but does not return an
#' error. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM service role that Amazon
#' Bedrock can assume to perform tasks on your behalf. To learn more about
#' the required permissions, see [Required permissions for model
#' evaluations](https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-security-service-roles.html).
#' @param customerEncryptionKeyId Specify your customer managed encryption key Amazon Resource Name (ARN)
#' that will be used to encrypt your evaluation job.
#' @param jobTags Tags to attach to the model evaluation job.
#' @param applicationType Specifies whether the evaluation job is for evaluating a model or
#' evaluating a knowledge base (retrieval and response generation).
#' @param evaluationConfig &#91;required&#93; Contains the configuration details of either an automated or human-based
#' evaluation job.
#' @param inferenceConfig &#91;required&#93; Contains the configuration details of the inference model for the
#' evaluation job.
#' 
#' For model evaluation jobs, automated jobs support a single model or
#' [inference
#' profile](https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html),
#' and jobs that use human workers support two models or inference
#' profiles.
#' @param outputDataConfig &#91;required&#93; Contains the configuration details of the Amazon S3 bucket for storing
#' the results of the evaluation job.
#'
#' @keywords internal
#'
#' @rdname bedrock_create_evaluation_job
bedrock_create_evaluation_job <- function(jobName, jobDescription = NULL, clientRequestToken = NULL, roleArn, customerEncryptionKeyId = NULL, jobTags = NULL, applicationType = NULL, evaluationConfig, inferenceConfig, outputDataConfig) {
  op <- new_operation(
    name = "CreateEvaluationJob",
    http_method = "POST",
    http_path = "/evaluation-jobs",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$create_evaluation_job_input(jobName = jobName, jobDescription = jobDescription, clientRequestToken = clientRequestToken, roleArn = roleArn, customerEncryptionKeyId = customerEncryptionKeyId, jobTags = jobTags, applicationType = applicationType, evaluationConfig = evaluationConfig, inferenceConfig = inferenceConfig, outputDataConfig = outputDataConfig)
  output <- .bedrock$create_evaluation_job_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$create_evaluation_job <- bedrock_create_evaluation_job

#' Creates a guardrail to block topics and to implement safeguards for your
#' generative AI applications
#'
#' @description
#' Creates a guardrail to block topics and to implement safeguards for your generative AI applications.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_create_guardrail/](https://www.paws-r-sdk.com/docs/bedrock_create_guardrail/) for full documentation.
#'
#' @param name &#91;required&#93; The name to give the guardrail.
#' @param description A description of the guardrail.
#' @param topicPolicyConfig The topic policies to configure for the guardrail.
#' @param contentPolicyConfig The content filter policies to configure for the guardrail.
#' @param wordPolicyConfig The word policy you configure for the guardrail.
#' @param sensitiveInformationPolicyConfig The sensitive information policy to configure for the guardrail.
#' @param contextualGroundingPolicyConfig The contextual grounding policy configuration used to create a
#' guardrail.
#' @param blockedInputMessaging &#91;required&#93; The message to return when the guardrail blocks a prompt.
#' @param blockedOutputsMessaging &#91;required&#93; The message to return when the guardrail blocks a model response.
#' @param kmsKeyId The ARN of the KMS key that you use to encrypt the guardrail.
#' @param tags The tags that you want to attach to the guardrail.
#' @param clientRequestToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than once. If this token matches a previous request,
#' Amazon Bedrock ignores the request, but does not return an error. For
#' more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html)
#' in the *Amazon S3 User Guide*.
#'
#' @keywords internal
#'
#' @rdname bedrock_create_guardrail
bedrock_create_guardrail <- function(name, description = NULL, topicPolicyConfig = NULL, contentPolicyConfig = NULL, wordPolicyConfig = NULL, sensitiveInformationPolicyConfig = NULL, contextualGroundingPolicyConfig = NULL, blockedInputMessaging, blockedOutputsMessaging, kmsKeyId = NULL, tags = NULL, clientRequestToken = NULL) {
  op <- new_operation(
    name = "CreateGuardrail",
    http_method = "POST",
    http_path = "/guardrails",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$create_guardrail_input(name = name, description = description, topicPolicyConfig = topicPolicyConfig, contentPolicyConfig = contentPolicyConfig, wordPolicyConfig = wordPolicyConfig, sensitiveInformationPolicyConfig = sensitiveInformationPolicyConfig, contextualGroundingPolicyConfig = contextualGroundingPolicyConfig, blockedInputMessaging = blockedInputMessaging, blockedOutputsMessaging = blockedOutputsMessaging, kmsKeyId = kmsKeyId, tags = tags, clientRequestToken = clientRequestToken)
  output <- .bedrock$create_guardrail_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$create_guardrail <- bedrock_create_guardrail

#' Creates a version of the guardrail
#'
#' @description
#' Creates a version of the guardrail. Use this API to create a snapshot of the guardrail when you are satisfied with a configuration, or to compare the configuration with another version.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_create_guardrail_version/](https://www.paws-r-sdk.com/docs/bedrock_create_guardrail_version/) for full documentation.
#'
#' @param guardrailIdentifier &#91;required&#93; The unique identifier of the guardrail. This can be an ID or the ARN.
#' @param description A description of the guardrail version.
#' @param clientRequestToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than once. If this token matches a previous request,
#' Amazon Bedrock ignores the request, but does not return an error. For
#' more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html)
#' in the *Amazon S3 User Guide*.
#'
#' @keywords internal
#'
#' @rdname bedrock_create_guardrail_version
bedrock_create_guardrail_version <- function(guardrailIdentifier, description = NULL, clientRequestToken = NULL) {
  op <- new_operation(
    name = "CreateGuardrailVersion",
    http_method = "POST",
    http_path = "/guardrails/{guardrailIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$create_guardrail_version_input(guardrailIdentifier = guardrailIdentifier, description = description, clientRequestToken = clientRequestToken)
  output <- .bedrock$create_guardrail_version_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$create_guardrail_version <- bedrock_create_guardrail_version

#' Creates an application inference profile to track metrics and costs when
#' invoking a model
#'
#' @description
#' Creates an application inference profile to track metrics and costs when invoking a model. To create an application inference profile for a foundation model in one region, specify the ARN of the model in that region. To create an application inference profile for a foundation model across multiple regions, specify the ARN of the system-defined inference profile that contains the regions that you want to route requests to. For more information, see [Increase throughput and resilience with cross-region inference in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html). in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_create_inference_profile/](https://www.paws-r-sdk.com/docs/bedrock_create_inference_profile/) for full documentation.
#'
#' @param inferenceProfileName &#91;required&#93; A name for the inference profile.
#' @param description A description for the inference profile.
#' @param clientRequestToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than one time. If this token matches a previous
#' request, Amazon Bedrock ignores the request, but does not return an
#' error. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param modelSource &#91;required&#93; The foundation model or system-defined inference profile that the
#' inference profile will track metrics and costs for.
#' @param tags An array of objects, each of which contains a tag and its value. For
#' more information, see [Tagging
#' resources](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html)
#' in the [Amazon Bedrock User
#' Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' @keywords internal
#'
#' @rdname bedrock_create_inference_profile
bedrock_create_inference_profile <- function(inferenceProfileName, description = NULL, clientRequestToken = NULL, modelSource, tags = NULL) {
  op <- new_operation(
    name = "CreateInferenceProfile",
    http_method = "POST",
    http_path = "/inference-profiles",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$create_inference_profile_input(inferenceProfileName = inferenceProfileName, description = description, clientRequestToken = clientRequestToken, modelSource = modelSource, tags = tags)
  output <- .bedrock$create_inference_profile_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$create_inference_profile <- bedrock_create_inference_profile

#' Creates an endpoint for a model from Amazon Bedrock Marketplace
#'
#' @description
#' Creates an endpoint for a model from Amazon Bedrock Marketplace. The endpoint is hosted by Amazon SageMaker.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_create_marketplace_model_endpoint/](https://www.paws-r-sdk.com/docs/bedrock_create_marketplace_model_endpoint/) for full documentation.
#'
#' @param modelSourceIdentifier &#91;required&#93; The ARN of the model from Amazon Bedrock Marketplace that you want to
#' deploy to the endpoint.
#' @param endpointConfig &#91;required&#93; The configuration for the endpoint, including the number and type of
#' instances to use.
#' @param acceptEula Indicates whether you accept the end-user license agreement (EULA) for
#' the model. Set to `true` to accept the EULA.
#' @param endpointName &#91;required&#93; The name of the endpoint. This name must be unique within your Amazon
#' Web Services account and region.
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. This token is listed as not required because
#' Amazon Web Services SDKs automatically generate it for you and set this
#' parameter. If you're not using the Amazon Web Services SDK or the CLI,
#' you must provide this token or the action will fail.
#' @param tags An array of key-value pairs to apply to the underlying Amazon SageMaker
#' endpoint. You can use these tags to organize and identify your Amazon
#' Web Services resources.
#'
#' @keywords internal
#'
#' @rdname bedrock_create_marketplace_model_endpoint
bedrock_create_marketplace_model_endpoint <- function(modelSourceIdentifier, endpointConfig, acceptEula = NULL, endpointName, clientRequestToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateMarketplaceModelEndpoint",
    http_method = "POST",
    http_path = "/marketplace-model/endpoints",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$create_marketplace_model_endpoint_input(modelSourceIdentifier = modelSourceIdentifier, endpointConfig = endpointConfig, acceptEula = acceptEula, endpointName = endpointName, clientRequestToken = clientRequestToken, tags = tags)
  output <- .bedrock$create_marketplace_model_endpoint_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$create_marketplace_model_endpoint <- bedrock_create_marketplace_model_endpoint

#' Copies a model to another region so that it can be used there
#'
#' @description
#' Copies a model to another region so that it can be used there. For more information, see [Copy models to be used in other regions](https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_create_model_copy_job/](https://www.paws-r-sdk.com/docs/bedrock_create_model_copy_job/) for full documentation.
#'
#' @param sourceModelArn &#91;required&#93; The Amazon Resource Name (ARN) of the model to be copied.
#' @param targetModelName &#91;required&#93; A name for the copied model.
#' @param modelKmsKeyId The ARN of the KMS key that you use to encrypt the model copy.
#' @param targetModelTags Tags to associate with the target model. For more information, see [Tag
#' resources](https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html)
#' in the [Amazon Bedrock User
#' Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#' @param clientRequestToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than one time. If this token matches a previous
#' request, Amazon Bedrock ignores the request, but does not return an
#' error. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#'
#' @keywords internal
#'
#' @rdname bedrock_create_model_copy_job
bedrock_create_model_copy_job <- function(sourceModelArn, targetModelName, modelKmsKeyId = NULL, targetModelTags = NULL, clientRequestToken = NULL) {
  op <- new_operation(
    name = "CreateModelCopyJob",
    http_method = "POST",
    http_path = "/model-copy-jobs",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$create_model_copy_job_input(sourceModelArn = sourceModelArn, targetModelName = targetModelName, modelKmsKeyId = modelKmsKeyId, targetModelTags = targetModelTags, clientRequestToken = clientRequestToken)
  output <- .bedrock$create_model_copy_job_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$create_model_copy_job <- bedrock_create_model_copy_job

#' Creates a fine-tuning job to customize a base model
#'
#' @description
#' Creates a fine-tuning job to customize a base model.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_create_model_customization_job/](https://www.paws-r-sdk.com/docs/bedrock_create_model_customization_job/) for full documentation.
#'
#' @param jobName &#91;required&#93; A name for the fine-tuning job.
#' @param customModelName &#91;required&#93; A name for the resulting custom model.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM service role that Amazon
#' Bedrock can assume to perform tasks on your behalf. For example, during
#' model training, Amazon Bedrock needs your permission to read input data
#' from an S3 bucket, write model artifacts to an S3 bucket. To pass this
#' role to Amazon Bedrock, the caller of this API must have the
#' `iam:PassRole` permission.
#' @param clientRequestToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than one time. If this token matches a previous
#' request, Amazon Bedrock ignores the request, but does not return an
#' error. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param baseModelIdentifier &#91;required&#93; Name of the base model.
#' @param customizationType The customization type.
#' @param customModelKmsKeyId The custom model is encrypted at rest using this key.
#' @param jobTags Tags to attach to the job.
#' @param customModelTags Tags to attach to the resulting custom model.
#' @param trainingDataConfig &#91;required&#93; Information about the training dataset.
#' @param validationDataConfig Information about the validation dataset.
#' @param outputDataConfig &#91;required&#93; S3 location for the output data.
#' @param hyperParameters Parameters related to tuning the model. For details on the format for
#' different models, see [Custom model
#' hyperparameters](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html).
#' @param vpcConfig The configuration of the Virtual Private Cloud (VPC) that contains the
#' resources that you're using for this job. For more information, see
#' [Protect your model customization jobs using a
#' VPC](https://docs.aws.amazon.com/bedrock/latest/userguide/vpc-model-customization.html).
#' @param customizationConfig The customization configuration for the model customization job.
#'
#' @keywords internal
#'
#' @rdname bedrock_create_model_customization_job
bedrock_create_model_customization_job <- function(jobName, customModelName, roleArn, clientRequestToken = NULL, baseModelIdentifier, customizationType = NULL, customModelKmsKeyId = NULL, jobTags = NULL, customModelTags = NULL, trainingDataConfig, validationDataConfig = NULL, outputDataConfig, hyperParameters = NULL, vpcConfig = NULL, customizationConfig = NULL) {
  op <- new_operation(
    name = "CreateModelCustomizationJob",
    http_method = "POST",
    http_path = "/model-customization-jobs",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$create_model_customization_job_input(jobName = jobName, customModelName = customModelName, roleArn = roleArn, clientRequestToken = clientRequestToken, baseModelIdentifier = baseModelIdentifier, customizationType = customizationType, customModelKmsKeyId = customModelKmsKeyId, jobTags = jobTags, customModelTags = customModelTags, trainingDataConfig = trainingDataConfig, validationDataConfig = validationDataConfig, outputDataConfig = outputDataConfig, hyperParameters = hyperParameters, vpcConfig = vpcConfig, customizationConfig = customizationConfig)
  output <- .bedrock$create_model_customization_job_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$create_model_customization_job <- bedrock_create_model_customization_job

#' Creates a model import job to import model that you have customized in
#' other environments, such as Amazon SageMaker
#'
#' @description
#' Creates a model import job to import model that you have customized in other environments, such as Amazon SageMaker. For more information, see [Import a customized model](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html)
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_create_model_import_job/](https://www.paws-r-sdk.com/docs/bedrock_create_model_import_job/) for full documentation.
#'
#' @param jobName &#91;required&#93; The name of the import job.
#' @param importedModelName &#91;required&#93; The name of the imported model.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of the model import job.
#' @param modelDataSource &#91;required&#93; The data source for the imported model.
#' @param jobTags Tags to attach to this import job.
#' @param importedModelTags Tags to attach to the imported model.
#' @param clientRequestToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than one time. If this token matches a previous
#' request, Amazon Bedrock ignores the request, but does not return an
#' error. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param vpcConfig VPC configuration parameters for the private Virtual Private Cloud (VPC)
#' that contains the resources you are using for the import job.
#' @param importedModelKmsKeyId The imported model is encrypted at rest using this key.
#'
#' @keywords internal
#'
#' @rdname bedrock_create_model_import_job
bedrock_create_model_import_job <- function(jobName, importedModelName, roleArn, modelDataSource, jobTags = NULL, importedModelTags = NULL, clientRequestToken = NULL, vpcConfig = NULL, importedModelKmsKeyId = NULL) {
  op <- new_operation(
    name = "CreateModelImportJob",
    http_method = "POST",
    http_path = "/model-import-jobs",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$create_model_import_job_input(jobName = jobName, importedModelName = importedModelName, roleArn = roleArn, modelDataSource = modelDataSource, jobTags = jobTags, importedModelTags = importedModelTags, clientRequestToken = clientRequestToken, vpcConfig = vpcConfig, importedModelKmsKeyId = importedModelKmsKeyId)
  output <- .bedrock$create_model_import_job_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$create_model_import_job <- bedrock_create_model_import_job

#' Creates a batch inference job to invoke a model on multiple prompts
#'
#' @description
#' Creates a batch inference job to invoke a model on multiple prompts. Format your data according to [Format your inference data](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data.html) and upload it to an Amazon S3 bucket. For more information, see [Process multiple prompts with batch inference](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_create_model_invocation_job/](https://www.paws-r-sdk.com/docs/bedrock_create_model_invocation_job/) for full documentation.
#'
#' @param jobName &#91;required&#93; A name to give the batch inference job.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of the service role with permissions to
#' carry out and manage batch inference. You can use the console to create
#' a default service role or follow the steps at [Create a service role for
#' batch
#' inference](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-iam-sr.html).
#' @param clientRequestToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than one time. If this token matches a previous
#' request, Amazon Bedrock ignores the request, but does not return an
#' error. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param modelId &#91;required&#93; The unique identifier of the foundation model to use for the batch
#' inference job.
#' @param inputDataConfig &#91;required&#93; Details about the location of the input to the batch inference job.
#' @param outputDataConfig &#91;required&#93; Details about the location of the output of the batch inference job.
#' @param vpcConfig The configuration of the Virtual Private Cloud (VPC) for the data in the
#' batch inference job. For more information, see [Protect batch inference
#' jobs using a
#' VPC](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-vpc.html).
#' @param timeoutDurationInHours The number of hours after which to force the batch inference job to time
#' out.
#' @param tags Any tags to associate with the batch inference job. For more
#' information, see [Tagging Amazon Bedrock
#' resources](https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html).
#'
#' @keywords internal
#'
#' @rdname bedrock_create_model_invocation_job
bedrock_create_model_invocation_job <- function(jobName, roleArn, clientRequestToken = NULL, modelId, inputDataConfig, outputDataConfig, vpcConfig = NULL, timeoutDurationInHours = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateModelInvocationJob",
    http_method = "POST",
    http_path = "/model-invocation-job",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$create_model_invocation_job_input(jobName = jobName, roleArn = roleArn, clientRequestToken = clientRequestToken, modelId = modelId, inputDataConfig = inputDataConfig, outputDataConfig = outputDataConfig, vpcConfig = vpcConfig, timeoutDurationInHours = timeoutDurationInHours, tags = tags)
  output <- .bedrock$create_model_invocation_job_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$create_model_invocation_job <- bedrock_create_model_invocation_job

#' Creates dedicated throughput for a base or custom model with the model
#' units and for the duration that you specify
#'
#' @description
#' Creates dedicated throughput for a base or custom model with the model units and for the duration that you specify. For pricing details, see [Amazon Bedrock Pricing](https://aws.amazon.com/bedrock/pricing/). For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_create_provisioned_model_throughput/](https://www.paws-r-sdk.com/docs/bedrock_create_provisioned_model_throughput/) for full documentation.
#'
#' @param clientRequestToken A unique, case-sensitive identifier to ensure that the API request
#' completes no more than one time. If this token matches a previous
#' request, Amazon Bedrock ignores the request, but does not return an
#' error. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html)
#' in the Amazon S3 User Guide.
#' @param modelUnits &#91;required&#93; Number of model units to allocate. A model unit delivers a specific
#' throughput level for the specified model. The throughput level of a
#' model unit specifies the total number of input and output tokens that it
#' can process and generate within a span of one minute. By default, your
#' account has no model units for purchasing Provisioned Throughputs with
#' commitment. You must first visit the Amazon Web Services support center
#' to request MUs.
#' 
#' For model unit quotas, see [Provisioned Throughput
#' quotas](https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html#prov-thru-quotas)
#' in the [Amazon Bedrock User
#' Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#' 
#' For more information about what an MU specifies, contact your Amazon Web
#' Services account manager.
#' @param provisionedModelName &#91;required&#93; The name for this Provisioned Throughput.
#' @param modelId &#91;required&#93; The Amazon Resource Name (ARN) or name of the model to associate with
#' this Provisioned Throughput. For a list of models for which you can
#' purchase Provisioned Throughput, see [Amazon Bedrock model IDs for
#' purchasing Provisioned
#' Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/models-supported.html#prov-throughput-models)
#' in the [Amazon Bedrock User
#' Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#' @param commitmentDuration The commitment duration requested for the Provisioned Throughput.
#' Billing occurs hourly and is discounted for longer commitment terms. To
#' request a no-commit Provisioned Throughput, omit this field.
#' 
#' Custom models support all levels of commitment. To see which base models
#' support no commitment, see [Supported regions and models for Provisioned
#' Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/pt-supported.html)
#' in the [Amazon Bedrock User
#' Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html)
#' @param tags Tags to associate with this Provisioned Throughput.
#'
#' @keywords internal
#'
#' @rdname bedrock_create_provisioned_model_throughput
bedrock_create_provisioned_model_throughput <- function(clientRequestToken = NULL, modelUnits, provisionedModelName, modelId, commitmentDuration = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateProvisionedModelThroughput",
    http_method = "POST",
    http_path = "/provisioned-model-throughput",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$create_provisioned_model_throughput_input(clientRequestToken = clientRequestToken, modelUnits = modelUnits, provisionedModelName = provisionedModelName, modelId = modelId, commitmentDuration = commitmentDuration, tags = tags)
  output <- .bedrock$create_provisioned_model_throughput_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$create_provisioned_model_throughput <- bedrock_create_provisioned_model_throughput

#' Deletes a custom model that you created earlier
#'
#' @description
#' Deletes a custom model that you created earlier. For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_delete_custom_model/](https://www.paws-r-sdk.com/docs/bedrock_delete_custom_model/) for full documentation.
#'
#' @param modelIdentifier &#91;required&#93; Name of the model to delete.
#'
#' @keywords internal
#'
#' @rdname bedrock_delete_custom_model
bedrock_delete_custom_model <- function(modelIdentifier) {
  op <- new_operation(
    name = "DeleteCustomModel",
    http_method = "DELETE",
    http_path = "/custom-models/{modelIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$delete_custom_model_input(modelIdentifier = modelIdentifier)
  output <- .bedrock$delete_custom_model_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$delete_custom_model <- bedrock_delete_custom_model

#' Deletes a guardrail
#'
#' @description
#' Deletes a guardrail.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_delete_guardrail/](https://www.paws-r-sdk.com/docs/bedrock_delete_guardrail/) for full documentation.
#'
#' @param guardrailIdentifier &#91;required&#93; The unique identifier of the guardrail. This can be an ID or the ARN.
#' @param guardrailVersion The version of the guardrail.
#'
#' @keywords internal
#'
#' @rdname bedrock_delete_guardrail
bedrock_delete_guardrail <- function(guardrailIdentifier, guardrailVersion = NULL) {
  op <- new_operation(
    name = "DeleteGuardrail",
    http_method = "DELETE",
    http_path = "/guardrails/{guardrailIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$delete_guardrail_input(guardrailIdentifier = guardrailIdentifier, guardrailVersion = guardrailVersion)
  output <- .bedrock$delete_guardrail_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$delete_guardrail <- bedrock_delete_guardrail

#' Deletes a custom model that you imported earlier
#'
#' @description
#' Deletes a custom model that you imported earlier. For more information, see [Import a customized model](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_delete_imported_model/](https://www.paws-r-sdk.com/docs/bedrock_delete_imported_model/) for full documentation.
#'
#' @param modelIdentifier &#91;required&#93; Name of the imported model to delete.
#'
#' @keywords internal
#'
#' @rdname bedrock_delete_imported_model
bedrock_delete_imported_model <- function(modelIdentifier) {
  op <- new_operation(
    name = "DeleteImportedModel",
    http_method = "DELETE",
    http_path = "/imported-models/{modelIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$delete_imported_model_input(modelIdentifier = modelIdentifier)
  output <- .bedrock$delete_imported_model_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$delete_imported_model <- bedrock_delete_imported_model

#' Deletes an application inference profile
#'
#' @description
#' Deletes an application inference profile. For more information, see [Increase throughput and resilience with cross-region inference in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html). in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_delete_inference_profile/](https://www.paws-r-sdk.com/docs/bedrock_delete_inference_profile/) for full documentation.
#'
#' @param inferenceProfileIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or ID of the application inference
#' profile to delete.
#'
#' @keywords internal
#'
#' @rdname bedrock_delete_inference_profile
bedrock_delete_inference_profile <- function(inferenceProfileIdentifier) {
  op <- new_operation(
    name = "DeleteInferenceProfile",
    http_method = "DELETE",
    http_path = "/inference-profiles/{inferenceProfileIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$delete_inference_profile_input(inferenceProfileIdentifier = inferenceProfileIdentifier)
  output <- .bedrock$delete_inference_profile_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$delete_inference_profile <- bedrock_delete_inference_profile

#' Deletes an endpoint for a model from Amazon Bedrock Marketplace
#'
#' @description
#' Deletes an endpoint for a model from Amazon Bedrock Marketplace.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_delete_marketplace_model_endpoint/](https://www.paws-r-sdk.com/docs/bedrock_delete_marketplace_model_endpoint/) for full documentation.
#'
#' @param endpointArn &#91;required&#93; The Amazon Resource Name (ARN) of the endpoint you want to delete.
#'
#' @keywords internal
#'
#' @rdname bedrock_delete_marketplace_model_endpoint
bedrock_delete_marketplace_model_endpoint <- function(endpointArn) {
  op <- new_operation(
    name = "DeleteMarketplaceModelEndpoint",
    http_method = "DELETE",
    http_path = "/marketplace-model/endpoints/{endpointArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$delete_marketplace_model_endpoint_input(endpointArn = endpointArn)
  output <- .bedrock$delete_marketplace_model_endpoint_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$delete_marketplace_model_endpoint <- bedrock_delete_marketplace_model_endpoint

#' Delete the invocation logging
#'
#' @description
#' Delete the invocation logging.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_delete_model_invocation_logging_configuration/](https://www.paws-r-sdk.com/docs/bedrock_delete_model_invocation_logging_configuration/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname bedrock_delete_model_invocation_logging_configuration
bedrock_delete_model_invocation_logging_configuration <- function() {
  op <- new_operation(
    name = "DeleteModelInvocationLoggingConfiguration",
    http_method = "DELETE",
    http_path = "/logging/modelinvocations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$delete_model_invocation_logging_configuration_input()
  output <- .bedrock$delete_model_invocation_logging_configuration_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$delete_model_invocation_logging_configuration <- bedrock_delete_model_invocation_logging_configuration

#' Deletes a Provisioned Throughput
#'
#' @description
#' Deletes a Provisioned Throughput. You can't delete a Provisioned Throughput before the commitment term is over. For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_delete_provisioned_model_throughput/](https://www.paws-r-sdk.com/docs/bedrock_delete_provisioned_model_throughput/) for full documentation.
#'
#' @param provisionedModelId &#91;required&#93; The Amazon Resource Name (ARN) or name of the Provisioned Throughput.
#'
#' @keywords internal
#'
#' @rdname bedrock_delete_provisioned_model_throughput
bedrock_delete_provisioned_model_throughput <- function(provisionedModelId) {
  op <- new_operation(
    name = "DeleteProvisionedModelThroughput",
    http_method = "DELETE",
    http_path = "/provisioned-model-throughput/{provisionedModelId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$delete_provisioned_model_throughput_input(provisionedModelId = provisionedModelId)
  output <- .bedrock$delete_provisioned_model_throughput_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$delete_provisioned_model_throughput <- bedrock_delete_provisioned_model_throughput

#' Deregisters an endpoint for a model from Amazon Bedrock Marketplace
#'
#' @description
#' Deregisters an endpoint for a model from Amazon Bedrock Marketplace. This operation removes the endpoint's association with Amazon Bedrock but does not delete the underlying Amazon SageMaker endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_deregister_marketplace_model_endpoint/](https://www.paws-r-sdk.com/docs/bedrock_deregister_marketplace_model_endpoint/) for full documentation.
#'
#' @param endpointArn &#91;required&#93; The Amazon Resource Name (ARN) of the endpoint you want to deregister.
#'
#' @keywords internal
#'
#' @rdname bedrock_deregister_marketplace_model_endpoint
bedrock_deregister_marketplace_model_endpoint <- function(endpointArn) {
  op <- new_operation(
    name = "DeregisterMarketplaceModelEndpoint",
    http_method = "DELETE",
    http_path = "/marketplace-model/endpoints/{endpointArn}/registration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$deregister_marketplace_model_endpoint_input(endpointArn = endpointArn)
  output <- .bedrock$deregister_marketplace_model_endpoint_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$deregister_marketplace_model_endpoint <- bedrock_deregister_marketplace_model_endpoint

#' Get the properties associated with a Amazon Bedrock custom model that
#' you have created
#'
#' @description
#' Get the properties associated with a Amazon Bedrock custom model that you have created.For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_get_custom_model/](https://www.paws-r-sdk.com/docs/bedrock_get_custom_model/) for full documentation.
#'
#' @param modelIdentifier &#91;required&#93; Name or Amazon Resource Name (ARN) of the custom model.
#'
#' @keywords internal
#'
#' @rdname bedrock_get_custom_model
bedrock_get_custom_model <- function(modelIdentifier) {
  op <- new_operation(
    name = "GetCustomModel",
    http_method = "GET",
    http_path = "/custom-models/{modelIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$get_custom_model_input(modelIdentifier = modelIdentifier)
  output <- .bedrock$get_custom_model_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$get_custom_model <- bedrock_get_custom_model

#' Gets information about an evaluation job, such as the status of the job
#'
#' @description
#' Gets information about an evaluation job, such as the status of the job.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_get_evaluation_job/](https://www.paws-r-sdk.com/docs/bedrock_get_evaluation_job/) for full documentation.
#'
#' @param jobIdentifier &#91;required&#93; The Amazon Resource Name (ARN) of the evaluation job you want get
#' information on.
#'
#' @keywords internal
#'
#' @rdname bedrock_get_evaluation_job
bedrock_get_evaluation_job <- function(jobIdentifier) {
  op <- new_operation(
    name = "GetEvaluationJob",
    http_method = "GET",
    http_path = "/evaluation-jobs/{jobIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$get_evaluation_job_input(jobIdentifier = jobIdentifier)
  output <- .bedrock$get_evaluation_job_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$get_evaluation_job <- bedrock_get_evaluation_job

#' Get details about a Amazon Bedrock foundation model
#'
#' @description
#' Get details about a Amazon Bedrock foundation model.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_get_foundation_model/](https://www.paws-r-sdk.com/docs/bedrock_get_foundation_model/) for full documentation.
#'
#' @param modelIdentifier &#91;required&#93; The model identifier.
#'
#' @keywords internal
#'
#' @rdname bedrock_get_foundation_model
bedrock_get_foundation_model <- function(modelIdentifier) {
  op <- new_operation(
    name = "GetFoundationModel",
    http_method = "GET",
    http_path = "/foundation-models/{modelIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$get_foundation_model_input(modelIdentifier = modelIdentifier)
  output <- .bedrock$get_foundation_model_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$get_foundation_model <- bedrock_get_foundation_model

#' Gets details about a guardrail
#'
#' @description
#' Gets details about a guardrail. If you don't specify a version, the response returns details for the `DRAFT` version.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_get_guardrail/](https://www.paws-r-sdk.com/docs/bedrock_get_guardrail/) for full documentation.
#'
#' @param guardrailIdentifier &#91;required&#93; The unique identifier of the guardrail for which to get details. This
#' can be an ID or the ARN.
#' @param guardrailVersion The version of the guardrail for which to get details. If you don't
#' specify a version, the response returns details for the `DRAFT` version.
#'
#' @keywords internal
#'
#' @rdname bedrock_get_guardrail
bedrock_get_guardrail <- function(guardrailIdentifier, guardrailVersion = NULL) {
  op <- new_operation(
    name = "GetGuardrail",
    http_method = "GET",
    http_path = "/guardrails/{guardrailIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$get_guardrail_input(guardrailIdentifier = guardrailIdentifier, guardrailVersion = guardrailVersion)
  output <- .bedrock$get_guardrail_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$get_guardrail <- bedrock_get_guardrail

#' Gets properties associated with a customized model you imported
#'
#' @description
#' Gets properties associated with a customized model you imported.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_get_imported_model/](https://www.paws-r-sdk.com/docs/bedrock_get_imported_model/) for full documentation.
#'
#' @param modelIdentifier &#91;required&#93; Name or Amazon Resource Name (ARN) of the imported model.
#'
#' @keywords internal
#'
#' @rdname bedrock_get_imported_model
bedrock_get_imported_model <- function(modelIdentifier) {
  op <- new_operation(
    name = "GetImportedModel",
    http_method = "GET",
    http_path = "/imported-models/{modelIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$get_imported_model_input(modelIdentifier = modelIdentifier)
  output <- .bedrock$get_imported_model_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$get_imported_model <- bedrock_get_imported_model

#' Gets information about an inference profile
#'
#' @description
#' Gets information about an inference profile. For more information, see [Increase throughput and resilience with cross-region inference in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html). in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_get_inference_profile/](https://www.paws-r-sdk.com/docs/bedrock_get_inference_profile/) for full documentation.
#'
#' @param inferenceProfileIdentifier &#91;required&#93; The ID or Amazon Resource Name (ARN) of the inference profile.
#'
#' @keywords internal
#'
#' @rdname bedrock_get_inference_profile
bedrock_get_inference_profile <- function(inferenceProfileIdentifier) {
  op <- new_operation(
    name = "GetInferenceProfile",
    http_method = "GET",
    http_path = "/inference-profiles/{inferenceProfileIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$get_inference_profile_input(inferenceProfileIdentifier = inferenceProfileIdentifier)
  output <- .bedrock$get_inference_profile_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$get_inference_profile <- bedrock_get_inference_profile

#' Retrieves details about a specific endpoint for a model from Amazon
#' Bedrock Marketplace
#'
#' @description
#' Retrieves details about a specific endpoint for a model from Amazon Bedrock Marketplace.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_get_marketplace_model_endpoint/](https://www.paws-r-sdk.com/docs/bedrock_get_marketplace_model_endpoint/) for full documentation.
#'
#' @param endpointArn &#91;required&#93; The Amazon Resource Name (ARN) of the endpoint you want to get
#' information about.
#'
#' @keywords internal
#'
#' @rdname bedrock_get_marketplace_model_endpoint
bedrock_get_marketplace_model_endpoint <- function(endpointArn) {
  op <- new_operation(
    name = "GetMarketplaceModelEndpoint",
    http_method = "GET",
    http_path = "/marketplace-model/endpoints/{endpointArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$get_marketplace_model_endpoint_input(endpointArn = endpointArn)
  output <- .bedrock$get_marketplace_model_endpoint_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$get_marketplace_model_endpoint <- bedrock_get_marketplace_model_endpoint

#' Retrieves information about a model copy job
#'
#' @description
#' Retrieves information about a model copy job. For more information, see [Copy models to be used in other regions](https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_get_model_copy_job/](https://www.paws-r-sdk.com/docs/bedrock_get_model_copy_job/) for full documentation.
#'
#' @param jobArn &#91;required&#93; The Amazon Resource Name (ARN) of the model copy job.
#'
#' @keywords internal
#'
#' @rdname bedrock_get_model_copy_job
bedrock_get_model_copy_job <- function(jobArn) {
  op <- new_operation(
    name = "GetModelCopyJob",
    http_method = "GET",
    http_path = "/model-copy-jobs/{jobArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$get_model_copy_job_input(jobArn = jobArn)
  output <- .bedrock$get_model_copy_job_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$get_model_copy_job <- bedrock_get_model_copy_job

#' Retrieves the properties associated with a model-customization job,
#' including the status of the job
#'
#' @description
#' Retrieves the properties associated with a model-customization job, including the status of the job. For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_get_model_customization_job/](https://www.paws-r-sdk.com/docs/bedrock_get_model_customization_job/) for full documentation.
#'
#' @param jobIdentifier &#91;required&#93; Identifier for the customization job.
#'
#' @keywords internal
#'
#' @rdname bedrock_get_model_customization_job
bedrock_get_model_customization_job <- function(jobIdentifier) {
  op <- new_operation(
    name = "GetModelCustomizationJob",
    http_method = "GET",
    http_path = "/model-customization-jobs/{jobIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$get_model_customization_job_input(jobIdentifier = jobIdentifier)
  output <- .bedrock$get_model_customization_job_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$get_model_customization_job <- bedrock_get_model_customization_job

#' Retrieves the properties associated with import model job, including the
#' status of the job
#'
#' @description
#' Retrieves the properties associated with import model job, including the status of the job. For more information, see [Import a customized model](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_get_model_import_job/](https://www.paws-r-sdk.com/docs/bedrock_get_model_import_job/) for full documentation.
#'
#' @param jobIdentifier &#91;required&#93; The identifier of the import job.
#'
#' @keywords internal
#'
#' @rdname bedrock_get_model_import_job
bedrock_get_model_import_job <- function(jobIdentifier) {
  op <- new_operation(
    name = "GetModelImportJob",
    http_method = "GET",
    http_path = "/model-import-jobs/{jobIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$get_model_import_job_input(jobIdentifier = jobIdentifier)
  output <- .bedrock$get_model_import_job_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$get_model_import_job <- bedrock_get_model_import_job

#' Gets details about a batch inference job
#'
#' @description
#' Gets details about a batch inference job. For more information, see [Monitor batch inference jobs](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-monitor.html)
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_get_model_invocation_job/](https://www.paws-r-sdk.com/docs/bedrock_get_model_invocation_job/) for full documentation.
#'
#' @param jobIdentifier &#91;required&#93; The Amazon Resource Name (ARN) of the batch inference job.
#'
#' @keywords internal
#'
#' @rdname bedrock_get_model_invocation_job
bedrock_get_model_invocation_job <- function(jobIdentifier) {
  op <- new_operation(
    name = "GetModelInvocationJob",
    http_method = "GET",
    http_path = "/model-invocation-job/{jobIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$get_model_invocation_job_input(jobIdentifier = jobIdentifier)
  output <- .bedrock$get_model_invocation_job_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$get_model_invocation_job <- bedrock_get_model_invocation_job

#' Get the current configuration values for model invocation logging
#'
#' @description
#' Get the current configuration values for model invocation logging.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_get_model_invocation_logging_configuration/](https://www.paws-r-sdk.com/docs/bedrock_get_model_invocation_logging_configuration/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname bedrock_get_model_invocation_logging_configuration
bedrock_get_model_invocation_logging_configuration <- function() {
  op <- new_operation(
    name = "GetModelInvocationLoggingConfiguration",
    http_method = "GET",
    http_path = "/logging/modelinvocations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$get_model_invocation_logging_configuration_input()
  output <- .bedrock$get_model_invocation_logging_configuration_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$get_model_invocation_logging_configuration <- bedrock_get_model_invocation_logging_configuration

#' Retrieves details about a prompt router
#'
#' @description
#' Retrieves details about a prompt router.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_get_prompt_router/](https://www.paws-r-sdk.com/docs/bedrock_get_prompt_router/) for full documentation.
#'
#' @param promptRouterArn &#91;required&#93; The prompt router's ARN
#'
#' @keywords internal
#'
#' @rdname bedrock_get_prompt_router
bedrock_get_prompt_router <- function(promptRouterArn) {
  op <- new_operation(
    name = "GetPromptRouter",
    http_method = "GET",
    http_path = "/prompt-routers/{promptRouterArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$get_prompt_router_input(promptRouterArn = promptRouterArn)
  output <- .bedrock$get_prompt_router_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$get_prompt_router <- bedrock_get_prompt_router

#' Returns details for a Provisioned Throughput
#'
#' @description
#' Returns details for a Provisioned Throughput. For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_get_provisioned_model_throughput/](https://www.paws-r-sdk.com/docs/bedrock_get_provisioned_model_throughput/) for full documentation.
#'
#' @param provisionedModelId &#91;required&#93; The Amazon Resource Name (ARN) or name of the Provisioned Throughput.
#'
#' @keywords internal
#'
#' @rdname bedrock_get_provisioned_model_throughput
bedrock_get_provisioned_model_throughput <- function(provisionedModelId) {
  op <- new_operation(
    name = "GetProvisionedModelThroughput",
    http_method = "GET",
    http_path = "/provisioned-model-throughput/{provisionedModelId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$get_provisioned_model_throughput_input(provisionedModelId = provisionedModelId)
  output <- .bedrock$get_provisioned_model_throughput_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$get_provisioned_model_throughput <- bedrock_get_provisioned_model_throughput

#' Returns a list of the custom models that you have created with the
#' CreateModelCustomizationJob operation
#'
#' @description
#' Returns a list of the custom models that you have created with the [`create_model_customization_job`][bedrock_create_model_customization_job] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_list_custom_models/](https://www.paws-r-sdk.com/docs/bedrock_list_custom_models/) for full documentation.
#'
#' @param creationTimeBefore Return custom models created before the specified time.
#' @param creationTimeAfter Return custom models created after the specified time.
#' @param nameContains Return custom models only if the job name contains these characters.
#' @param baseModelArnEquals Return custom models only if the base model Amazon Resource Name (ARN)
#' matches this parameter.
#' @param foundationModelArnEquals Return custom models only if the foundation model Amazon Resource Name
#' (ARN) matches this parameter.
#' @param maxResults The maximum number of results to return in the response. If the total
#' number of results is greater than this value, use the token returned in
#' the response in the `nextToken` field when making another request to
#' return the next batch of results.
#' @param nextToken If the total number of results is greater than the `maxResults` value
#' provided in the request, enter the token returned in the `nextToken`
#' field in the response in this field to return the next batch of results.
#' @param sortBy The field to sort by in the returned list of models.
#' @param sortOrder The sort order of the results.
#' @param isOwned Return custom models depending on if the current account owns them
#' (`true`) or if they were shared with the current account (`false`).
#'
#' @keywords internal
#'
#' @rdname bedrock_list_custom_models
bedrock_list_custom_models <- function(creationTimeBefore = NULL, creationTimeAfter = NULL, nameContains = NULL, baseModelArnEquals = NULL, foundationModelArnEquals = NULL, maxResults = NULL, nextToken = NULL, sortBy = NULL, sortOrder = NULL, isOwned = NULL) {
  op <- new_operation(
    name = "ListCustomModels",
    http_method = "GET",
    http_path = "/custom-models",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "modelSummaries"),
    stream_api = FALSE
  )
  input <- .bedrock$list_custom_models_input(creationTimeBefore = creationTimeBefore, creationTimeAfter = creationTimeAfter, nameContains = nameContains, baseModelArnEquals = baseModelArnEquals, foundationModelArnEquals = foundationModelArnEquals, maxResults = maxResults, nextToken = nextToken, sortBy = sortBy, sortOrder = sortOrder, isOwned = isOwned)
  output <- .bedrock$list_custom_models_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$list_custom_models <- bedrock_list_custom_models

#' Lists all existing evaluation jobs
#'
#' @description
#' Lists all existing evaluation jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_list_evaluation_jobs/](https://www.paws-r-sdk.com/docs/bedrock_list_evaluation_jobs/) for full documentation.
#'
#' @param creationTimeAfter A filter to only list evaluation jobs created after a specified time.
#' @param creationTimeBefore A filter to only list evaluation jobs created before a specified time.
#' @param statusEquals A filter to only list evaluation jobs that are of a certain status.
#' @param applicationTypeEquals A filter to only list evaluation jobs that are either model evaluations
#' or knowledge base evaluations.
#' @param nameContains A filter to only list evaluation jobs that contain a specified string in
#' the job name.
#' @param maxResults The maximum number of results to return.
#' @param nextToken Continuation token from the previous response, for Amazon Bedrock to
#' list the next set of results.
#' @param sortBy Specifies a creation time to sort the list of evaluation jobs by when
#' they were created.
#' @param sortOrder Specifies whether to sort the list of evaluation jobs by either
#' ascending or descending order.
#'
#' @keywords internal
#'
#' @rdname bedrock_list_evaluation_jobs
bedrock_list_evaluation_jobs <- function(creationTimeAfter = NULL, creationTimeBefore = NULL, statusEquals = NULL, applicationTypeEquals = NULL, nameContains = NULL, maxResults = NULL, nextToken = NULL, sortBy = NULL, sortOrder = NULL) {
  op <- new_operation(
    name = "ListEvaluationJobs",
    http_method = "GET",
    http_path = "/evaluation-jobs",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "jobSummaries"),
    stream_api = FALSE
  )
  input <- .bedrock$list_evaluation_jobs_input(creationTimeAfter = creationTimeAfter, creationTimeBefore = creationTimeBefore, statusEquals = statusEquals, applicationTypeEquals = applicationTypeEquals, nameContains = nameContains, maxResults = maxResults, nextToken = nextToken, sortBy = sortBy, sortOrder = sortOrder)
  output <- .bedrock$list_evaluation_jobs_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$list_evaluation_jobs <- bedrock_list_evaluation_jobs

#' Lists Amazon Bedrock foundation models that you can use
#'
#' @description
#' Lists Amazon Bedrock foundation models that you can use. You can filter the results with the request parameters. For more information, see [Foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_list_foundation_models/](https://www.paws-r-sdk.com/docs/bedrock_list_foundation_models/) for full documentation.
#'
#' @param byProvider Return models belonging to the model provider that you specify.
#' @param byCustomizationType Return models that support the customization type that you specify. For
#' more information, see [Custom
#' models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html)
#' in the [Amazon Bedrock User
#' Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#' @param byOutputModality Return models that support the output modality that you specify.
#' @param byInferenceType Return models that support the inference type that you specify. For more
#' information, see [Provisioned
#' Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html)
#' in the [Amazon Bedrock User
#' Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' @keywords internal
#'
#' @rdname bedrock_list_foundation_models
bedrock_list_foundation_models <- function(byProvider = NULL, byCustomizationType = NULL, byOutputModality = NULL, byInferenceType = NULL) {
  op <- new_operation(
    name = "ListFoundationModels",
    http_method = "GET",
    http_path = "/foundation-models",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$list_foundation_models_input(byProvider = byProvider, byCustomizationType = byCustomizationType, byOutputModality = byOutputModality, byInferenceType = byInferenceType)
  output <- .bedrock$list_foundation_models_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$list_foundation_models <- bedrock_list_foundation_models

#' Lists details about all the guardrails in an account
#'
#' @description
#' Lists details about all the guardrails in an account. To list the `DRAFT` version of all your guardrails, don't specify the `guardrailIdentifier` field. To list all versions of a guardrail, specify the ARN of the guardrail in the `guardrailIdentifier` field.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_list_guardrails/](https://www.paws-r-sdk.com/docs/bedrock_list_guardrails/) for full documentation.
#'
#' @param guardrailIdentifier The unique identifier of the guardrail. This can be an ID or the ARN.
#' @param maxResults The maximum number of results to return in the response.
#' @param nextToken If there are more results than were returned in the response, the
#' response returns a `nextToken` that you can send in another
#' [`list_guardrails`][bedrock_list_guardrails] request to see the next
#' batch of results.
#'
#' @keywords internal
#'
#' @rdname bedrock_list_guardrails
bedrock_list_guardrails <- function(guardrailIdentifier = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListGuardrails",
    http_method = "GET",
    http_path = "/guardrails",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "guardrails"),
    stream_api = FALSE
  )
  input <- .bedrock$list_guardrails_input(guardrailIdentifier = guardrailIdentifier, maxResults = maxResults, nextToken = nextToken)
  output <- .bedrock$list_guardrails_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$list_guardrails <- bedrock_list_guardrails

#' Returns a list of models you've imported
#'
#' @description
#' Returns a list of models you've imported. You can filter the results to return based on one or more criteria. For more information, see [Import a customized model](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_list_imported_models/](https://www.paws-r-sdk.com/docs/bedrock_list_imported_models/) for full documentation.
#'
#' @param creationTimeBefore Return imported models that created before the specified time.
#' @param creationTimeAfter Return imported models that were created after the specified time.
#' @param nameContains Return imported models only if the model name contains these characters.
#' @param maxResults The maximum number of results to return in the response. If the total
#' number of results is greater than this value, use the token returned in
#' the response in the `nextToken` field when making another request to
#' return the next batch of results.
#' @param nextToken If the total number of results is greater than the `maxResults` value
#' provided in the request, enter the token returned in the `nextToken`
#' field in the response in this field to return the next batch of results.
#' @param sortBy The field to sort by in the returned list of imported models.
#' @param sortOrder Specifies whetehr to sort the results in ascending or descending order.
#'
#' @keywords internal
#'
#' @rdname bedrock_list_imported_models
bedrock_list_imported_models <- function(creationTimeBefore = NULL, creationTimeAfter = NULL, nameContains = NULL, maxResults = NULL, nextToken = NULL, sortBy = NULL, sortOrder = NULL) {
  op <- new_operation(
    name = "ListImportedModels",
    http_method = "GET",
    http_path = "/imported-models",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "modelSummaries"),
    stream_api = FALSE
  )
  input <- .bedrock$list_imported_models_input(creationTimeBefore = creationTimeBefore, creationTimeAfter = creationTimeAfter, nameContains = nameContains, maxResults = maxResults, nextToken = nextToken, sortBy = sortBy, sortOrder = sortOrder)
  output <- .bedrock$list_imported_models_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$list_imported_models <- bedrock_list_imported_models

#' Returns a list of inference profiles that you can use
#'
#' @description
#' Returns a list of inference profiles that you can use. For more information, see [Increase throughput and resilience with cross-region inference in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html). in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_list_inference_profiles/](https://www.paws-r-sdk.com/docs/bedrock_list_inference_profiles/) for full documentation.
#'
#' @param maxResults The maximum number of results to return in the response. If the total
#' number of results is greater than this value, use the token returned in
#' the response in the `nextToken` field when making another request to
#' return the next batch of results.
#' @param nextToken If the total number of results is greater than the `maxResults` value
#' provided in the request, enter the token returned in the `nextToken`
#' field in the response in this field to return the next batch of results.
#' @param typeEquals Filters for inference profiles that match the type you specify.
#' 
#' -   `SYSTEM_DEFINED` – The inference profile is defined by Amazon
#'     Bedrock. You can route inference requests across regions with these
#'     inference profiles.
#' 
#' -   `APPLICATION` – The inference profile was created by a user. This
#'     type of inference profile can track metrics and costs when invoking
#'     the model in it. The inference profile may route requests to one or
#'     multiple regions.
#'
#' @keywords internal
#'
#' @rdname bedrock_list_inference_profiles
bedrock_list_inference_profiles <- function(maxResults = NULL, nextToken = NULL, typeEquals = NULL) {
  op <- new_operation(
    name = "ListInferenceProfiles",
    http_method = "GET",
    http_path = "/inference-profiles",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "inferenceProfileSummaries"),
    stream_api = FALSE
  )
  input <- .bedrock$list_inference_profiles_input(maxResults = maxResults, nextToken = nextToken, typeEquals = typeEquals)
  output <- .bedrock$list_inference_profiles_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$list_inference_profiles <- bedrock_list_inference_profiles

#' Lists the endpoints for models from Amazon Bedrock Marketplace in your
#' Amazon Web Services account
#'
#' @description
#' Lists the endpoints for models from Amazon Bedrock Marketplace in your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_list_marketplace_model_endpoints/](https://www.paws-r-sdk.com/docs/bedrock_list_marketplace_model_endpoints/) for full documentation.
#'
#' @param maxResults The maximum number of results to return in a single call. If more
#' results are available, the operation returns a `NextToken` value.
#' @param nextToken The token for the next set of results. You receive this token from a
#' previous
#' [`list_marketplace_model_endpoints`][bedrock_list_marketplace_model_endpoints]
#' call.
#' @param modelSourceEquals If specified, only endpoints for the given model source identifier are
#' returned.
#'
#' @keywords internal
#'
#' @rdname bedrock_list_marketplace_model_endpoints
bedrock_list_marketplace_model_endpoints <- function(maxResults = NULL, nextToken = NULL, modelSourceEquals = NULL) {
  op <- new_operation(
    name = "ListMarketplaceModelEndpoints",
    http_method = "GET",
    http_path = "/marketplace-model/endpoints",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "marketplaceModelEndpoints"),
    stream_api = FALSE
  )
  input <- .bedrock$list_marketplace_model_endpoints_input(maxResults = maxResults, nextToken = nextToken, modelSourceEquals = modelSourceEquals)
  output <- .bedrock$list_marketplace_model_endpoints_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$list_marketplace_model_endpoints <- bedrock_list_marketplace_model_endpoints

#' Returns a list of model copy jobs that you have submitted
#'
#' @description
#' Returns a list of model copy jobs that you have submitted. You can filter the jobs to return based on one or more criteria. For more information, see [Copy models to be used in other regions](https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_list_model_copy_jobs/](https://www.paws-r-sdk.com/docs/bedrock_list_model_copy_jobs/) for full documentation.
#'
#' @param creationTimeAfter Filters for model copy jobs created after the specified time.
#' @param creationTimeBefore Filters for model copy jobs created before the specified time.
#' @param statusEquals Filters for model copy jobs whose status matches the value that you
#' specify.
#' @param sourceAccountEquals Filters for model copy jobs in which the account that the source model
#' belongs to is equal to the value that you specify.
#' @param sourceModelArnEquals Filters for model copy jobs in which the Amazon Resource Name (ARN) of
#' the source model to is equal to the value that you specify.
#' @param targetModelNameContains Filters for model copy jobs in which the name of the copied model
#' contains the string that you specify.
#' @param maxResults The maximum number of results to return in the response. If the total
#' number of results is greater than this value, use the token returned in
#' the response in the `nextToken` field when making another request to
#' return the next batch of results.
#' @param nextToken If the total number of results is greater than the `maxResults` value
#' provided in the request, enter the token returned in the `nextToken`
#' field in the response in this field to return the next batch of results.
#' @param sortBy The field to sort by in the returned list of model copy jobs.
#' @param sortOrder Specifies whether to sort the results in ascending or descending order.
#'
#' @keywords internal
#'
#' @rdname bedrock_list_model_copy_jobs
bedrock_list_model_copy_jobs <- function(creationTimeAfter = NULL, creationTimeBefore = NULL, statusEquals = NULL, sourceAccountEquals = NULL, sourceModelArnEquals = NULL, targetModelNameContains = NULL, maxResults = NULL, nextToken = NULL, sortBy = NULL, sortOrder = NULL) {
  op <- new_operation(
    name = "ListModelCopyJobs",
    http_method = "GET",
    http_path = "/model-copy-jobs",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "modelCopyJobSummaries"),
    stream_api = FALSE
  )
  input <- .bedrock$list_model_copy_jobs_input(creationTimeAfter = creationTimeAfter, creationTimeBefore = creationTimeBefore, statusEquals = statusEquals, sourceAccountEquals = sourceAccountEquals, sourceModelArnEquals = sourceModelArnEquals, targetModelNameContains = targetModelNameContains, maxResults = maxResults, nextToken = nextToken, sortBy = sortBy, sortOrder = sortOrder)
  output <- .bedrock$list_model_copy_jobs_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$list_model_copy_jobs <- bedrock_list_model_copy_jobs

#' Returns a list of model customization jobs that you have submitted
#'
#' @description
#' Returns a list of model customization jobs that you have submitted. You can filter the jobs to return based on one or more criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_list_model_customization_jobs/](https://www.paws-r-sdk.com/docs/bedrock_list_model_customization_jobs/) for full documentation.
#'
#' @param creationTimeAfter Return customization jobs created after the specified time.
#' @param creationTimeBefore Return customization jobs created before the specified time.
#' @param statusEquals Return customization jobs with the specified status.
#' @param nameContains Return customization jobs only if the job name contains these
#' characters.
#' @param maxResults The maximum number of results to return in the response. If the total
#' number of results is greater than this value, use the token returned in
#' the response in the `nextToken` field when making another request to
#' return the next batch of results.
#' @param nextToken If the total number of results is greater than the `maxResults` value
#' provided in the request, enter the token returned in the `nextToken`
#' field in the response in this field to return the next batch of results.
#' @param sortBy The field to sort by in the returned list of jobs.
#' @param sortOrder The sort order of the results.
#'
#' @keywords internal
#'
#' @rdname bedrock_list_model_customization_jobs
bedrock_list_model_customization_jobs <- function(creationTimeAfter = NULL, creationTimeBefore = NULL, statusEquals = NULL, nameContains = NULL, maxResults = NULL, nextToken = NULL, sortBy = NULL, sortOrder = NULL) {
  op <- new_operation(
    name = "ListModelCustomizationJobs",
    http_method = "GET",
    http_path = "/model-customization-jobs",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "modelCustomizationJobSummaries"),
    stream_api = FALSE
  )
  input <- .bedrock$list_model_customization_jobs_input(creationTimeAfter = creationTimeAfter, creationTimeBefore = creationTimeBefore, statusEquals = statusEquals, nameContains = nameContains, maxResults = maxResults, nextToken = nextToken, sortBy = sortBy, sortOrder = sortOrder)
  output <- .bedrock$list_model_customization_jobs_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$list_model_customization_jobs <- bedrock_list_model_customization_jobs

#' Returns a list of import jobs you've submitted
#'
#' @description
#' Returns a list of import jobs you've submitted. You can filter the results to return based on one or more criteria. For more information, see [Import a customized model](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_list_model_import_jobs/](https://www.paws-r-sdk.com/docs/bedrock_list_model_import_jobs/) for full documentation.
#'
#' @param creationTimeAfter Return import jobs that were created after the specified time.
#' @param creationTimeBefore Return import jobs that were created before the specified time.
#' @param statusEquals Return imported jobs with the specified status.
#' @param nameContains Return imported jobs only if the job name contains these characters.
#' @param maxResults The maximum number of results to return in the response. If the total
#' number of results is greater than this value, use the token returned in
#' the response in the `nextToken` field when making another request to
#' return the next batch of results.
#' @param nextToken If the total number of results is greater than the `maxResults` value
#' provided in the request, enter the token returned in the `nextToken`
#' field in the response in this field to return the next batch of results.
#' @param sortBy The field to sort by in the returned list of imported jobs.
#' @param sortOrder Specifies whether to sort the results in ascending or descending order.
#'
#' @keywords internal
#'
#' @rdname bedrock_list_model_import_jobs
bedrock_list_model_import_jobs <- function(creationTimeAfter = NULL, creationTimeBefore = NULL, statusEquals = NULL, nameContains = NULL, maxResults = NULL, nextToken = NULL, sortBy = NULL, sortOrder = NULL) {
  op <- new_operation(
    name = "ListModelImportJobs",
    http_method = "GET",
    http_path = "/model-import-jobs",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "modelImportJobSummaries"),
    stream_api = FALSE
  )
  input <- .bedrock$list_model_import_jobs_input(creationTimeAfter = creationTimeAfter, creationTimeBefore = creationTimeBefore, statusEquals = statusEquals, nameContains = nameContains, maxResults = maxResults, nextToken = nextToken, sortBy = sortBy, sortOrder = sortOrder)
  output <- .bedrock$list_model_import_jobs_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$list_model_import_jobs <- bedrock_list_model_import_jobs

#' Lists all batch inference jobs in the account
#'
#' @description
#' Lists all batch inference jobs in the account. For more information, see [View details about a batch inference job](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-monitor.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_list_model_invocation_jobs/](https://www.paws-r-sdk.com/docs/bedrock_list_model_invocation_jobs/) for full documentation.
#'
#' @param submitTimeAfter Specify a time to filter for batch inference jobs that were submitted
#' after the time you specify.
#' @param submitTimeBefore Specify a time to filter for batch inference jobs that were submitted
#' before the time you specify.
#' @param statusEquals Specify a status to filter for batch inference jobs whose statuses match
#' the string you specify.
#' 
#' The following statuses are possible:
#' 
#' -   Submitted – This job has been submitted to a queue for validation.
#' 
#' -   Validating – This job is being validated for the requirements
#'     described in [Format and upload your batch inference
#'     data](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data.html).
#'     The criteria include the following:
#' 
#'     -   Your IAM service role has access to the Amazon S3 buckets
#'         containing your files.
#' 
#'     -   Your files are .jsonl files and each individual record is a JSON
#'         object in the correct format. Note that validation doesn't check
#'         if the `modelInput` value matches the request body for the
#'         model.
#' 
#'     -   Your files fulfill the requirements for file size and number of
#'         records. For more information, see [Quotas for Amazon
#'         Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html).
#' 
#' -   Scheduled – This job has been validated and is now in a queue. The
#'     job will automatically start when it reaches its turn.
#' 
#' -   Expired – This job timed out because it was scheduled but didn't
#'     begin before the set timeout duration. Submit a new job request.
#' 
#' -   InProgress – This job has begun. You can start viewing the results
#'     in the output S3 location.
#' 
#' -   Completed – This job has successfully completed. View the output
#'     files in the output S3 location.
#' 
#' -   PartiallyCompleted – This job has partially completed. Not all of
#'     your records could be processed in time. View the output files in
#'     the output S3 location.
#' 
#' -   Failed – This job has failed. Check the failure message for any
#'     further details. For further assistance, reach out to the Amazon Web
#'     Services Support Center.
#' 
#' -   Stopped – This job was stopped by a user.
#' 
#' -   Stopping – This job is being stopped by a user.
#' @param nameContains Specify a string to filter for batch inference jobs whose names contain
#' the string.
#' @param maxResults The maximum number of results to return. If there are more results than
#' the number that you specify, a `nextToken` value is returned. Use the
#' `nextToken` in a request to return the next batch of results.
#' @param nextToken If there were more results than the value you specified in the
#' `maxResults` field in a previous
#' [`list_model_invocation_jobs`][bedrock_list_model_invocation_jobs]
#' request, the response would have returned a `nextToken` value. To see
#' the next batch of results, send the `nextToken` value in another
#' request.
#' @param sortBy An attribute by which to sort the results.
#' @param sortOrder Specifies whether to sort the results by ascending or descending order.
#'
#' @keywords internal
#'
#' @rdname bedrock_list_model_invocation_jobs
bedrock_list_model_invocation_jobs <- function(submitTimeAfter = NULL, submitTimeBefore = NULL, statusEquals = NULL, nameContains = NULL, maxResults = NULL, nextToken = NULL, sortBy = NULL, sortOrder = NULL) {
  op <- new_operation(
    name = "ListModelInvocationJobs",
    http_method = "GET",
    http_path = "/model-invocation-jobs",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "invocationJobSummaries"),
    stream_api = FALSE
  )
  input <- .bedrock$list_model_invocation_jobs_input(submitTimeAfter = submitTimeAfter, submitTimeBefore = submitTimeBefore, statusEquals = statusEquals, nameContains = nameContains, maxResults = maxResults, nextToken = nextToken, sortBy = sortBy, sortOrder = sortOrder)
  output <- .bedrock$list_model_invocation_jobs_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$list_model_invocation_jobs <- bedrock_list_model_invocation_jobs

#' Retrieves a list of prompt routers
#'
#' @description
#' Retrieves a list of prompt routers.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_list_prompt_routers/](https://www.paws-r-sdk.com/docs/bedrock_list_prompt_routers/) for full documentation.
#'
#' @param maxResults The maximum number of prompt routers to return in one page of results.
#' @param nextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#'
#' @keywords internal
#'
#' @rdname bedrock_list_prompt_routers
bedrock_list_prompt_routers <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListPromptRouters",
    http_method = "GET",
    http_path = "/prompt-routers",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "promptRouterSummaries"),
    stream_api = FALSE
  )
  input <- .bedrock$list_prompt_routers_input(maxResults = maxResults, nextToken = nextToken)
  output <- .bedrock$list_prompt_routers_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$list_prompt_routers <- bedrock_list_prompt_routers

#' Lists the Provisioned Throughputs in the account
#'
#' @description
#' Lists the Provisioned Throughputs in the account. For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_list_provisioned_model_throughputs/](https://www.paws-r-sdk.com/docs/bedrock_list_provisioned_model_throughputs/) for full documentation.
#'
#' @param creationTimeAfter A filter that returns Provisioned Throughputs created after the
#' specified time.
#' @param creationTimeBefore A filter that returns Provisioned Throughputs created before the
#' specified time.
#' @param statusEquals A filter that returns Provisioned Throughputs if their statuses matches
#' the value that you specify.
#' @param modelArnEquals A filter that returns Provisioned Throughputs whose model Amazon
#' Resource Name (ARN) is equal to the value that you specify.
#' @param nameContains A filter that returns Provisioned Throughputs if their name contains the
#' expression that you specify.
#' @param maxResults THe maximum number of results to return in the response. If there are
#' more results than the number you specified, the response returns a
#' `nextToken` value. To see the next batch of results, send the
#' `nextToken` value in another list request.
#' @param nextToken If there are more results than the number you specified in the
#' `maxResults` field, the response returns a `nextToken` value. To see the
#' next batch of results, specify the `nextToken` value in this field.
#' @param sortBy The field by which to sort the returned list of Provisioned Throughputs.
#' @param sortOrder The sort order of the results.
#'
#' @keywords internal
#'
#' @rdname bedrock_list_provisioned_model_throughputs
bedrock_list_provisioned_model_throughputs <- function(creationTimeAfter = NULL, creationTimeBefore = NULL, statusEquals = NULL, modelArnEquals = NULL, nameContains = NULL, maxResults = NULL, nextToken = NULL, sortBy = NULL, sortOrder = NULL) {
  op <- new_operation(
    name = "ListProvisionedModelThroughputs",
    http_method = "GET",
    http_path = "/provisioned-model-throughputs",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "provisionedModelSummaries"),
    stream_api = FALSE
  )
  input <- .bedrock$list_provisioned_model_throughputs_input(creationTimeAfter = creationTimeAfter, creationTimeBefore = creationTimeBefore, statusEquals = statusEquals, modelArnEquals = modelArnEquals, nameContains = nameContains, maxResults = maxResults, nextToken = nextToken, sortBy = sortBy, sortOrder = sortOrder)
  output <- .bedrock$list_provisioned_model_throughputs_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$list_provisioned_model_throughputs <- bedrock_list_provisioned_model_throughputs

#' List the tags associated with the specified resource
#'
#' @description
#' List the tags associated with the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/bedrock_list_tags_for_resource/) for full documentation.
#'
#' @param resourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @keywords internal
#'
#' @rdname bedrock_list_tags_for_resource
bedrock_list_tags_for_resource <- function(resourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/listTagsForResource",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$list_tags_for_resource_input(resourceARN = resourceARN)
  output <- .bedrock$list_tags_for_resource_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$list_tags_for_resource <- bedrock_list_tags_for_resource

#' Set the configuration values for model invocation logging
#'
#' @description
#' Set the configuration values for model invocation logging.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_put_model_invocation_logging_configuration/](https://www.paws-r-sdk.com/docs/bedrock_put_model_invocation_logging_configuration/) for full documentation.
#'
#' @param loggingConfig &#91;required&#93; The logging configuration values to set.
#'
#' @keywords internal
#'
#' @rdname bedrock_put_model_invocation_logging_configuration
bedrock_put_model_invocation_logging_configuration <- function(loggingConfig) {
  op <- new_operation(
    name = "PutModelInvocationLoggingConfiguration",
    http_method = "PUT",
    http_path = "/logging/modelinvocations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$put_model_invocation_logging_configuration_input(loggingConfig = loggingConfig)
  output <- .bedrock$put_model_invocation_logging_configuration_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$put_model_invocation_logging_configuration <- bedrock_put_model_invocation_logging_configuration

#' Registers an existing Amazon SageMaker endpoint with Amazon Bedrock
#' Marketplace, allowing it to be used with Amazon Bedrock APIs
#'
#' @description
#' Registers an existing Amazon SageMaker endpoint with Amazon Bedrock Marketplace, allowing it to be used with Amazon Bedrock APIs.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_register_marketplace_model_endpoint/](https://www.paws-r-sdk.com/docs/bedrock_register_marketplace_model_endpoint/) for full documentation.
#'
#' @param endpointIdentifier &#91;required&#93; The ARN of the Amazon SageMaker endpoint you want to register with
#' Amazon Bedrock Marketplace.
#' @param modelSourceIdentifier &#91;required&#93; The ARN of the model from Amazon Bedrock Marketplace that is deployed on
#' the endpoint.
#'
#' @keywords internal
#'
#' @rdname bedrock_register_marketplace_model_endpoint
bedrock_register_marketplace_model_endpoint <- function(endpointIdentifier, modelSourceIdentifier) {
  op <- new_operation(
    name = "RegisterMarketplaceModelEndpoint",
    http_method = "POST",
    http_path = "/marketplace-model/endpoints/{endpointIdentifier}/registration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$register_marketplace_model_endpoint_input(endpointIdentifier = endpointIdentifier, modelSourceIdentifier = modelSourceIdentifier)
  output <- .bedrock$register_marketplace_model_endpoint_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$register_marketplace_model_endpoint <- bedrock_register_marketplace_model_endpoint

#' Stops an evaluation job that is current being created or running
#'
#' @description
#' Stops an evaluation job that is current being created or running.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_stop_evaluation_job/](https://www.paws-r-sdk.com/docs/bedrock_stop_evaluation_job/) for full documentation.
#'
#' @param jobIdentifier &#91;required&#93; The Amazon Resource Name (ARN) of the evaluation job you want to stop.
#'
#' @keywords internal
#'
#' @rdname bedrock_stop_evaluation_job
bedrock_stop_evaluation_job <- function(jobIdentifier) {
  op <- new_operation(
    name = "StopEvaluationJob",
    http_method = "POST",
    http_path = "/evaluation-job/{jobIdentifier}/stop",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$stop_evaluation_job_input(jobIdentifier = jobIdentifier)
  output <- .bedrock$stop_evaluation_job_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$stop_evaluation_job <- bedrock_stop_evaluation_job

#' Stops an active model customization job
#'
#' @description
#' Stops an active model customization job. For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_stop_model_customization_job/](https://www.paws-r-sdk.com/docs/bedrock_stop_model_customization_job/) for full documentation.
#'
#' @param jobIdentifier &#91;required&#93; Job identifier of the job to stop.
#'
#' @keywords internal
#'
#' @rdname bedrock_stop_model_customization_job
bedrock_stop_model_customization_job <- function(jobIdentifier) {
  op <- new_operation(
    name = "StopModelCustomizationJob",
    http_method = "POST",
    http_path = "/model-customization-jobs/{jobIdentifier}/stop",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$stop_model_customization_job_input(jobIdentifier = jobIdentifier)
  output <- .bedrock$stop_model_customization_job_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$stop_model_customization_job <- bedrock_stop_model_customization_job

#' Stops a batch inference job
#'
#' @description
#' Stops a batch inference job. You're only charged for tokens that were already processed. For more information, see [Stop a batch inference job](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-stop.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_stop_model_invocation_job/](https://www.paws-r-sdk.com/docs/bedrock_stop_model_invocation_job/) for full documentation.
#'
#' @param jobIdentifier &#91;required&#93; The Amazon Resource Name (ARN) of the batch inference job to stop.
#'
#' @keywords internal
#'
#' @rdname bedrock_stop_model_invocation_job
bedrock_stop_model_invocation_job <- function(jobIdentifier) {
  op <- new_operation(
    name = "StopModelInvocationJob",
    http_method = "POST",
    http_path = "/model-invocation-job/{jobIdentifier}/stop",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$stop_model_invocation_job_input(jobIdentifier = jobIdentifier)
  output <- .bedrock$stop_model_invocation_job_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$stop_model_invocation_job <- bedrock_stop_model_invocation_job

#' Associate tags with a resource
#'
#' @description
#' Associate tags with a resource. For more information, see [Tagging resources](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_tag_resource/](https://www.paws-r-sdk.com/docs/bedrock_tag_resource/) for full documentation.
#'
#' @param resourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource to tag.
#' @param tags &#91;required&#93; Tags to associate with the resource.
#'
#' @keywords internal
#'
#' @rdname bedrock_tag_resource
bedrock_tag_resource <- function(resourceARN, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tagResource",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$tag_resource_input(resourceARN = resourceARN, tags = tags)
  output <- .bedrock$tag_resource_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$tag_resource <- bedrock_tag_resource

#' Remove one or more tags from a resource
#'
#' @description
#' Remove one or more tags from a resource. For more information, see [Tagging resources](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_untag_resource/](https://www.paws-r-sdk.com/docs/bedrock_untag_resource/) for full documentation.
#'
#' @param resourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource to untag.
#' @param tagKeys &#91;required&#93; Tag keys of the tags to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname bedrock_untag_resource
bedrock_untag_resource <- function(resourceARN, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/untagResource",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$untag_resource_input(resourceARN = resourceARN, tagKeys = tagKeys)
  output <- .bedrock$untag_resource_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$untag_resource <- bedrock_untag_resource

#' Updates a guardrail with the values you specify
#'
#' @description
#' Updates a guardrail with the values you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_update_guardrail/](https://www.paws-r-sdk.com/docs/bedrock_update_guardrail/) for full documentation.
#'
#' @param guardrailIdentifier &#91;required&#93; The unique identifier of the guardrail. This can be an ID or the ARN.
#' @param name &#91;required&#93; A name for the guardrail.
#' @param description A description of the guardrail.
#' @param topicPolicyConfig The topic policy to configure for the guardrail.
#' @param contentPolicyConfig The content policy to configure for the guardrail.
#' @param wordPolicyConfig The word policy to configure for the guardrail.
#' @param sensitiveInformationPolicyConfig The sensitive information policy to configure for the guardrail.
#' @param contextualGroundingPolicyConfig The contextual grounding policy configuration used to update a
#' guardrail.
#' @param blockedInputMessaging &#91;required&#93; The message to return when the guardrail blocks a prompt.
#' @param blockedOutputsMessaging &#91;required&#93; The message to return when the guardrail blocks a model response.
#' @param kmsKeyId The ARN of the KMS key with which to encrypt the guardrail.
#'
#' @keywords internal
#'
#' @rdname bedrock_update_guardrail
bedrock_update_guardrail <- function(guardrailIdentifier, name, description = NULL, topicPolicyConfig = NULL, contentPolicyConfig = NULL, wordPolicyConfig = NULL, sensitiveInformationPolicyConfig = NULL, contextualGroundingPolicyConfig = NULL, blockedInputMessaging, blockedOutputsMessaging, kmsKeyId = NULL) {
  op <- new_operation(
    name = "UpdateGuardrail",
    http_method = "PUT",
    http_path = "/guardrails/{guardrailIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$update_guardrail_input(guardrailIdentifier = guardrailIdentifier, name = name, description = description, topicPolicyConfig = topicPolicyConfig, contentPolicyConfig = contentPolicyConfig, wordPolicyConfig = wordPolicyConfig, sensitiveInformationPolicyConfig = sensitiveInformationPolicyConfig, contextualGroundingPolicyConfig = contextualGroundingPolicyConfig, blockedInputMessaging = blockedInputMessaging, blockedOutputsMessaging = blockedOutputsMessaging, kmsKeyId = kmsKeyId)
  output <- .bedrock$update_guardrail_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$update_guardrail <- bedrock_update_guardrail

#' Updates the configuration of an existing endpoint for a model from
#' Amazon Bedrock Marketplace
#'
#' @description
#' Updates the configuration of an existing endpoint for a model from Amazon Bedrock Marketplace.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_update_marketplace_model_endpoint/](https://www.paws-r-sdk.com/docs/bedrock_update_marketplace_model_endpoint/) for full documentation.
#'
#' @param endpointArn &#91;required&#93; The Amazon Resource Name (ARN) of the endpoint you want to update.
#' @param endpointConfig &#91;required&#93; The new configuration for the endpoint, including the number and type of
#' instances to use.
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. This token is listed as not required because
#' Amazon Web Services SDKs automatically generate it for you and set this
#' parameter. If you're not using the Amazon Web Services SDK or the CLI,
#' you must provide this token or the action will fail.
#'
#' @keywords internal
#'
#' @rdname bedrock_update_marketplace_model_endpoint
bedrock_update_marketplace_model_endpoint <- function(endpointArn, endpointConfig, clientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdateMarketplaceModelEndpoint",
    http_method = "PATCH",
    http_path = "/marketplace-model/endpoints/{endpointArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$update_marketplace_model_endpoint_input(endpointArn = endpointArn, endpointConfig = endpointConfig, clientRequestToken = clientRequestToken)
  output <- .bedrock$update_marketplace_model_endpoint_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$update_marketplace_model_endpoint <- bedrock_update_marketplace_model_endpoint

#' Updates the name or associated model for a Provisioned Throughput
#'
#' @description
#' Updates the name or associated model for a Provisioned Throughput. For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrock_update_provisioned_model_throughput/](https://www.paws-r-sdk.com/docs/bedrock_update_provisioned_model_throughput/) for full documentation.
#'
#' @param provisionedModelId &#91;required&#93; The Amazon Resource Name (ARN) or name of the Provisioned Throughput to
#' update.
#' @param desiredProvisionedModelName The new name for this Provisioned Throughput.
#' @param desiredModelId The Amazon Resource Name (ARN) of the new model to associate with this
#' Provisioned Throughput. You can't specify this field if this Provisioned
#' Throughput is associated with a base model.
#' 
#' If this Provisioned Throughput is associated with a custom model, you
#' can specify one of the following options:
#' 
#' -   The base model from which the custom model was customized.
#' 
#' -   Another custom model that was customized from the same base model as
#'     the custom model.
#'
#' @keywords internal
#'
#' @rdname bedrock_update_provisioned_model_throughput
bedrock_update_provisioned_model_throughput <- function(provisionedModelId, desiredProvisionedModelName = NULL, desiredModelId = NULL) {
  op <- new_operation(
    name = "UpdateProvisionedModelThroughput",
    http_method = "PATCH",
    http_path = "/provisioned-model-throughput/{provisionedModelId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrock$update_provisioned_model_throughput_input(provisionedModelId = provisionedModelId, desiredProvisionedModelName = desiredProvisionedModelName, desiredModelId = desiredModelId)
  output <- .bedrock$update_provisioned_model_throughput_output()
  config <- get_config()
  svc <- .bedrock$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrock$operations$update_provisioned_model_throughput <- bedrock_update_provisioned_model_throughput
