% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrock_operations.R
\name{bedrock_create_model_import_job}
\alias{bedrock_create_model_import_job}
\title{Creates a model import job to import model that you have customized in
other environments, such as Amazon SageMaker}
\usage{
bedrock_create_model_import_job(
  jobName,
  importedModelName,
  roleArn,
  modelDataSource,
  jobTags = NULL,
  importedModelTags = NULL,
  clientRequestToken = NULL,
  vpcConfig = NULL,
  importedModelKmsKeyId = NULL
)
}
\arguments{
\item{jobName}{[required] The name of the import job.}

\item{importedModelName}{[required] The name of the imported model.}

\item{roleArn}{[required] The Amazon Resource Name (ARN) of the model import job.}

\item{modelDataSource}{[required] The data source for the imported model.}

\item{jobTags}{Tags to attach to this import job.}

\item{importedModelTags}{Tags to attach to the imported model.}

\item{clientRequestToken}{A unique, case-sensitive identifier to ensure that the API request
completes no more than one time. If this token matches a previous
request, Amazon Bedrock ignores the request, but does not return an
error. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}.}

\item{vpcConfig}{VPC configuration parameters for the private Virtual Private Cloud (VPC)
that contains the resources you are using for the import job.}

\item{importedModelKmsKeyId}{The imported model is encrypted at rest using this key.}
}
\description{
Creates a model import job to import model that you have customized in other environments, such as Amazon SageMaker. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html}{Import a customized model}

See \url{https://www.paws-r-sdk.com/docs/bedrock_create_model_import_job/} for full documentation.
}
\keyword{internal}
