% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevents_operations.R
\name{cloudwatchevents_test_event_pattern}
\alias{cloudwatchevents_test_event_pattern}
\title{Tests whether the specified event pattern matches the provided event}
\usage{
cloudwatchevents_test_event_pattern(EventPattern, Event)
}
\arguments{
\item{EventPattern}{[required] The event pattern. For more information, see \href{https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html}{Events and Event Patterns}
in the \emph{Amazon EventBridge User Guide}.}

\item{Event}{[required] The event, in JSON format, to test against the event pattern.}
}
\description{
Tests whether the specified event pattern matches the provided event.

Most services in AWS treat : or / as the same character in Amazon
Resource Names (ARNs). However, EventBridge uses an exact match in event
patterns and rules. Be sure to use the correct ARN characters when
creating event patterns so that they match the ARN syntax in the event
you want to match.
}
\section{Request syntax}{
\preformatted{svc$test_event_pattern(
  EventPattern = "string",
  Event = "string"
)
}
}

\keyword{internal}
