% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_put_destination_policy}
\alias{cloudwatchlogs_put_destination_policy}
\title{Creates or updates an access policy associated with an existing
destination}
\usage{
cloudwatchlogs_put_destination_policy(destinationName, accessPolicy)
}
\arguments{
\item{destinationName}{[required] A name for an existing destination.}

\item{accessPolicy}{[required] An IAM policy document that authorizes cross-account users to deliver
their log events to the associated destination. This can be up to 5120
bytes.}
}
\description{
Creates or updates an access policy associated with an existing
destination. An access policy is an \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html}{IAM policy document}
that is used to authorize claims to register a subscription filter
against a given destination.
}
\section{Request syntax}{
\preformatted{svc$put_destination_policy(
  destinationName = "string",
  accessPolicy = "string"
)
}
}

\keyword{internal}
