% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_create_deployment}
\alias{opsworks_create_deployment}
\title{Runs deployment or stack commands}
\usage{
opsworks_create_deployment(StackId, AppId, InstanceIds, LayerIds,
  Command, Comment, CustomJson)
}
\arguments{
\item{StackId}{[required] The stack ID.}

\item{AppId}{The app ID. This parameter is required for app deployments, but not for
other deployment commands.}

\item{InstanceIds}{The instance IDs for the deployment targets.}

\item{LayerIds}{The layer IDs for the deployment targets.}

\item{Command}{[required] A \code{DeploymentCommand} object that specifies the deployment command and
any associated arguments.}

\item{Comment}{A user-defined comment.}

\item{CustomJson}{A string that contains user-defined, custom JSON. You can use this
parameter to override some corresponding default stack configuration
JSON values. The string should be in the following format:

\verb{"\\\{\\"key1\\": \\"value1\\", \\"key2\\": \\"value2\\",...\\\}"}

For more information about custom JSON, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html}{Use Custom JSON to Modify the Stack Configuration Attributes}
and \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html}{Overriding Attributes With Custom JSON}.}
}
\description{
Runs deployment or stack commands. For more information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-deploying.html}{Deploying Apps}
and \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-commands.html}{Run Stack Commands}.

\strong{Required Permissions}: To use this action, an IAM user must have a
Deploy or Manage permissions level for the stack, or an attached policy
that explicitly grants permissions. For more information on user
permissions, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$create_deployment(
  StackId = "string",
  AppId = "string",
  InstanceIds = list(
    "string"
  ),
  LayerIds = list(
    "string"
  ),
  Command = list(
    Name = "install_dependencies"|"update_dependencies"|"update_custom_cookbooks"|"execute_recipes"|"configure"|"setup"|"deploy"|"rollback"|"start"|"stop"|"restart"|"undeploy",
    Args = list(
      list(
        "string"
      )
    )
  ),
  Comment = "string",
  CustomJson = "string"
)
}
}

\keyword{internal}
