% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_describe_apps}
\alias{opsworks_describe_apps}
\title{Requests a description of a specified set of apps}
\usage{
opsworks_describe_apps(StackId, AppIds)
}
\arguments{
\item{StackId}{The app stack ID. If you use this parameter, \code{DescribeApps} returns a
description of the apps in the specified stack.}

\item{AppIds}{An array of app IDs for the apps to be described. If you use this
parameter, \code{DescribeApps} returns a description of the specified apps.
Otherwise, it returns a description of every app.}
}
\description{
Requests a description of a specified set of apps.

This call accepts only one resource-identifying parameter.

\strong{Required Permissions}: To use this action, an IAM user must have a
Show, Deploy, or Manage permissions level for the stack, or an attached
policy that explicitly grants permissions. For more information about
user permissions, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$describe_apps(
  StackId = "string",
  AppIds = list(
    "string"
  )
)
}
}

\keyword{internal}
