% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_list_create_account_status}
\alias{organizations_list_create_account_status}
\title{Lists the account creation requests that match the specified status that
is currently being tracked for the organization}
\usage{
organizations_list_create_account_status(States, NextToken, MaxResults)
}
\arguments{
\item{States}{A list of one or more states that you want included in the response. If
this parameter isn't present, all requests are included in the response.}

\item{NextToken}{The parameter for receiving additional results if you receive a
\code{NextToken} response in a previous request. A \code{NextToken} response
indicates that more output is available. Set this parameter to the value
of the previous call's \code{NextToken} response to indicate where the output
should continue from.}

\item{MaxResults}{The total number of results that you want included on each page of the
response. If you do not include this parameter, it defaults to a value
that is specific to the operation. If additional items exist beyond the
maximum you specify, the \code{NextToken} response element is present and has
a value (is not null). Include that value as the \code{NextToken} request
parameter in the next call to the operation to get the next part of the
results. Note that Organizations might return fewer results than the
maximum even when there are more results available. You should check
\code{NextToken} after every operation to ensure that you receive all of the
results.}
}
\description{
Lists the account creation requests that match the specified status that
is currently being tracked for the organization.

Always check the \code{NextToken} response parameter for a \code{null} value when
calling a \verb{List*} operation. These operations can occasionally return an
empty set of results even when there are more results available. The
\code{NextToken} response parameter value is \code{null} \emph{only} when there are no
more results to display.

This operation can be called only from the organization's management
account or by a member account that is a delegated administrator for an
AWS service.
}
\section{Request syntax}{
\preformatted{svc$list_create_account_status(
  States = list(
    "IN_PROGRESS"|"SUCCEEDED"|"FAILED"
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\examples{
\dontrun{
# The following example shows a user requesting a list of only the
# completed account creation requests made for the current organization:
svc$list_create_account_status(
  States = list(
    "SUCCEEDED"
  )
)

# The following example shows a user requesting a list of only the
# in-progress account creation requests made for the current organization:
svc$list_create_account_status(
  States = list(
    "IN_PROGRESS"
  )
)
}

}
\keyword{internal}
