% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_list_document_metadata_history}
\alias{ssm_list_document_metadata_history}
\title{Information about approval reviews for a version of an SSM document}
\usage{
ssm_list_document_metadata_history(Name, DocumentVersion, Metadata,
  NextToken, MaxResults)
}
\arguments{
\item{Name}{[required] The name of the document.}

\item{DocumentVersion}{The version of the document.}

\item{Metadata}{[required] The type of data for which details are being requested. Currently, the
only supported value is \code{DocumentReviews}.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}
}
\description{
Information about approval reviews for a version of an SSM document.
}
\section{Request syntax}{
\preformatted{svc$list_document_metadata_history(
  Name = "string",
  DocumentVersion = "string",
  Metadata = "DocumentReviews",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
