% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_delete_lifecycle_hook}
\alias{autoscaling_delete_lifecycle_hook}
\title{Deletes the specified lifecycle hook}
\usage{
autoscaling_delete_lifecycle_hook(LifecycleHookName,
  AutoScalingGroupName)
}
\arguments{
\item{LifecycleHookName}{[required] The name of the lifecycle hook.}

\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}
}
\value{
An empty list.
}
\description{
Deletes the specified lifecycle hook.

If there are any outstanding lifecycle actions, they are completed first
(\code{ABANDON} for launching instances, \code{CONTINUE} for terminating
instances).
}
\section{Request syntax}{
\preformatted{svc$delete_lifecycle_hook(
  LifecycleHookName = "string",
  AutoScalingGroupName = "string"
)
}
}

\examples{
\dontrun{
# This example deletes the specified lifecycle hook.
svc$delete_lifecycle_hook(
  AutoScalingGroupName = "my-auto-scaling-group",
  LifecycleHookName = "my-lifecycle-hook"
)
}

}
\keyword{internal}
