% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_create_ops_item}
\alias{ssm_create_ops_item}
\title{Creates a new OpsItem}
\usage{
ssm_create_ops_item(Description, OpsItemType, OperationalData,
  Notifications, Priority, RelatedOpsItems, Source, Title, Tags, Category,
  Severity, ActualStartTime, ActualEndTime, PlannedStartTime,
  PlannedEndTime)
}
\arguments{
\item{Description}{[required] Information about the OpsItem.}

\item{OpsItemType}{The type of OpsItem to create. Currently, the only valid values are
\verb{/aws/changerequest} and \verb{/aws/issue}.}

\item{OperationalData}{Operational data is custom data that provides useful reference details
about the OpsItem. For example, you can specify log files, error
strings, license keys, troubleshooting tips, or other relevant data. You
enter operational data as key-value pairs. The key has a maximum length
of 128 characters. The value has a maximum size of 20 KB.

Operational data keys \emph{can't} begin with the following: amazon, aws,
amzn, ssm, /amazon, /aws, /amzn, /ssm.

You can choose to make the data searchable by other users in the account
or you can restrict search access. Searchable data means that all users
with access to the OpsItem Overview page (as provided by the
\code{\link[=ssm_describe_ops_items]{describe_ops_items}} API action) can view and
search on the specified data. Operational data that is not searchable is
only viewable by users who have access to the OpsItem (as provided by
the \code{\link[=ssm_get_ops_item]{get_ops_item}} API action).

Use the \verb{/aws/resources} key in OperationalData to specify a related
resource in the request. Use the \verb{/aws/automations} key in
OperationalData to associate an Automation runbook with the OpsItem. To
view AWS CLI example commands that use these keys, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems}{Creating OpsItems manually}
in the \emph{AWS Systems Manager User Guide}.}

\item{Notifications}{The Amazon Resource Name (ARN) of an SNS topic where notifications are
sent when this OpsItem is edited or changed.}

\item{Priority}{The importance of this OpsItem in relation to other OpsItems in the
system.}

\item{RelatedOpsItems}{One or more OpsItems that share something in common with the current
OpsItems. For example, related OpsItems can include OpsItems with
similar error messages, impacted resources, or statuses for the impacted
resource.}

\item{Source}{[required] The origin of the OpsItem, such as Amazon EC2 or Systems Manager.

The source name can't contain the following strings: aws, amazon, and
amzn.}

\item{Title}{[required] A short heading that describes the nature of the OpsItem and the
impacted resource.}

\item{Tags}{Optional metadata that you assign to a resource. You can restrict access
to OpsItems by using an inline IAM policy that specifies tags. For more
information, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html#OpsCenter-getting-started-user-permissions}{Getting started with OpsCenter}
in the \emph{AWS Systems Manager User Guide}.

Tags use a key-value pair. For example:

\verb{Key=Department,Value=Finance}

To add tags to an existing OpsItem, use the
\code{\link[=ssm_add_tags_to_resource]{add_tags_to_resource}} action.}

\item{Category}{Specify a category to assign to an OpsItem.}

\item{Severity}{Specify a severity to assign to an OpsItem.}

\item{ActualStartTime}{The time a runbook workflow started. Currently reported only for the
OpsItem type \verb{/aws/changerequest}.}

\item{ActualEndTime}{The time a runbook workflow ended. Currently reported only for the
OpsItem type \verb{/aws/changerequest}.}

\item{PlannedStartTime}{The time specified in a change request for a runbook workflow to start.
Currently supported only for the OpsItem type \verb{/aws/changerequest}.}

\item{PlannedEndTime}{The time specified in a change request for a runbook workflow to end.
Currently supported only for the OpsItem type \verb{/aws/changerequest}.}
}
\value{
A list with the following syntax:\preformatted{list(
  OpsItemId = "string"
)
}
}
\description{
Creates a new OpsItem. You must have permission in AWS Identity and
Access Management (IAM) to create a new OpsItem. For more information,
see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html}{Getting started with OpsCenter}
in the \emph{AWS Systems Manager User Guide}.

Operations engineers and IT professionals use OpsCenter to view,
investigate, and remediate operational issues impacting the performance
and health of their AWS resources. For more information, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html}{AWS Systems Manager OpsCenter}
in the \emph{AWS Systems Manager User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_ops_item(
  Description = "string",
  OpsItemType = "string",
  OperationalData = list(
    list(
      Value = "string",
      Type = "SearchableString"|"String"
    )
  ),
  Notifications = list(
    list(
      Arn = "string"
    )
  ),
  Priority = 123,
  RelatedOpsItems = list(
    list(
      OpsItemId = "string"
    )
  ),
  Source = "string",
  Title = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  Category = "string",
  Severity = "string",
  ActualStartTime = as.POSIXct(
    "2015-01-01"
  ),
  ActualEndTime = as.POSIXct(
    "2015-01-01"
  ),
  PlannedStartTime = as.POSIXct(
    "2015-01-01"
  ),
  PlannedEndTime = as.POSIXct(
    "2015-01-01"
  )
)
}
}

\keyword{internal}
