% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_describe_sessions}
\alias{ssm_describe_sessions}
\title{Retrieves a list of all active sessions (both connected and
disconnected) or terminated sessions from the past 30 days}
\usage{
ssm_describe_sessions(State, MaxResults, NextToken, Filters)
}
\arguments{
\item{State}{[required] The session status to retrieve a list of sessions for. For example,
"Active".}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}

\item{Filters}{One or more filters to limit the type of sessions returned by the
request.}
}
\value{
A list with the following syntax:\preformatted{list(
  Sessions = list(
    list(
      SessionId = "string",
      Target = "string",
      Status = "Connected"|"Connecting"|"Disconnected"|"Terminated"|"Terminating"|"Failed",
      StartDate = as.POSIXct(
        "2015-01-01"
      ),
      EndDate = as.POSIXct(
        "2015-01-01"
      ),
      DocumentName = "string",
      Owner = "string",
      Details = "string",
      OutputUrl = list(
        S3OutputUrl = "string",
        CloudWatchOutputUrl = "string"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Retrieves a list of all active sessions (both connected and
disconnected) or terminated sessions from the past 30 days.
}
\section{Request syntax}{
\preformatted{svc$describe_sessions(
  State = "Active"|"History",
  MaxResults = 123,
  NextToken = "string",
  Filters = list(
    list(
      key = "InvokedAfter"|"InvokedBefore"|"Target"|"Owner"|"Status"|"SessionId",
      value = "string"
    )
  )
)
}
}

\keyword{internal}
