% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_operations.R
\name{support_add_communication_to_case}
\alias{support_add_communication_to_case}
\title{Adds additional customer communication to an AWS Support case}
\usage{
support_add_communication_to_case(caseId, communicationBody,
  ccEmailAddresses, attachmentSetId)
}
\arguments{
\item{caseId}{The AWS Support case ID requested or returned in the call. The case ID
is an alphanumeric string formatted as shown in this example:
case-\emph{12345678910-2013-c4c1d2bf33c5cf47}}

\item{communicationBody}{[required] The body of an email communication to add to the support case.}

\item{ccEmailAddresses}{The email addresses in the CC line of an email to be added to the
support case.}

\item{attachmentSetId}{The ID of a set of one or more attachments for the communication to add
to the case. Create the set by calling AddAttachmentsToSet}
}
\description{
Adds additional customer communication to an AWS Support case. You use
the \code{caseId} value to identify the case to add communication to. You can
list a set of email addresses to copy on the communication using the
\code{ccEmailAddresses} value. The \code{communicationBody} value contains the
text of the communication.
}
\details{
The response indicates the success or failure of the request.

This operation implements a subset of the features of the AWS Support
Center.
}
\section{Request syntax}{
\preformatted{svc$add_communication_to_case(
  caseId = "string",
  communicationBody = "string",
  ccEmailAddresses = list(
    "string"
  ),
  attachmentSetId = "string"
)
}
}

\keyword{internal}
