# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include applicationautoscaling_service.R
NULL

#' Deletes the specified Application Auto Scaling scaling policy
#'
#' Deletes the specified Application Auto Scaling scaling policy.
#' 
#' Deleting a policy deletes the underlying alarm action, but does not
#' delete the CloudWatch alarm associated with the scaling policy, even if
#' it no longer has an associated action.
#' 
#' To create a scaling policy or update an existing one, see
#' PutScalingPolicy.
#'
#' @usage
#' applicationautoscaling_delete_scaling_policy(PolicyName,
#'   ServiceNamespace, ResourceId, ScalableDimension)
#'
#' @param PolicyName &#91;required&#93; The name of the scaling policy.
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service that provides the resource or
#' `custom-resource` for a resource provided by your own application or
#' service. For more information, see [AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
#' in the *Amazon Web Services General Reference*.
#' @param ResourceId &#91;required&#93; The identifier of the resource associated with the scalable target. This
#' string consists of the resource type and unique identifier.
#' 
#' -   ECS service - The resource type is `service` and the unique
#'     identifier is the cluster name and service name. Example:
#'     `service/default/sample-webapp`.
#' 
#' -   Spot fleet request - The resource type is `spot-fleet-request` and
#'     the unique identifier is the Spot fleet request ID. Example:
#'     `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
#' 
#' -   EMR cluster - The resource type is `instancegroup` and the unique
#'     identifier is the cluster ID and instance group ID. Example:
#'     `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
#' 
#' -   AppStream 2.0 fleet - The resource type is `fleet` and the unique
#'     identifier is the fleet name. Example: `fleet/sample-fleet`.
#' 
#' -   DynamoDB table - The resource type is `table` and the unique
#'     identifier is the resource ID. Example: `table/my-table`.
#' 
#' -   DynamoDB global secondary index - The resource type is `index` and
#'     the unique identifier is the resource ID. Example:
#'     `table/my-table/index/my-table-index`.
#' 
#' -   Aurora DB cluster - The resource type is `cluster` and the unique
#'     identifier is the cluster name. Example: `cluster:my-db-cluster`.
#' 
#' -   Amazon SageMaker endpoint variants - The resource type is `variant`
#'     and the unique identifier is the resource ID. Example:
#'     `endpoint/my-end-point/variant/KMeansClustering`.
#' 
#' -   Custom resources are not supported with a resource type. This
#'     parameter must specify the `OutputValue` from the CloudFormation
#'     template stack used to access the resources. The unique identifier
#'     is defined by the service provider. More information is available in
#'     our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' @param ScalableDimension &#91;required&#93; The scalable dimension. This string consists of the service namespace,
#' resource type, and scaling property.
#' 
#' -   `ecs:service:DesiredCount` - The desired task count of an ECS
#'     service.
#' 
#' -   `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a
#'     Spot fleet request.
#' 
#' -   `elasticmapreduce:instancegroup:InstanceCount` - The instance count
#'     of an EMR Instance Group.
#' 
#' -   `appstream:fleet:DesiredCapacity` - The desired capacity of an
#'     AppStream 2.0 fleet.
#' 
#' -   `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an
#'     Aurora DB cluster. Available for Aurora MySQL-compatible edition and
#'     Aurora PostgreSQL-compatible edition.
#' 
#' -   `sagemaker:variant:DesiredInstanceCount` - The number of EC2
#'     instances for an Amazon SageMaker model endpoint variant.
#' 
#' -   `custom-resource:ResourceType:Property` - The scalable dimension for
#'     a custom resource provided by your own application or service.
#'
#' @section Request syntax:
#' ```
#' svc$delete_scaling_policy(
#'   PolicyName = "string",
#'   ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource",
#'   ResourceId = "string",
#'   ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property"
#' )
#' ```
#'
#' @examples
#' # This example deletes a scaling policy for the Amazon ECS service called
#' # web-app, which is running in the default cluster.
#' \donttest{svc$delete_scaling_policy(
#'   PolicyName = "web-app-cpu-lt-25",
#'   ResourceId = "service/default/web-app",
#'   ScalableDimension = "ecs:service:DesiredCount",
#'   ServiceNamespace = "ecs"
#' )}
#'
#' @keywords internal
#'
#' @rdname applicationautoscaling_delete_scaling_policy
applicationautoscaling_delete_scaling_policy <- function(PolicyName, ServiceNamespace, ResourceId, ScalableDimension) {
  op <- new_operation(
    name = "DeleteScalingPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationautoscaling$delete_scaling_policy_input(PolicyName = PolicyName, ServiceNamespace = ServiceNamespace, ResourceId = ResourceId, ScalableDimension = ScalableDimension)
  output <- .applicationautoscaling$delete_scaling_policy_output()
  svc <- .applicationautoscaling$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationautoscaling$operations$delete_scaling_policy <- applicationautoscaling_delete_scaling_policy

#' Deletes the specified Application Auto Scaling scheduled action
#'
#' Deletes the specified Application Auto Scaling scheduled action.
#'
#' @usage
#' applicationautoscaling_delete_scheduled_action(ServiceNamespace,
#'   ScheduledActionName, ResourceId, ScalableDimension)
#'
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service that provides the resource or
#' `custom-resource` for a resource provided by your own application or
#' service. For more information, see [AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
#' in the *Amazon Web Services General Reference*.
#' @param ScheduledActionName &#91;required&#93; The name of the scheduled action.
#' @param ResourceId &#91;required&#93; The identifier of the resource associated with the scheduled action.
#' This string consists of the resource type and unique identifier.
#' 
#' -   ECS service - The resource type is `service` and the unique
#'     identifier is the cluster name and service name. Example:
#'     `service/default/sample-webapp`.
#' 
#' -   Spot fleet request - The resource type is `spot-fleet-request` and
#'     the unique identifier is the Spot fleet request ID. Example:
#'     `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
#' 
#' -   EMR cluster - The resource type is `instancegroup` and the unique
#'     identifier is the cluster ID and instance group ID. Example:
#'     `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
#' 
#' -   AppStream 2.0 fleet - The resource type is `fleet` and the unique
#'     identifier is the fleet name. Example: `fleet/sample-fleet`.
#' 
#' -   DynamoDB table - The resource type is `table` and the unique
#'     identifier is the resource ID. Example: `table/my-table`.
#' 
#' -   DynamoDB global secondary index - The resource type is `index` and
#'     the unique identifier is the resource ID. Example:
#'     `table/my-table/index/my-table-index`.
#' 
#' -   Aurora DB cluster - The resource type is `cluster` and the unique
#'     identifier is the cluster name. Example: `cluster:my-db-cluster`.
#' 
#' -   Amazon SageMaker endpoint variants - The resource type is `variant`
#'     and the unique identifier is the resource ID. Example:
#'     `endpoint/my-end-point/variant/KMeansClustering`.
#' 
#' -   Custom resources are not supported with a resource type. This
#'     parameter must specify the `OutputValue` from the CloudFormation
#'     template stack used to access the resources. The unique identifier
#'     is defined by the service provider. More information is available in
#'     our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' @param ScalableDimension &#91;required&#93; The scalable dimension. This string consists of the service namespace,
#' resource type, and scaling property.
#' 
#' -   `ecs:service:DesiredCount` - The desired task count of an ECS
#'     service.
#' 
#' -   `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a
#'     Spot fleet request.
#' 
#' -   `elasticmapreduce:instancegroup:InstanceCount` - The instance count
#'     of an EMR Instance Group.
#' 
#' -   `appstream:fleet:DesiredCapacity` - The desired capacity of an
#'     AppStream 2.0 fleet.
#' 
#' -   `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an
#'     Aurora DB cluster. Available for Aurora MySQL-compatible edition and
#'     Aurora PostgreSQL-compatible edition.
#' 
#' -   `sagemaker:variant:DesiredInstanceCount` - The number of EC2
#'     instances for an Amazon SageMaker model endpoint variant.
#' 
#' -   `custom-resource:ResourceType:Property` - The scalable dimension for
#'     a custom resource provided by your own application or service.
#'
#' @section Request syntax:
#' ```
#' svc$delete_scheduled_action(
#'   ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource",
#'   ScheduledActionName = "string",
#'   ResourceId = "string",
#'   ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationautoscaling_delete_scheduled_action
applicationautoscaling_delete_scheduled_action <- function(ServiceNamespace, ScheduledActionName, ResourceId, ScalableDimension) {
  op <- new_operation(
    name = "DeleteScheduledAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationautoscaling$delete_scheduled_action_input(ServiceNamespace = ServiceNamespace, ScheduledActionName = ScheduledActionName, ResourceId = ResourceId, ScalableDimension = ScalableDimension)
  output <- .applicationautoscaling$delete_scheduled_action_output()
  svc <- .applicationautoscaling$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationautoscaling$operations$delete_scheduled_action <- applicationautoscaling_delete_scheduled_action

#' Deregisters a scalable target
#'
#' Deregisters a scalable target.
#' 
#' Deregistering a scalable target deletes the scaling policies that are
#' associated with it.
#' 
#' To create a scalable target or update an existing one, see
#' RegisterScalableTarget.
#'
#' @usage
#' applicationautoscaling_deregister_scalable_target(ServiceNamespace,
#'   ResourceId, ScalableDimension)
#'
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service that provides the resource or
#' `custom-resource` for a resource provided by your own application or
#' service. For more information, see [AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
#' in the *Amazon Web Services General Reference*.
#' @param ResourceId &#91;required&#93; The identifier of the resource associated with the scalable target. This
#' string consists of the resource type and unique identifier.
#' 
#' -   ECS service - The resource type is `service` and the unique
#'     identifier is the cluster name and service name. Example:
#'     `service/default/sample-webapp`.
#' 
#' -   Spot fleet request - The resource type is `spot-fleet-request` and
#'     the unique identifier is the Spot fleet request ID. Example:
#'     `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
#' 
#' -   EMR cluster - The resource type is `instancegroup` and the unique
#'     identifier is the cluster ID and instance group ID. Example:
#'     `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
#' 
#' -   AppStream 2.0 fleet - The resource type is `fleet` and the unique
#'     identifier is the fleet name. Example: `fleet/sample-fleet`.
#' 
#' -   DynamoDB table - The resource type is `table` and the unique
#'     identifier is the resource ID. Example: `table/my-table`.
#' 
#' -   DynamoDB global secondary index - The resource type is `index` and
#'     the unique identifier is the resource ID. Example:
#'     `table/my-table/index/my-table-index`.
#' 
#' -   Aurora DB cluster - The resource type is `cluster` and the unique
#'     identifier is the cluster name. Example: `cluster:my-db-cluster`.
#' 
#' -   Amazon SageMaker endpoint variants - The resource type is `variant`
#'     and the unique identifier is the resource ID. Example:
#'     `endpoint/my-end-point/variant/KMeansClustering`.
#' 
#' -   Custom resources are not supported with a resource type. This
#'     parameter must specify the `OutputValue` from the CloudFormation
#'     template stack used to access the resources. The unique identifier
#'     is defined by the service provider. More information is available in
#'     our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' @param ScalableDimension &#91;required&#93; The scalable dimension associated with the scalable target. This string
#' consists of the service namespace, resource type, and scaling property.
#' 
#' -   `ecs:service:DesiredCount` - The desired task count of an ECS
#'     service.
#' 
#' -   `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a
#'     Spot fleet request.
#' 
#' -   `elasticmapreduce:instancegroup:InstanceCount` - The instance count
#'     of an EMR Instance Group.
#' 
#' -   `appstream:fleet:DesiredCapacity` - The desired capacity of an
#'     AppStream 2.0 fleet.
#' 
#' -   `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an
#'     Aurora DB cluster. Available for Aurora MySQL-compatible edition and
#'     Aurora PostgreSQL-compatible edition.
#' 
#' -   `sagemaker:variant:DesiredInstanceCount` - The number of EC2
#'     instances for an Amazon SageMaker model endpoint variant.
#' 
#' -   `custom-resource:ResourceType:Property` - The scalable dimension for
#'     a custom resource provided by your own application or service.
#'
#' @section Request syntax:
#' ```
#' svc$deregister_scalable_target(
#'   ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource",
#'   ResourceId = "string",
#'   ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property"
#' )
#' ```
#'
#' @examples
#' # This example deregisters a scalable target for an Amazon ECS service
#' # called web-app that is running in the default cluster.
#' \donttest{svc$deregister_scalable_target(
#'   ResourceId = "service/default/web-app",
#'   ScalableDimension = "ecs:service:DesiredCount",
#'   ServiceNamespace = "ecs"
#' )}
#'
#' @keywords internal
#'
#' @rdname applicationautoscaling_deregister_scalable_target
applicationautoscaling_deregister_scalable_target <- function(ServiceNamespace, ResourceId, ScalableDimension) {
  op <- new_operation(
    name = "DeregisterScalableTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationautoscaling$deregister_scalable_target_input(ServiceNamespace = ServiceNamespace, ResourceId = ResourceId, ScalableDimension = ScalableDimension)
  output <- .applicationautoscaling$deregister_scalable_target_output()
  svc <- .applicationautoscaling$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationautoscaling$operations$deregister_scalable_target <- applicationautoscaling_deregister_scalable_target

#' Gets information about the scalable targets in the specified namespace
#'
#' Gets information about the scalable targets in the specified namespace.
#' 
#' You can filter the results using the `ResourceIds` and
#' `ScalableDimension` parameters.
#' 
#' To create a scalable target or update an existing one, see
#' RegisterScalableTarget. If you are no longer using a scalable target,
#' you can deregister it using DeregisterScalableTarget.
#'
#' @usage
#' applicationautoscaling_describe_scalable_targets(ServiceNamespace,
#'   ResourceIds, ScalableDimension, MaxResults, NextToken)
#'
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service that provides the resource or
#' `custom-resource` for a resource provided by your own application or
#' service. For more information, see [AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
#' in the *Amazon Web Services General Reference*.
#' @param ResourceIds The identifier of the resource associated with the scalable target. This
#' string consists of the resource type and unique identifier. If you
#' specify a scalable dimension, you must also specify a resource ID.
#' 
#' -   ECS service - The resource type is `service` and the unique
#'     identifier is the cluster name and service name. Example:
#'     `service/default/sample-webapp`.
#' 
#' -   Spot fleet request - The resource type is `spot-fleet-request` and
#'     the unique identifier is the Spot fleet request ID. Example:
#'     `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
#' 
#' -   EMR cluster - The resource type is `instancegroup` and the unique
#'     identifier is the cluster ID and instance group ID. Example:
#'     `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
#' 
#' -   AppStream 2.0 fleet - The resource type is `fleet` and the unique
#'     identifier is the fleet name. Example: `fleet/sample-fleet`.
#' 
#' -   DynamoDB table - The resource type is `table` and the unique
#'     identifier is the resource ID. Example: `table/my-table`.
#' 
#' -   DynamoDB global secondary index - The resource type is `index` and
#'     the unique identifier is the resource ID. Example:
#'     `table/my-table/index/my-table-index`.
#' 
#' -   Aurora DB cluster - The resource type is `cluster` and the unique
#'     identifier is the cluster name. Example: `cluster:my-db-cluster`.
#' 
#' -   Amazon SageMaker endpoint variants - The resource type is `variant`
#'     and the unique identifier is the resource ID. Example:
#'     `endpoint/my-end-point/variant/KMeansClustering`.
#' 
#' -   Custom resources are not supported with a resource type. This
#'     parameter must specify the `OutputValue` from the CloudFormation
#'     template stack used to access the resources. The unique identifier
#'     is defined by the service provider. More information is available in
#'     our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' @param ScalableDimension The scalable dimension associated with the scalable target. This string
#' consists of the service namespace, resource type, and scaling property.
#' If you specify a scalable dimension, you must also specify a resource
#' ID.
#' 
#' -   `ecs:service:DesiredCount` - The desired task count of an ECS
#'     service.
#' 
#' -   `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a
#'     Spot fleet request.
#' 
#' -   `elasticmapreduce:instancegroup:InstanceCount` - The instance count
#'     of an EMR Instance Group.
#' 
#' -   `appstream:fleet:DesiredCapacity` - The desired capacity of an
#'     AppStream 2.0 fleet.
#' 
#' -   `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an
#'     Aurora DB cluster. Available for Aurora MySQL-compatible edition and
#'     Aurora PostgreSQL-compatible edition.
#' 
#' -   `sagemaker:variant:DesiredInstanceCount` - The number of EC2
#'     instances for an Amazon SageMaker model endpoint variant.
#' 
#' -   `custom-resource:ResourceType:Property` - The scalable dimension for
#'     a custom resource provided by your own application or service.
#' @param MaxResults The maximum number of scalable targets. This value can be between 1 and
#' 50. The default value is 50.
#' 
#' If this parameter is used, the operation returns up to `MaxResults`
#' results at a time, along with a `NextToken` value. To get the next set
#' of results, include the `NextToken` value in a subsequent call. If this
#' parameter is not used, the operation returns up to 50 results and a
#' `NextToken` value, if applicable.
#' @param NextToken The token for the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_scalable_targets(
#'   ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource",
#'   ResourceIds = list(
#'     "string"
#'   ),
#'   ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' # This example describes the scalable targets for the ecs service
#' # namespace.
#' \donttest{svc$describe_scalable_targets(
#'   ServiceNamespace = "ecs"
#' )}
#'
#' @keywords internal
#'
#' @rdname applicationautoscaling_describe_scalable_targets
applicationautoscaling_describe_scalable_targets <- function(ServiceNamespace, ResourceIds = NULL, ScalableDimension = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeScalableTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationautoscaling$describe_scalable_targets_input(ServiceNamespace = ServiceNamespace, ResourceIds = ResourceIds, ScalableDimension = ScalableDimension, MaxResults = MaxResults, NextToken = NextToken)
  output <- .applicationautoscaling$describe_scalable_targets_output()
  svc <- .applicationautoscaling$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationautoscaling$operations$describe_scalable_targets <- applicationautoscaling_describe_scalable_targets

#' Provides descriptive information about the scaling activities in the
#' specified namespace from the previous six weeks
#'
#' Provides descriptive information about the scaling activities in the
#' specified namespace from the previous six weeks.
#' 
#' You can filter the results using the `ResourceId` and
#' `ScalableDimension` parameters.
#' 
#' Scaling activities are triggered by CloudWatch alarms that are
#' associated with scaling policies. To view the scaling policies for a
#' service namespace, see DescribeScalingPolicies. To create a scaling
#' policy or update an existing one, see PutScalingPolicy.
#'
#' @usage
#' applicationautoscaling_describe_scaling_activities(ServiceNamespace,
#'   ResourceId, ScalableDimension, MaxResults, NextToken)
#'
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service that provides the resource or
#' `custom-resource` for a resource provided by your own application or
#' service. For more information, see [AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
#' in the *Amazon Web Services General Reference*.
#' @param ResourceId The identifier of the resource associated with the scaling activity.
#' This string consists of the resource type and unique identifier. If you
#' specify a scalable dimension, you must also specify a resource ID.
#' 
#' -   ECS service - The resource type is `service` and the unique
#'     identifier is the cluster name and service name. Example:
#'     `service/default/sample-webapp`.
#' 
#' -   Spot fleet request - The resource type is `spot-fleet-request` and
#'     the unique identifier is the Spot fleet request ID. Example:
#'     `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
#' 
#' -   EMR cluster - The resource type is `instancegroup` and the unique
#'     identifier is the cluster ID and instance group ID. Example:
#'     `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
#' 
#' -   AppStream 2.0 fleet - The resource type is `fleet` and the unique
#'     identifier is the fleet name. Example: `fleet/sample-fleet`.
#' 
#' -   DynamoDB table - The resource type is `table` and the unique
#'     identifier is the resource ID. Example: `table/my-table`.
#' 
#' -   DynamoDB global secondary index - The resource type is `index` and
#'     the unique identifier is the resource ID. Example:
#'     `table/my-table/index/my-table-index`.
#' 
#' -   Aurora DB cluster - The resource type is `cluster` and the unique
#'     identifier is the cluster name. Example: `cluster:my-db-cluster`.
#' 
#' -   Amazon SageMaker endpoint variants - The resource type is `variant`
#'     and the unique identifier is the resource ID. Example:
#'     `endpoint/my-end-point/variant/KMeansClustering`.
#' 
#' -   Custom resources are not supported with a resource type. This
#'     parameter must specify the `OutputValue` from the CloudFormation
#'     template stack used to access the resources. The unique identifier
#'     is defined by the service provider. More information is available in
#'     our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' @param ScalableDimension The scalable dimension. This string consists of the service namespace,
#' resource type, and scaling property. If you specify a scalable
#' dimension, you must also specify a resource ID.
#' 
#' -   `ecs:service:DesiredCount` - The desired task count of an ECS
#'     service.
#' 
#' -   `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a
#'     Spot fleet request.
#' 
#' -   `elasticmapreduce:instancegroup:InstanceCount` - The instance count
#'     of an EMR Instance Group.
#' 
#' -   `appstream:fleet:DesiredCapacity` - The desired capacity of an
#'     AppStream 2.0 fleet.
#' 
#' -   `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an
#'     Aurora DB cluster. Available for Aurora MySQL-compatible edition and
#'     Aurora PostgreSQL-compatible edition.
#' 
#' -   `sagemaker:variant:DesiredInstanceCount` - The number of EC2
#'     instances for an Amazon SageMaker model endpoint variant.
#' 
#' -   `custom-resource:ResourceType:Property` - The scalable dimension for
#'     a custom resource provided by your own application or service.
#' @param MaxResults The maximum number of scalable targets. This value can be between 1 and
#' 50. The default value is 50.
#' 
#' If this parameter is used, the operation returns up to `MaxResults`
#' results at a time, along with a `NextToken` value. To get the next set
#' of results, include the `NextToken` value in a subsequent call. If this
#' parameter is not used, the operation returns up to 50 results and a
#' `NextToken` value, if applicable.
#' @param NextToken The token for the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_scaling_activities(
#'   ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource",
#'   ResourceId = "string",
#'   ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' # This example describes the scaling activities for an Amazon ECS service
#' # called web-app that is running in the default cluster.
#' \donttest{svc$describe_scaling_activities(
#'   ResourceId = "service/default/web-app",
#'   ScalableDimension = "ecs:service:DesiredCount",
#'   ServiceNamespace = "ecs"
#' )}
#'
#' @keywords internal
#'
#' @rdname applicationautoscaling_describe_scaling_activities
applicationautoscaling_describe_scaling_activities <- function(ServiceNamespace, ResourceId = NULL, ScalableDimension = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeScalingActivities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationautoscaling$describe_scaling_activities_input(ServiceNamespace = ServiceNamespace, ResourceId = ResourceId, ScalableDimension = ScalableDimension, MaxResults = MaxResults, NextToken = NextToken)
  output <- .applicationautoscaling$describe_scaling_activities_output()
  svc <- .applicationautoscaling$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationautoscaling$operations$describe_scaling_activities <- applicationautoscaling_describe_scaling_activities

#' Describes the scaling policies for the specified service namespace
#'
#' Describes the scaling policies for the specified service namespace.
#' 
#' You can filter the results using the `ResourceId`, `ScalableDimension`,
#' and `PolicyNames` parameters.
#' 
#' To create a scaling policy or update an existing one, see
#' PutScalingPolicy. If you are no longer using a scaling policy, you can
#' delete it using DeleteScalingPolicy.
#'
#' @usage
#' applicationautoscaling_describe_scaling_policies(PolicyNames,
#'   ServiceNamespace, ResourceId, ScalableDimension, MaxResults, NextToken)
#'
#' @param PolicyNames The names of the scaling policies to describe.
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service that provides the resource or
#' `custom-resource` for a resource provided by your own application or
#' service. For more information, see [AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
#' in the *Amazon Web Services General Reference*.
#' @param ResourceId The identifier of the resource associated with the scaling policy. This
#' string consists of the resource type and unique identifier. If you
#' specify a scalable dimension, you must also specify a resource ID.
#' 
#' -   ECS service - The resource type is `service` and the unique
#'     identifier is the cluster name and service name. Example:
#'     `service/default/sample-webapp`.
#' 
#' -   Spot fleet request - The resource type is `spot-fleet-request` and
#'     the unique identifier is the Spot fleet request ID. Example:
#'     `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
#' 
#' -   EMR cluster - The resource type is `instancegroup` and the unique
#'     identifier is the cluster ID and instance group ID. Example:
#'     `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
#' 
#' -   AppStream 2.0 fleet - The resource type is `fleet` and the unique
#'     identifier is the fleet name. Example: `fleet/sample-fleet`.
#' 
#' -   DynamoDB table - The resource type is `table` and the unique
#'     identifier is the resource ID. Example: `table/my-table`.
#' 
#' -   DynamoDB global secondary index - The resource type is `index` and
#'     the unique identifier is the resource ID. Example:
#'     `table/my-table/index/my-table-index`.
#' 
#' -   Aurora DB cluster - The resource type is `cluster` and the unique
#'     identifier is the cluster name. Example: `cluster:my-db-cluster`.
#' 
#' -   Amazon SageMaker endpoint variants - The resource type is `variant`
#'     and the unique identifier is the resource ID. Example:
#'     `endpoint/my-end-point/variant/KMeansClustering`.
#' 
#' -   Custom resources are not supported with a resource type. This
#'     parameter must specify the `OutputValue` from the CloudFormation
#'     template stack used to access the resources. The unique identifier
#'     is defined by the service provider. More information is available in
#'     our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' @param ScalableDimension The scalable dimension. This string consists of the service namespace,
#' resource type, and scaling property. If you specify a scalable
#' dimension, you must also specify a resource ID.
#' 
#' -   `ecs:service:DesiredCount` - The desired task count of an ECS
#'     service.
#' 
#' -   `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a
#'     Spot fleet request.
#' 
#' -   `elasticmapreduce:instancegroup:InstanceCount` - The instance count
#'     of an EMR Instance Group.
#' 
#' -   `appstream:fleet:DesiredCapacity` - The desired capacity of an
#'     AppStream 2.0 fleet.
#' 
#' -   `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an
#'     Aurora DB cluster. Available for Aurora MySQL-compatible edition and
#'     Aurora PostgreSQL-compatible edition.
#' 
#' -   `sagemaker:variant:DesiredInstanceCount` - The number of EC2
#'     instances for an Amazon SageMaker model endpoint variant.
#' 
#' -   `custom-resource:ResourceType:Property` - The scalable dimension for
#'     a custom resource provided by your own application or service.
#' @param MaxResults The maximum number of scalable targets. This value can be between 1 and
#' 50. The default value is 50.
#' 
#' If this parameter is used, the operation returns up to `MaxResults`
#' results at a time, along with a `NextToken` value. To get the next set
#' of results, include the `NextToken` value in a subsequent call. If this
#' parameter is not used, the operation returns up to 50 results and a
#' `NextToken` value, if applicable.
#' @param NextToken The token for the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_scaling_policies(
#'   PolicyNames = list(
#'     "string"
#'   ),
#'   ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource",
#'   ResourceId = "string",
#'   ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' # This example describes the scaling policies for the ecs service
#' # namespace.
#' \donttest{svc$describe_scaling_policies(
#'   ServiceNamespace = "ecs"
#' )}
#'
#' @keywords internal
#'
#' @rdname applicationautoscaling_describe_scaling_policies
applicationautoscaling_describe_scaling_policies <- function(PolicyNames = NULL, ServiceNamespace, ResourceId = NULL, ScalableDimension = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeScalingPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationautoscaling$describe_scaling_policies_input(PolicyNames = PolicyNames, ServiceNamespace = ServiceNamespace, ResourceId = ResourceId, ScalableDimension = ScalableDimension, MaxResults = MaxResults, NextToken = NextToken)
  output <- .applicationautoscaling$describe_scaling_policies_output()
  svc <- .applicationautoscaling$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationautoscaling$operations$describe_scaling_policies <- applicationautoscaling_describe_scaling_policies

#' Describes the scheduled actions for the specified service namespace
#'
#' Describes the scheduled actions for the specified service namespace.
#' 
#' You can filter the results using the `ResourceId`, `ScalableDimension`,
#' and `ScheduledActionNames` parameters.
#' 
#' To create a scheduled action or update an existing one, see
#' PutScheduledAction. If you are no longer using a scheduled action, you
#' can delete it using DeleteScheduledAction.
#'
#' @usage
#' applicationautoscaling_describe_scheduled_actions(ScheduledActionNames,
#'   ServiceNamespace, ResourceId, ScalableDimension, MaxResults, NextToken)
#'
#' @param ScheduledActionNames The names of the scheduled actions to describe.
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service that provides the resource or
#' `custom-resource` for a resource provided by your own application or
#' service. For more information, see [AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
#' in the *Amazon Web Services General Reference*.
#' @param ResourceId The identifier of the resource associated with the scheduled action.
#' This string consists of the resource type and unique identifier. If you
#' specify a scalable dimension, you must also specify a resource ID.
#' 
#' -   ECS service - The resource type is `service` and the unique
#'     identifier is the cluster name and service name. Example:
#'     `service/default/sample-webapp`.
#' 
#' -   Spot fleet request - The resource type is `spot-fleet-request` and
#'     the unique identifier is the Spot fleet request ID. Example:
#'     `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
#' 
#' -   EMR cluster - The resource type is `instancegroup` and the unique
#'     identifier is the cluster ID and instance group ID. Example:
#'     `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
#' 
#' -   AppStream 2.0 fleet - The resource type is `fleet` and the unique
#'     identifier is the fleet name. Example: `fleet/sample-fleet`.
#' 
#' -   DynamoDB table - The resource type is `table` and the unique
#'     identifier is the resource ID. Example: `table/my-table`.
#' 
#' -   DynamoDB global secondary index - The resource type is `index` and
#'     the unique identifier is the resource ID. Example:
#'     `table/my-table/index/my-table-index`.
#' 
#' -   Aurora DB cluster - The resource type is `cluster` and the unique
#'     identifier is the cluster name. Example: `cluster:my-db-cluster`.
#' 
#' -   Amazon SageMaker endpoint variants - The resource type is `variant`
#'     and the unique identifier is the resource ID. Example:
#'     `endpoint/my-end-point/variant/KMeansClustering`.
#' 
#' -   Custom resources are not supported with a resource type. This
#'     parameter must specify the `OutputValue` from the CloudFormation
#'     template stack used to access the resources. The unique identifier
#'     is defined by the service provider. More information is available in
#'     our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' @param ScalableDimension The scalable dimension. This string consists of the service namespace,
#' resource type, and scaling property. If you specify a scalable
#' dimension, you must also specify a resource ID.
#' 
#' -   `ecs:service:DesiredCount` - The desired task count of an ECS
#'     service.
#' 
#' -   `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a
#'     Spot fleet request.
#' 
#' -   `elasticmapreduce:instancegroup:InstanceCount` - The instance count
#'     of an EMR Instance Group.
#' 
#' -   `appstream:fleet:DesiredCapacity` - The desired capacity of an
#'     AppStream 2.0 fleet.
#' 
#' -   `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an
#'     Aurora DB cluster. Available for Aurora MySQL-compatible edition and
#'     Aurora PostgreSQL-compatible edition.
#' 
#' -   `sagemaker:variant:DesiredInstanceCount` - The number of EC2
#'     instances for an Amazon SageMaker model endpoint variant.
#' 
#' -   `custom-resource:ResourceType:Property` - The scalable dimension for
#'     a custom resource provided by your own application or service.
#' @param MaxResults The maximum number of scheduled action results. This value can be
#' between 1 and 50. The default value is 50.
#' 
#' If this parameter is used, the operation returns up to `MaxResults`
#' results at a time, along with a `NextToken` value. To get the next set
#' of results, include the `NextToken` value in a subsequent call. If this
#' parameter is not used, the operation returns up to 50 results and a
#' `NextToken` value, if applicable.
#' @param NextToken The token for the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_scheduled_actions(
#'   ScheduledActionNames = list(
#'     "string"
#'   ),
#'   ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource",
#'   ResourceId = "string",
#'   ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationautoscaling_describe_scheduled_actions
applicationautoscaling_describe_scheduled_actions <- function(ScheduledActionNames = NULL, ServiceNamespace, ResourceId = NULL, ScalableDimension = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeScheduledActions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationautoscaling$describe_scheduled_actions_input(ScheduledActionNames = ScheduledActionNames, ServiceNamespace = ServiceNamespace, ResourceId = ResourceId, ScalableDimension = ScalableDimension, MaxResults = MaxResults, NextToken = NextToken)
  output <- .applicationautoscaling$describe_scheduled_actions_output()
  svc <- .applicationautoscaling$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationautoscaling$operations$describe_scheduled_actions <- applicationautoscaling_describe_scheduled_actions

#' Creates or updates a policy for an Application Auto Scaling scalable
#' target
#'
#' Creates or updates a policy for an Application Auto Scaling scalable
#' target.
#' 
#' Each scalable target is identified by a service namespace, resource ID,
#' and scalable dimension. A scaling policy applies to the scalable target
#' identified by those three attributes. You cannot create a scaling policy
#' until you have registered the resource as a scalable target using
#' RegisterScalableTarget.
#' 
#' To update a policy, specify its policy name and the parameters that you
#' want to change. Any parameters that you don\'t specify are not changed
#' by this update request.
#' 
#' You can view the scaling policies for a service namespace using
#' DescribeScalingPolicies. If you are no longer using a scaling policy,
#' you can delete it using DeleteScalingPolicy.
#' 
#' Multiple scaling policies can be in force at the same time for the same
#' scalable target. You can have one or more target tracking scaling
#' policies, one or more step scaling policies, or both. However, there is
#' a chance that multiple policies could conflict, instructing the scalable
#' target to scale out or in at the same time. Application Auto Scaling
#' gives precedence to the policy that provides the largest capacity for
#' both scale in and scale out. For example, if one policy increases
#' capacity by 3, another policy increases capacity by 200 percent, and the
#' current capacity is 10, Application Auto Scaling uses the policy with
#' the highest calculated capacity (200\% of 10 = 20) and scales out to 30.
#' 
#' Learn more about how to work with scaling policies in the [Application
#' Auto Scaling User
#' Guide](https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html).
#'
#' @usage
#' applicationautoscaling_put_scaling_policy(PolicyName, ServiceNamespace,
#'   ResourceId, ScalableDimension, PolicyType,
#'   StepScalingPolicyConfiguration,
#'   TargetTrackingScalingPolicyConfiguration)
#'
#' @param PolicyName &#91;required&#93; The name of the scaling policy.
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service that provides the resource or
#' `custom-resource` for a resource provided by your own application or
#' service. For more information, see [AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
#' in the *Amazon Web Services General Reference*.
#' @param ResourceId &#91;required&#93; The identifier of the resource associated with the scaling policy. This
#' string consists of the resource type and unique identifier.
#' 
#' -   ECS service - The resource type is `service` and the unique
#'     identifier is the cluster name and service name. Example:
#'     `service/default/sample-webapp`.
#' 
#' -   Spot fleet request - The resource type is `spot-fleet-request` and
#'     the unique identifier is the Spot fleet request ID. Example:
#'     `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
#' 
#' -   EMR cluster - The resource type is `instancegroup` and the unique
#'     identifier is the cluster ID and instance group ID. Example:
#'     `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
#' 
#' -   AppStream 2.0 fleet - The resource type is `fleet` and the unique
#'     identifier is the fleet name. Example: `fleet/sample-fleet`.
#' 
#' -   DynamoDB table - The resource type is `table` and the unique
#'     identifier is the resource ID. Example: `table/my-table`.
#' 
#' -   DynamoDB global secondary index - The resource type is `index` and
#'     the unique identifier is the resource ID. Example:
#'     `table/my-table/index/my-table-index`.
#' 
#' -   Aurora DB cluster - The resource type is `cluster` and the unique
#'     identifier is the cluster name. Example: `cluster:my-db-cluster`.
#' 
#' -   Amazon SageMaker endpoint variants - The resource type is `variant`
#'     and the unique identifier is the resource ID. Example:
#'     `endpoint/my-end-point/variant/KMeansClustering`.
#' 
#' -   Custom resources are not supported with a resource type. This
#'     parameter must specify the `OutputValue` from the CloudFormation
#'     template stack used to access the resources. The unique identifier
#'     is defined by the service provider. More information is available in
#'     our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' @param ScalableDimension &#91;required&#93; The scalable dimension. This string consists of the service namespace,
#' resource type, and scaling property.
#' 
#' -   `ecs:service:DesiredCount` - The desired task count of an ECS
#'     service.
#' 
#' -   `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a
#'     Spot fleet request.
#' 
#' -   `elasticmapreduce:instancegroup:InstanceCount` - The instance count
#'     of an EMR Instance Group.
#' 
#' -   `appstream:fleet:DesiredCapacity` - The desired capacity of an
#'     AppStream 2.0 fleet.
#' 
#' -   `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an
#'     Aurora DB cluster. Available for Aurora MySQL-compatible edition and
#'     Aurora PostgreSQL-compatible edition.
#' 
#' -   `sagemaker:variant:DesiredInstanceCount` - The number of EC2
#'     instances for an Amazon SageMaker model endpoint variant.
#' 
#' -   `custom-resource:ResourceType:Property` - The scalable dimension for
#'     a custom resource provided by your own application or service.
#' @param PolicyType The policy type. This parameter is required if you are creating a
#' scaling policy.
#' 
#' For information on which services do not support `StepScaling` or
#' `TargetTrackingScaling`, see the information about **Limits** in [Step
#' Scaling
#' Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html)
#' and [Target Tracking Scaling
#' Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html)
#' in the *Application Auto Scaling User Guide*.
#' @param StepScalingPolicyConfiguration A step scaling policy.
#' 
#' This parameter is required if you are creating a policy and the policy
#' type is `StepScaling`.
#' @param TargetTrackingScalingPolicyConfiguration A target tracking scaling policy. Includes support for predefined or
#' customized metrics.
#' 
#' This parameter is required if you are creating a policy and the policy
#' type is `TargetTrackingScaling`.
#'
#' @section Request syntax:
#' ```
#' svc$put_scaling_policy(
#'   PolicyName = "string",
#'   ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource",
#'   ResourceId = "string",
#'   ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property",
#'   PolicyType = "StepScaling"|"TargetTrackingScaling",
#'   StepScalingPolicyConfiguration = list(
#'     AdjustmentType = "ChangeInCapacity"|"PercentChangeInCapacity"|"ExactCapacity",
#'     StepAdjustments = list(
#'       list(
#'         MetricIntervalLowerBound = 123.0,
#'         MetricIntervalUpperBound = 123.0,
#'         ScalingAdjustment = 123
#'       )
#'     ),
#'     MinAdjustmentMagnitude = 123,
#'     Cooldown = 123,
#'     MetricAggregationType = "Average"|"Minimum"|"Maximum"
#'   ),
#'   TargetTrackingScalingPolicyConfiguration = list(
#'     TargetValue = 123.0,
#'     PredefinedMetricSpecification = list(
#'       PredefinedMetricType = "DynamoDBReadCapacityUtilization"|"DynamoDBWriteCapacityUtilization"|"ALBRequestCountPerTarget"|"RDSReaderAverageCPUUtilization"|"RDSReaderAverageDatabaseConnections"|"EC2SpotFleetRequestAverageCPUUtilization"|"EC2SpotFleetRequestAverageNetworkIn"|"EC2SpotFleetRequestAverageNetworkOut"|"SageMakerVariantInvocationsPerInstance"|"ECSServiceAverageCPUUtilization"|"ECSServiceAverageMemoryUtilization",
#'       ResourceLabel = "string"
#'     ),
#'     CustomizedMetricSpecification = list(
#'       MetricName = "string",
#'       Namespace = "string",
#'       Dimensions = list(
#'         list(
#'           Name = "string",
#'           Value = "string"
#'         )
#'       ),
#'       Statistic = "Average"|"Minimum"|"Maximum"|"SampleCount"|"Sum",
#'       Unit = "string"
#'     ),
#'     ScaleOutCooldown = 123,
#'     ScaleInCooldown = 123,
#'     DisableScaleIn = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @examples
#' # This example applies a scaling policy to an Amazon ECS service called
#' # web-app in the default cluster. The policy increases the desired count
#' # of the service by 200%, with a cool down period of 60 seconds.
#' \donttest{svc$put_scaling_policy(
#'   PolicyName = "web-app-cpu-gt-75",
#'   PolicyType = "StepScaling",
#'   ResourceId = "service/default/web-app",
#'   ScalableDimension = "ecs:service:DesiredCount",
#'   ServiceNamespace = "ecs",
#'   StepScalingPolicyConfiguration = list(
#'     AdjustmentType = "PercentChangeInCapacity",
#'     Cooldown = 60L,
#'     StepAdjustments = list(
#'       list(
#'         MetricIntervalLowerBound = 0L,
#'         ScalingAdjustment = 200L
#'       )
#'     )
#'   )
#' )}
#' 
#' # This example applies a scaling policy to an Amazon EC2 Spot fleet. The
#' # policy increases the target capacity of the spot fleet by 200%, with a
#' # cool down period of 180 seconds.",
#' # 
#' \donttest{svc$put_scaling_policy(
#'   PolicyName = "fleet-cpu-gt-75",
#'   PolicyType = "StepScaling",
#'   ResourceId = "spot-fleet-request/sfr-45e69d8a-be48-4539-bbf3-3464e99c50c3",
#'   ScalableDimension = "ec2:spot-fleet-request:TargetCapacity",
#'   ServiceNamespace = "ec2",
#'   StepScalingPolicyConfiguration = list(
#'     AdjustmentType = "PercentChangeInCapacity",
#'     Cooldown = 180L,
#'     StepAdjustments = list(
#'       list(
#'         MetricIntervalLowerBound = 0L,
#'         ScalingAdjustment = 200L
#'       )
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname applicationautoscaling_put_scaling_policy
applicationautoscaling_put_scaling_policy <- function(PolicyName, ServiceNamespace, ResourceId, ScalableDimension, PolicyType = NULL, StepScalingPolicyConfiguration = NULL, TargetTrackingScalingPolicyConfiguration = NULL) {
  op <- new_operation(
    name = "PutScalingPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationautoscaling$put_scaling_policy_input(PolicyName = PolicyName, ServiceNamespace = ServiceNamespace, ResourceId = ResourceId, ScalableDimension = ScalableDimension, PolicyType = PolicyType, StepScalingPolicyConfiguration = StepScalingPolicyConfiguration, TargetTrackingScalingPolicyConfiguration = TargetTrackingScalingPolicyConfiguration)
  output <- .applicationautoscaling$put_scaling_policy_output()
  svc <- .applicationautoscaling$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationautoscaling$operations$put_scaling_policy <- applicationautoscaling_put_scaling_policy

#' Creates or updates a scheduled action for an Application Auto Scaling
#' scalable target
#'
#' Creates or updates a scheduled action for an Application Auto Scaling
#' scalable target.
#' 
#' Each scalable target is identified by a service namespace, resource ID,
#' and scalable dimension. A scheduled action applies to the scalable
#' target identified by those three attributes. You cannot create a
#' scheduled action until you have registered the resource as a scalable
#' target using RegisterScalableTarget.
#' 
#' To update an action, specify its name and the parameters that you want
#' to change. If you don\'t specify start and end times, the old values are
#' deleted. Any other parameters that you don\'t specify are not changed by
#' this update request.
#' 
#' You can view the scheduled actions using DescribeScheduledActions. If
#' you are no longer using a scheduled action, you can delete it using
#' DeleteScheduledAction.
#' 
#' Learn more about how to work with scheduled actions in the [Application
#' Auto Scaling User
#' Guide](https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html).
#'
#' @usage
#' applicationautoscaling_put_scheduled_action(ServiceNamespace, Schedule,
#'   ScheduledActionName, ResourceId, ScalableDimension, StartTime, EndTime,
#'   ScalableTargetAction)
#'
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service that provides the resource or
#' `custom-resource` for a resource provided by your own application or
#' service. For more information, see [AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
#' in the *Amazon Web Services General Reference*.
#' @param Schedule The schedule for this action. The following formats are supported:
#' 
#' -   At expressions -
#'     \"`at(<i>yyyy</i>-<i>mm</i>-<i>dd</i>T<i>hh</i>:<i>mm</i>:<i>ss</i>)`\"
#' 
#' -   Rate expressions - \"`rate(<i>value</i> <i>unit</i>)`\"
#' 
#' -   Cron expressions - \"`cron(<i>fields</i>)`\"
#' 
#' At expressions are useful for one-time schedules. Specify the time, in
#' UTC.
#' 
#' For rate expressions, *value* is a positive integer and *unit* is
#' `minute` \\| `minutes` \\| `hour` \\| `hours` \\| `day` \\| `days`.
#' 
#' For more information about cron expressions, see [Cron
#' Expressions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions)
#' in the *Amazon CloudWatch Events User Guide*.
#' @param ScheduledActionName &#91;required&#93; The name of the scheduled action.
#' @param ResourceId &#91;required&#93; The identifier of the resource associated with the scheduled action.
#' This string consists of the resource type and unique identifier.
#' 
#' -   ECS service - The resource type is `service` and the unique
#'     identifier is the cluster name and service name. Example:
#'     `service/default/sample-webapp`.
#' 
#' -   Spot fleet request - The resource type is `spot-fleet-request` and
#'     the unique identifier is the Spot fleet request ID. Example:
#'     `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
#' 
#' -   EMR cluster - The resource type is `instancegroup` and the unique
#'     identifier is the cluster ID and instance group ID. Example:
#'     `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
#' 
#' -   AppStream 2.0 fleet - The resource type is `fleet` and the unique
#'     identifier is the fleet name. Example: `fleet/sample-fleet`.
#' 
#' -   DynamoDB table - The resource type is `table` and the unique
#'     identifier is the resource ID. Example: `table/my-table`.
#' 
#' -   DynamoDB global secondary index - The resource type is `index` and
#'     the unique identifier is the resource ID. Example:
#'     `table/my-table/index/my-table-index`.
#' 
#' -   Aurora DB cluster - The resource type is `cluster` and the unique
#'     identifier is the cluster name. Example: `cluster:my-db-cluster`.
#' 
#' -   Amazon SageMaker endpoint variants - The resource type is `variant`
#'     and the unique identifier is the resource ID. Example:
#'     `endpoint/my-end-point/variant/KMeansClustering`.
#' 
#' -   Custom resources are not supported with a resource type. This
#'     parameter must specify the `OutputValue` from the CloudFormation
#'     template stack used to access the resources. The unique identifier
#'     is defined by the service provider. More information is available in
#'     our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' @param ScalableDimension &#91;required&#93; The scalable dimension. This string consists of the service namespace,
#' resource type, and scaling property.
#' 
#' -   `ecs:service:DesiredCount` - The desired task count of an ECS
#'     service.
#' 
#' -   `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a
#'     Spot fleet request.
#' 
#' -   `elasticmapreduce:instancegroup:InstanceCount` - The instance count
#'     of an EMR Instance Group.
#' 
#' -   `appstream:fleet:DesiredCapacity` - The desired capacity of an
#'     AppStream 2.0 fleet.
#' 
#' -   `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an
#'     Aurora DB cluster. Available for Aurora MySQL-compatible edition and
#'     Aurora PostgreSQL-compatible edition.
#' 
#' -   `sagemaker:variant:DesiredInstanceCount` - The number of EC2
#'     instances for an Amazon SageMaker model endpoint variant.
#' 
#' -   `custom-resource:ResourceType:Property` - The scalable dimension for
#'     a custom resource provided by your own application or service.
#' @param StartTime The date and time for the scheduled action to start.
#' @param EndTime The date and time for the scheduled action to end.
#' @param ScalableTargetAction The new minimum and maximum capacity. You can set both values or just
#' one. During the scheduled time, if the current capacity is below the
#' minimum capacity, Application Auto Scaling scales out to the minimum
#' capacity. If the current capacity is above the maximum capacity,
#' Application Auto Scaling scales in to the maximum capacity.
#'
#' @section Request syntax:
#' ```
#' svc$put_scheduled_action(
#'   ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource",
#'   Schedule = "string",
#'   ScheduledActionName = "string",
#'   ResourceId = "string",
#'   ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ScalableTargetAction = list(
#'     MinCapacity = 123,
#'     MaxCapacity = 123
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationautoscaling_put_scheduled_action
applicationautoscaling_put_scheduled_action <- function(ServiceNamespace, Schedule = NULL, ScheduledActionName, ResourceId, ScalableDimension, StartTime = NULL, EndTime = NULL, ScalableTargetAction = NULL) {
  op <- new_operation(
    name = "PutScheduledAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationautoscaling$put_scheduled_action_input(ServiceNamespace = ServiceNamespace, Schedule = Schedule, ScheduledActionName = ScheduledActionName, ResourceId = ResourceId, ScalableDimension = ScalableDimension, StartTime = StartTime, EndTime = EndTime, ScalableTargetAction = ScalableTargetAction)
  output <- .applicationautoscaling$put_scheduled_action_output()
  svc <- .applicationautoscaling$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationautoscaling$operations$put_scheduled_action <- applicationautoscaling_put_scheduled_action

#' Registers or updates a scalable target
#'
#' Registers or updates a scalable target. A scalable target is a resource
#' that Application Auto Scaling can scale out and scale in. Each scalable
#' target has a resource ID, scalable dimension, and namespace, as well as
#' values for minimum and maximum capacity.
#' 
#' After you register a scalable target, you do not need to register it
#' again to use other Application Auto Scaling operations. To see which
#' resources have been registered, use DescribeScalableTargets. You can
#' also view the scaling policies for a service namespace using
#' DescribeScalableTargets.
#' 
#' If you no longer need a scalable target, you can deregister it using
#' DeregisterScalableTarget.
#'
#' @usage
#' applicationautoscaling_register_scalable_target(ServiceNamespace,
#'   ResourceId, ScalableDimension, MinCapacity, MaxCapacity, RoleARN)
#'
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service that provides the resource or
#' `custom-resource` for a resource provided by your own application or
#' service. For more information, see [AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
#' in the *Amazon Web Services General Reference*.
#' @param ResourceId &#91;required&#93; The identifier of the resource associated with the scalable target. This
#' string consists of the resource type and unique identifier.
#' 
#' -   ECS service - The resource type is `service` and the unique
#'     identifier is the cluster name and service name. Example:
#'     `service/default/sample-webapp`.
#' 
#' -   Spot fleet request - The resource type is `spot-fleet-request` and
#'     the unique identifier is the Spot fleet request ID. Example:
#'     `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
#' 
#' -   EMR cluster - The resource type is `instancegroup` and the unique
#'     identifier is the cluster ID and instance group ID. Example:
#'     `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
#' 
#' -   AppStream 2.0 fleet - The resource type is `fleet` and the unique
#'     identifier is the fleet name. Example: `fleet/sample-fleet`.
#' 
#' -   DynamoDB table - The resource type is `table` and the unique
#'     identifier is the resource ID. Example: `table/my-table`.
#' 
#' -   DynamoDB global secondary index - The resource type is `index` and
#'     the unique identifier is the resource ID. Example:
#'     `table/my-table/index/my-table-index`.
#' 
#' -   Aurora DB cluster - The resource type is `cluster` and the unique
#'     identifier is the cluster name. Example: `cluster:my-db-cluster`.
#' 
#' -   Amazon SageMaker endpoint variants - The resource type is `variant`
#'     and the unique identifier is the resource ID. Example:
#'     `endpoint/my-end-point/variant/KMeansClustering`.
#' 
#' -   Custom resources are not supported with a resource type. This
#'     parameter must specify the `OutputValue` from the CloudFormation
#'     template stack used to access the resources. The unique identifier
#'     is defined by the service provider. More information is available in
#'     our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' @param ScalableDimension &#91;required&#93; The scalable dimension associated with the scalable target. This string
#' consists of the service namespace, resource type, and scaling property.
#' 
#' -   `ecs:service:DesiredCount` - The desired task count of an ECS
#'     service.
#' 
#' -   `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a
#'     Spot fleet request.
#' 
#' -   `elasticmapreduce:instancegroup:InstanceCount` - The instance count
#'     of an EMR Instance Group.
#' 
#' -   `appstream:fleet:DesiredCapacity` - The desired capacity of an
#'     AppStream 2.0 fleet.
#' 
#' -   `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an
#'     Aurora DB cluster. Available for Aurora MySQL-compatible edition and
#'     Aurora PostgreSQL-compatible edition.
#' 
#' -   `sagemaker:variant:DesiredInstanceCount` - The number of EC2
#'     instances for an Amazon SageMaker model endpoint variant.
#' 
#' -   `custom-resource:ResourceType:Property` - The scalable dimension for
#'     a custom resource provided by your own application or service.
#' @param MinCapacity The minimum value to scale to in response to a scale-in event. This
#' parameter is required to register a scalable target.
#' @param MaxCapacity The maximum value to scale to in response to a scale-out event. This
#' parameter is required to register a scalable target.
#' @param RoleARN Application Auto Scaling creates a service-linked role that grants it
#' permissions to modify the scalable target on your behalf. For more
#' information, see [Service-Linked Roles for Application Auto
#' Scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-service-linked-roles.html).
#' 
#' For resources that are not supported using a service-linked role, this
#' parameter is required and must specify the ARN of an IAM role that
#' allows Application Auto Scaling to modify the scalable target on your
#' behalf.
#'
#' @section Request syntax:
#' ```
#' svc$register_scalable_target(
#'   ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource",
#'   ResourceId = "string",
#'   ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property",
#'   MinCapacity = 123,
#'   MaxCapacity = 123,
#'   RoleARN = "string"
#' )
#' ```
#'
#' @examples
#' # This example registers a scalable target from an Amazon ECS service
#' # called web-app that is running on the default cluster, with a minimum
#' # desired count of 1 task and a maximum desired count of 10 tasks.
#' \donttest{svc$register_scalable_target(
#'   MaxCapacity = 10L,
#'   MinCapacity = 1L,
#'   ResourceId = "service/default/web-app",
#'   RoleARN = "arn:aws:iam::012345678910:role/ApplicationAutoscalingECSRole",
#'   ScalableDimension = "ecs:service:DesiredCount",
#'   ServiceNamespace = "ecs"
#' )}
#' 
#' # This example registers a scalable target from an Amazon EC2 Spot fleet
#' # with a minimum target capacity of 1 and a maximum of 10.
#' \donttest{svc$register_scalable_target(
#'   MaxCapacity = 10L,
#'   MinCapacity = 1L,
#'   ResourceId = "spot-fleet-request/sfr-45e69d8a-be48-4539-bbf3-3464e99c50c3",
#'   RoleARN = "arn:aws:iam::012345678910:role/ApplicationAutoscalingSpotRole",
#'   ScalableDimension = "ec2:spot-fleet-request:TargetCapacity",
#'   ServiceNamespace = "ec2"
#' )}
#'
#' @keywords internal
#'
#' @rdname applicationautoscaling_register_scalable_target
applicationautoscaling_register_scalable_target <- function(ServiceNamespace, ResourceId, ScalableDimension, MinCapacity = NULL, MaxCapacity = NULL, RoleARN = NULL) {
  op <- new_operation(
    name = "RegisterScalableTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationautoscaling$register_scalable_target_input(ServiceNamespace = ServiceNamespace, ResourceId = ResourceId, ScalableDimension = ScalableDimension, MinCapacity = MinCapacity, MaxCapacity = MaxCapacity, RoleARN = RoleARN)
  output <- .applicationautoscaling$register_scalable_target_output()
  svc <- .applicationautoscaling$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationautoscaling$operations$register_scalable_target <- applicationautoscaling_register_scalable_target
