# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include applicationinsights_service.R
NULL

#' Adds an application that is created from a resource group
#'
#' Adds an application that is created from a resource group.
#'
#' @usage
#' applicationinsights_create_application(ResourceGroupName)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#'
#' @section Request syntax:
#' ```
#' svc$create_application(
#'   ResourceGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_create_application
applicationinsights_create_application <- function(ResourceGroupName) {
  op <- new_operation(
    name = "CreateApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$create_application_input(ResourceGroupName = ResourceGroupName)
  output <- .applicationinsights$create_application_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$create_application <- applicationinsights_create_application

#' Creates a custom component by grouping similar standalone instances to
#' monitor
#'
#' Creates a custom component by grouping similar standalone instances to
#' monitor.
#'
#' @usage
#' applicationinsights_create_component(ResourceGroupName, ComponentName,
#'   ResourceList)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#' @param ResourceList &#91;required&#93; The list of resource ARNs that belong to the component.
#'
#' @section Request syntax:
#' ```
#' svc$create_component(
#'   ResourceGroupName = "string",
#'   ComponentName = "string",
#'   ResourceList = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_create_component
applicationinsights_create_component <- function(ResourceGroupName, ComponentName, ResourceList) {
  op <- new_operation(
    name = "CreateComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$create_component_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName, ResourceList = ResourceList)
  output <- .applicationinsights$create_component_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$create_component <- applicationinsights_create_component

#' Removes the specified application from monitoring
#'
#' Removes the specified application from monitoring. Does not delete the
#' application.
#'
#' @usage
#' applicationinsights_delete_application(ResourceGroupName)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#'
#' @section Request syntax:
#' ```
#' svc$delete_application(
#'   ResourceGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_delete_application
applicationinsights_delete_application <- function(ResourceGroupName) {
  op <- new_operation(
    name = "DeleteApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$delete_application_input(ResourceGroupName = ResourceGroupName)
  output <- .applicationinsights$delete_application_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$delete_application <- applicationinsights_delete_application

#' Ungroups a custom component
#'
#' Ungroups a custom component. When you ungroup custom components, all
#' applicable monitors that are set up for the component are removed and
#' the instances revert to their standalone status.
#'
#' @usage
#' applicationinsights_delete_component(ResourceGroupName, ComponentName)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#'
#' @section Request syntax:
#' ```
#' svc$delete_component(
#'   ResourceGroupName = "string",
#'   ComponentName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_delete_component
applicationinsights_delete_component <- function(ResourceGroupName, ComponentName) {
  op <- new_operation(
    name = "DeleteComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$delete_component_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName)
  output <- .applicationinsights$delete_component_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$delete_component <- applicationinsights_delete_component

#' Describes the application
#'
#' Describes the application.
#'
#' @usage
#' applicationinsights_describe_application(ResourceGroupName)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#'
#' @section Request syntax:
#' ```
#' svc$describe_application(
#'   ResourceGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_application
applicationinsights_describe_application <- function(ResourceGroupName) {
  op <- new_operation(
    name = "DescribeApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_application_input(ResourceGroupName = ResourceGroupName)
  output <- .applicationinsights$describe_application_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_application <- applicationinsights_describe_application

#' Describes a component and lists the resources that are grouped together
#' in a component
#'
#' Describes a component and lists the resources that are grouped together
#' in a component.
#'
#' @usage
#' applicationinsights_describe_component(ResourceGroupName, ComponentName)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#'
#' @section Request syntax:
#' ```
#' svc$describe_component(
#'   ResourceGroupName = "string",
#'   ComponentName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_component
applicationinsights_describe_component <- function(ResourceGroupName, ComponentName) {
  op <- new_operation(
    name = "DescribeComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_component_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName)
  output <- .applicationinsights$describe_component_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_component <- applicationinsights_describe_component

#' Describes the monitoring configuration of the component
#'
#' Describes the monitoring configuration of the component.
#'
#' @usage
#' applicationinsights_describe_component_configuration(ResourceGroupName,
#'   ComponentName)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#'
#' @section Request syntax:
#' ```
#' svc$describe_component_configuration(
#'   ResourceGroupName = "string",
#'   ComponentName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_component_configuration
applicationinsights_describe_component_configuration <- function(ResourceGroupName, ComponentName) {
  op <- new_operation(
    name = "DescribeComponentConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_component_configuration_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName)
  output <- .applicationinsights$describe_component_configuration_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_component_configuration <- applicationinsights_describe_component_configuration

#' Describes the recommended monitoring configuration of the component
#'
#' Describes the recommended monitoring configuration of the component.
#'
#' @usage
#' applicationinsights_describe_component_configuration_recommendation(
#'   ResourceGroupName, ComponentName, Tier)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#' @param Tier &#91;required&#93; The tier of the application component. Supported tiers include
#' `DOT_NET_WORKER`, `DOT_NET_WEB_TIER`, `SQL_SERVER`, and `DEFAULT`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_component_configuration_recommendation(
#'   ResourceGroupName = "string",
#'   ComponentName = "string",
#'   Tier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_component_configuration_recommendation
applicationinsights_describe_component_configuration_recommendation <- function(ResourceGroupName, ComponentName, Tier) {
  op <- new_operation(
    name = "DescribeComponentConfigurationRecommendation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_component_configuration_recommendation_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName, Tier = Tier)
  output <- .applicationinsights$describe_component_configuration_recommendation_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_component_configuration_recommendation <- applicationinsights_describe_component_configuration_recommendation

#' Describes an anomaly or error with the application
#'
#' Describes an anomaly or error with the application.
#'
#' @usage
#' applicationinsights_describe_observation(ObservationId)
#'
#' @param ObservationId &#91;required&#93; The ID of the observation.
#'
#' @section Request syntax:
#' ```
#' svc$describe_observation(
#'   ObservationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_observation
applicationinsights_describe_observation <- function(ObservationId) {
  op <- new_operation(
    name = "DescribeObservation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_observation_input(ObservationId = ObservationId)
  output <- .applicationinsights$describe_observation_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_observation <- applicationinsights_describe_observation

#' Describes an application problem
#'
#' Describes an application problem.
#'
#' @usage
#' applicationinsights_describe_problem(ProblemId)
#'
#' @param ProblemId &#91;required&#93; The ID of the problem.
#'
#' @section Request syntax:
#' ```
#' svc$describe_problem(
#'   ProblemId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_problem
applicationinsights_describe_problem <- function(ProblemId) {
  op <- new_operation(
    name = "DescribeProblem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_problem_input(ProblemId = ProblemId)
  output <- .applicationinsights$describe_problem_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_problem <- applicationinsights_describe_problem

#' Describes the anomalies or errors associated with the problem
#'
#' Describes the anomalies or errors associated with the problem.
#'
#' @usage
#' applicationinsights_describe_problem_observations(ProblemId)
#'
#' @param ProblemId &#91;required&#93; The ID of the problem.
#'
#' @section Request syntax:
#' ```
#' svc$describe_problem_observations(
#'   ProblemId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_problem_observations
applicationinsights_describe_problem_observations <- function(ProblemId) {
  op <- new_operation(
    name = "DescribeProblemObservations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_problem_observations_input(ProblemId = ProblemId)
  output <- .applicationinsights$describe_problem_observations_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_problem_observations <- applicationinsights_describe_problem_observations

#' Lists the IDs of the applications that you are monitoring
#'
#' Lists the IDs of the applications that you are monitoring.
#'
#' @usage
#' applicationinsights_list_applications(MaxResults, NextToken)
#'
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token to request the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_applications(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_list_applications
applicationinsights_list_applications <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListApplications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$list_applications_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .applicationinsights$list_applications_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$list_applications <- applicationinsights_list_applications

#' Lists the auto-grouped, standalone, and custom components of the
#' application
#'
#' Lists the auto-grouped, standalone, and custom components of the
#' application.
#'
#' @usage
#' applicationinsights_list_components(ResourceGroupName, MaxResults,
#'   NextToken)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token to request the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_components(
#'   ResourceGroupName = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_list_components
applicationinsights_list_components <- function(ResourceGroupName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListComponents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$list_components_input(ResourceGroupName = ResourceGroupName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .applicationinsights$list_components_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$list_components <- applicationinsights_list_components

#' Lists the problems with your application
#'
#' Lists the problems with your application.
#'
#' @usage
#' applicationinsights_list_problems(ResourceGroupName, StartTime, EndTime,
#'   MaxResults, NextToken)
#'
#' @param ResourceGroupName The name of the resource group.
#' @param StartTime The time when the problem was detected, in epoch seconds. If you don\'t
#' specify a time frame for the request, problems within the past seven
#' days are returned.
#' @param EndTime The time when the problem ended, in epoch seconds. If not specified,
#' problems within the past seven days are returned.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token to request the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_problems(
#'   ResourceGroupName = "string",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_list_problems
applicationinsights_list_problems <- function(ResourceGroupName = NULL, StartTime = NULL, EndTime = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListProblems",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$list_problems_input(ResourceGroupName = ResourceGroupName, StartTime = StartTime, EndTime = EndTime, MaxResults = MaxResults, NextToken = NextToken)
  output <- .applicationinsights$list_problems_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$list_problems <- applicationinsights_list_problems

#' Updates the custom component name and/or the list of resources that make
#' up the component
#'
#' Updates the custom component name and/or the list of resources that make
#' up the component.
#'
#' @usage
#' applicationinsights_update_component(ResourceGroupName, ComponentName,
#'   NewComponentName, ResourceList)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#' @param NewComponentName The new name of the component.
#' @param ResourceList The list of resource ARNs that belong to the component.
#'
#' @section Request syntax:
#' ```
#' svc$update_component(
#'   ResourceGroupName = "string",
#'   ComponentName = "string",
#'   NewComponentName = "string",
#'   ResourceList = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_update_component
applicationinsights_update_component <- function(ResourceGroupName, ComponentName, NewComponentName = NULL, ResourceList = NULL) {
  op <- new_operation(
    name = "UpdateComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$update_component_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName, NewComponentName = NewComponentName, ResourceList = ResourceList)
  output <- .applicationinsights$update_component_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$update_component <- applicationinsights_update_component

#' Updates the monitoring configurations for the component
#'
#' Updates the monitoring configurations for the component. The
#' configuration input parameter is an escaped JSON of the configuration
#' and should match the schema of what is returned by
#' `DescribeComponentConfigurationRecommendation`.
#'
#' @usage
#' applicationinsights_update_component_configuration(ResourceGroupName,
#'   ComponentName, Monitor, Tier, ComponentConfiguration)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#' @param Monitor Indicates whether the application component is monitored.
#' @param Tier The tier of the application component. Supported tiers include
#' `DOT_NET_WORKER`, `DOT_NET_WEB_TIER`, `SQL_SERVER`, and `DEFAULT`.
#' @param ComponentConfiguration The configuration settings of the component. The value is the escaped
#' JSON of the configuration. For more information about the JSON format,
#' see [Working with
#' JSON](https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html).
#' You can send a request to `DescribeComponentConfigurationRecommendation`
#' to see the recommended configuration for a component.
#'
#' @section Request syntax:
#' ```
#' svc$update_component_configuration(
#'   ResourceGroupName = "string",
#'   ComponentName = "string",
#'   Monitor = TRUE|FALSE,
#'   Tier = "string",
#'   ComponentConfiguration = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_update_component_configuration
applicationinsights_update_component_configuration <- function(ResourceGroupName, ComponentName, Monitor = NULL, Tier = NULL, ComponentConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateComponentConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$update_component_configuration_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName, Monitor = Monitor, Tier = Tier, ComponentConfiguration = ComponentConfiguration)
  output <- .applicationinsights$update_component_configuration_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$update_component_configuration <- applicationinsights_update_component_configuration
