% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_list_stack_set_operation_results}
\alias{cloudformation_list_stack_set_operation_results}
\title{Returns summary information about the results of a stack set operation}
\usage{
cloudformation_list_stack_set_operation_results(StackSetName,
  OperationId, NextToken, MaxResults)
}
\arguments{
\item{StackSetName}{[required] The name or unique ID of the stack set that you want to get operation
results for.}

\item{OperationId}{[required] The ID of the stack set operation.}

\item{NextToken}{If the previous request didn't return all of the remaining results, the
response object's \code{NextToken} parameter value is set to a token. To
retrieve the next set of results, call \code{ListStackSetOperationResults}
again and assign that token to the request object's \code{NextToken}
parameter. If there are no remaining results, the previous response
object's \code{NextToken} parameter is set to \code{null}.}

\item{MaxResults}{The maximum number of results to be returned with a single call. If the
number of available results exceeds this maximum, the response includes
a \code{NextToken} value that you can assign to the \code{NextToken} request
parameter to get the next set of results.}
}
\description{
Returns summary information about the results of a stack set operation.
}
\section{Request syntax}{
\preformatted{svc$list_stack_set_operation_results(
  StackSetName = "string",
  OperationId = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
