% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_resume_processes}
\alias{autoscaling_resume_processes}
\title{Resumes the specified suspended automatic scaling processes, or all
suspended process, for the specified Auto Scaling group}
\usage{
autoscaling_resume_processes(AutoScalingGroupName, ScalingProcesses)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{ScalingProcesses}{One or more of the following processes. If you omit this parameter, all
processes are specified.
\itemize{
\item \code{Launch}
\item \code{Terminate}
\item \code{HealthCheck}
\item \code{ReplaceUnhealthy}
\item \code{AZRebalance}
\item \code{AlarmNotification}
\item \code{ScheduledActions}
\item \code{AddToLoadBalancer}
}}
}
\description{
Resumes the specified suspended automatic scaling processes, or all
suspended process, for the specified Auto Scaling group.
}
\details{
For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html}{Suspending and Resuming Scaling Processes}
in the \emph{Amazon EC2 Auto Scaling User Guide}.
}
\section{Request syntax}{
\preformatted{svc$resume_processes(
  AutoScalingGroupName = "string",
  ScalingProcesses = list(
    "string"
  )
)
}
}

\examples{
# This example resumes the specified suspended scaling process for the
# specified Auto Scaling group.
\dontrun{svc$resume_processes(
  AutoScalingGroupName = "my-auto-scaling-group",
  ScalingProcesses = list(
    "AlarmNotification"
  )
)}

}
\keyword{internal}
