% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_get_organization_config_rule_detailed_status}
\alias{configservice_get_organization_config_rule_detailed_status}
\title{Returns detailed status for each member account within an organization
for a given organization config rule}
\usage{
configservice_get_organization_config_rule_detailed_status(
  OrganizationConfigRuleName, Filters, Limit, NextToken)
}
\arguments{
\item{OrganizationConfigRuleName}{[required] The name of organization config rule for which you want status details
for member accounts.}

\item{Filters}{A \code{StatusDetailFilters} object.}

\item{Limit}{The maximum number of \code{OrganizationConfigRuleDetailedStatus} returned on
each page. If you do not specify a number, AWS Config uses the default.
The default is 100.}

\item{NextToken}{The \code{nextToken} string returned on a previous page that you use to get
the next page of results in a paginated response.}
}
\description{
Returns detailed status for each member account within an organization
for a given organization config rule.
}
\details{
Only a master account can call this API.
}
\section{Request syntax}{
\preformatted{svc$get_organization_config_rule_detailed_status(
  OrganizationConfigRuleName = "string",
  Filters = list(
    AccountId = "string",
    MemberAccountRuleStatus = "CREATE_SUCCESSFUL"|"CREATE_IN_PROGRESS"|"CREATE_FAILED"|"DELETE_SUCCESSFUL"|"DELETE_FAILED"|"DELETE_IN_PROGRESS"|"UPDATE_SUCCESSFUL"|"UPDATE_IN_PROGRESS"|"UPDATE_FAILED"
  ),
  Limit = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
