% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_create_app}
\alias{opsworks_create_app}
\title{Creates an app for a specified stack}
\usage{
opsworks_create_app(StackId, Shortname, Name, Description, DataSources,
  Type, AppSource, Domains, EnableSsl, SslConfiguration, Attributes,
  Environment)
}
\arguments{
\item{StackId}{[required] The stack ID.}

\item{Shortname}{The app\'s short name.}

\item{Name}{[required] The app name.}

\item{Description}{A description of the app.}

\item{DataSources}{The app\'s data source.}

\item{Type}{[required] The app type. Each supported type is associated with a particular layer.
For example, PHP applications are associated with a PHP layer. AWS
OpsWorks Stacks deploys an application to those instances that are
members of the corresponding layer. If your app isn\'t one of the
standard types, or you prefer to implement your own Deploy recipes,
specify \code{other}.}

\item{AppSource}{A \code{Source} object that specifies the app repository.}

\item{Domains}{The app virtual host settings, with multiple domains separated by
commas. For example: \code{'www.example.com, example.com'}}

\item{EnableSsl}{Whether to enable SSL for the app.}

\item{SslConfiguration}{An \code{SslConfiguration} object with the SSL configuration.}

\item{Attributes}{One or more user-defined key/value pairs to be added to the stack
attributes.}

\item{Environment}{An array of \code{EnvironmentVariable} objects that specify environment
variables to be associated with the app. After you deploy the app, these
variables are defined on the associated app server instance. For more
information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment}{Environment Variables}.

There is no specific limit on the number of environment variables.
However, the size of the associated data structure - which includes the
variables\' names, values, and protected flag values - cannot exceed 20
KB. This limit should accommodate most if not all use cases. Exceeding
it will cause an exception with the message, \"Environment: is too large
(maximum is 20KB).\"

If you have specified one or more environment variables, you cannot
modify the stack\'s Chef version.}
}
\description{
Creates an app for a specified stack. For more information, see
\href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html}{Creating Apps}.
}
\details{
\strong{Required Permissions}: To use this action, an IAM user must have a
Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information on user permissions,
see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$create_app(
  StackId = "string",
  Shortname = "string",
  Name = "string",
  Description = "string",
  DataSources = list(
    list(
      Type = "string",
      Arn = "string",
      DatabaseName = "string"
    )
  ),
  Type = "aws-flow-ruby"|"java"|"rails"|"php"|"nodejs"|"static"|"other",
  AppSource = list(
    Type = "git"|"svn"|"archive"|"s3",
    Url = "string",
    Username = "string",
    Password = "string",
    SshKey = "string",
    Revision = "string"
  ),
  Domains = list(
    "string"
  ),
  EnableSsl = TRUE|FALSE,
  SslConfiguration = list(
    Certificate = "string",
    PrivateKey = "string",
    Chain = "string"
  ),
  Attributes = list(
    "string"
  ),
  Environment = list(
    list(
      Key = "string",
      Value = "string",
      Secure = TRUE|FALSE
    )
  )
)
}
}

\keyword{internal}
