% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_describe_notification_configurations}
\alias{autoscaling_describe_notification_configurations}
\title{Describes the notification actions associated with the specified Auto
Scaling group}
\usage{
autoscaling_describe_notification_configurations(AutoScalingGroupNames,
  NextToken, MaxRecords)
}
\arguments{
\item{AutoScalingGroupNames}{The name of the Auto Scaling group.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}

\item{MaxRecords}{The maximum number of items to return with this call. The default value
is \code{50} and the maximum value is \code{100}.}
}
\description{
Describes the notification actions associated with the specified Auto
Scaling group.
}
\section{Request syntax}{
\preformatted{svc$describe_notification_configurations(
  AutoScalingGroupNames = list(
    "string"
  ),
  NextToken = "string",
  MaxRecords = 123
)
}
}

\examples{
\dontrun{
# This example describes the notification configurations for the specified
# Auto Scaling group.
svc$describe_notification_configurations(
  AutoScalingGroupNames = list(
    "my-auto-scaling-group"
  )
)
}

}
\keyword{internal}
