# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include managedgrafana_service.R
NULL

#' Assigns a Grafana Enterprise license to a workspace
#'
#' @description
#' Assigns a Grafana Enterprise license to a workspace. Upgrading to Grafana Enterprise incurs additional fees. For more information, see [Upgrade a workspace to Grafana Enterprise](https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html).
#'
#' See [https://paws-r.github.io/docs/managedgrafana/associate_license.html](https://paws-r.github.io/docs/managedgrafana/associate_license.html) for full documentation.
#'
#' @param licenseType &#91;required&#93; The type of license to associate with the workspace.
#' @param workspaceId &#91;required&#93; The ID of the workspace to associate the license with.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_associate_license
managedgrafana_associate_license <- function(licenseType, workspaceId) {
  op <- new_operation(
    name = "AssociateLicense",
    http_method = "POST",
    http_path = "/workspaces/{workspaceId}/licenses/{licenseType}",
    paginator = list()
  )
  input <- .managedgrafana$associate_license_input(licenseType = licenseType, workspaceId = workspaceId)
  output <- .managedgrafana$associate_license_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$associate_license <- managedgrafana_associate_license

#' Creates a workspace
#'
#' @description
#' Creates a *workspace*. In a workspace, you can create Grafana dashboards and visualizations to analyze your metrics, logs, and traces. You don't have to build, package, or deploy any hardware to run the Grafana server.
#'
#' See [https://paws-r.github.io/docs/managedgrafana/create_workspace.html](https://paws-r.github.io/docs/managedgrafana/create_workspace.html) for full documentation.
#'
#' @param accountAccessType &#91;required&#93; Specifies whether the workspace can access Amazon Web Services resources
#' in this Amazon Web Services account only, or whether it can also access
#' Amazon Web Services resources in other accounts in the same
#' organization. If you specify `ORGANIZATION`, you must specify which
#' organizational units the workspace can access in the
#' `workspaceOrganizationalUnits` parameter.
#' @param authenticationProviders &#91;required&#93; Specifies whether this workspace uses SAML 2.0, Amazon Web Services
#' Single Sign On, or both to authenticate users for using the Grafana
#' console within a workspace. For more information, see [User
#' authentication in Amazon Managed
#' Grafana](https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html).
#' @param clientToken A unique, case-sensitive, user-provided identifier to ensure the
#' idempotency of the request.
#' @param organizationRoleName The name of an IAM role that already exists to use with Organizations to
#' access Amazon Web Services data sources and notification channels in
#' other accounts in an organization.
#' @param permissionType &#91;required&#93; If you specify `SERVICE_MANAGED` on AWS Grafana console, Amazon Managed
#' Grafana automatically creates the IAM roles and provisions the
#' permissions that the workspace needs to use Amazon Web Services data
#' sources and notification channels. In CLI mode, the permissionType
#' `SERVICE_MANAGED` will not create the IAM role for you.
#' 
#' If you specify `CUSTOMER_MANAGED`, you will manage those roles and
#' permissions yourself. If you are creating this workspace in a member
#' account of an organization that is not a delegated administrator
#' account, and you want the workspace to access data sources in other
#' Amazon Web Services accounts in the organization, you must choose
#' `CUSTOMER_MANAGED`.
#' 
#' For more information, see [Amazon Managed Grafana permissions and
#' policies for Amazon Web Services data sources and notification
#' channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html).
#' @param stackSetName The name of the CloudFormation stack set to use to generate IAM roles to
#' be used for this workspace.
#' @param tags The list of tags associated with the workspace.
#' @param workspaceDataSources Specify the Amazon Web Services data sources that you want to be queried
#' in this workspace. Specifying these data sources here enables Amazon
#' Managed Grafana to create IAM roles and permissions that allow Amazon
#' Managed Grafana to read data from these sources. You must still add them
#' as data sources in the Grafana console in the workspace.
#' 
#' If you don't specify a data source here, you can still add it as a data
#' source in the workspace console later. However, you will then have to
#' manually configure permissions for it.
#' @param workspaceDescription A description for the workspace. This is used only to help you identify
#' this workspace.
#' 
#' Pattern: `^[\\p{L}\\p{Z}\\p{N}\\p{P}]{0,2048}$`
#' @param workspaceName The name for the workspace. It does not have to be unique.
#' @param workspaceNotificationDestinations Specify the Amazon Web Services notification channels that you plan to
#' use in this workspace. Specifying these data sources here enables Amazon
#' Managed Grafana to create IAM roles and permissions that allow Amazon
#' Managed Grafana to use these channels.
#' @param workspaceOrganizationalUnits Specifies the organizational units that this workspace is allowed to use
#' data sources from, if this workspace is in an account that is part of an
#' organization.
#' @param workspaceRoleArn The workspace needs an IAM role that grants permissions to the Amazon
#' Web Services resources that the workspace will view data from. If you
#' already have a role that you want to use, specify it here. The
#' permission type should be set to `CUSTOMER_MANAGED`.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_create_workspace
managedgrafana_create_workspace <- function(accountAccessType, authenticationProviders, clientToken = NULL, organizationRoleName = NULL, permissionType, stackSetName = NULL, tags = NULL, workspaceDataSources = NULL, workspaceDescription = NULL, workspaceName = NULL, workspaceNotificationDestinations = NULL, workspaceOrganizationalUnits = NULL, workspaceRoleArn = NULL) {
  op <- new_operation(
    name = "CreateWorkspace",
    http_method = "POST",
    http_path = "/workspaces",
    paginator = list()
  )
  input <- .managedgrafana$create_workspace_input(accountAccessType = accountAccessType, authenticationProviders = authenticationProviders, clientToken = clientToken, organizationRoleName = organizationRoleName, permissionType = permissionType, stackSetName = stackSetName, tags = tags, workspaceDataSources = workspaceDataSources, workspaceDescription = workspaceDescription, workspaceName = workspaceName, workspaceNotificationDestinations = workspaceNotificationDestinations, workspaceOrganizationalUnits = workspaceOrganizationalUnits, workspaceRoleArn = workspaceRoleArn)
  output <- .managedgrafana$create_workspace_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$create_workspace <- managedgrafana_create_workspace

#' Creates an API key for the workspace
#'
#' @description
#' Creates an API key for the workspace. This key can be used to authenticate requests sent to the workspace's HTTP API. See https://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html for available APIs and example requests.
#'
#' See [https://paws-r.github.io/docs/managedgrafana/create_workspace_api_key.html](https://paws-r.github.io/docs/managedgrafana/create_workspace_api_key.html) for full documentation.
#'
#' @param keyName &#91;required&#93; Specifies the name of the key to create. Key names must be unique to the
#' workspace.
#' @param keyRole &#91;required&#93; Specifies the permission level of the key.
#' 
#' Valid Values: `VIEWER` | `EDITOR` | `ADMIN`
#' @param secondsToLive &#91;required&#93; Specifies the time in seconds until the key expires. Keys can be valid
#' for up to 30 days.
#' @param workspaceId &#91;required&#93; The ID of the workspace in which to create an API key.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_create_workspace_api_key
managedgrafana_create_workspace_api_key <- function(keyName, keyRole, secondsToLive, workspaceId) {
  op <- new_operation(
    name = "CreateWorkspaceApiKey",
    http_method = "POST",
    http_path = "/workspaces/{workspaceId}/apikeys",
    paginator = list()
  )
  input <- .managedgrafana$create_workspace_api_key_input(keyName = keyName, keyRole = keyRole, secondsToLive = secondsToLive, workspaceId = workspaceId)
  output <- .managedgrafana$create_workspace_api_key_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$create_workspace_api_key <- managedgrafana_create_workspace_api_key

#' Deletes an Amazon Managed Grafana workspace
#'
#' @description
#' Deletes an Amazon Managed Grafana workspace.
#'
#' See [https://paws-r.github.io/docs/managedgrafana/delete_workspace.html](https://paws-r.github.io/docs/managedgrafana/delete_workspace.html) for full documentation.
#'
#' @param workspaceId &#91;required&#93; The ID of the workspace to delete.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_delete_workspace
managedgrafana_delete_workspace <- function(workspaceId) {
  op <- new_operation(
    name = "DeleteWorkspace",
    http_method = "DELETE",
    http_path = "/workspaces/{workspaceId}",
    paginator = list()
  )
  input <- .managedgrafana$delete_workspace_input(workspaceId = workspaceId)
  output <- .managedgrafana$delete_workspace_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$delete_workspace <- managedgrafana_delete_workspace

#' Deletes an API key for a workspace
#'
#' @description
#' Deletes an API key for a workspace.
#'
#' See [https://paws-r.github.io/docs/managedgrafana/delete_workspace_api_key.html](https://paws-r.github.io/docs/managedgrafana/delete_workspace_api_key.html) for full documentation.
#'
#' @param keyName &#91;required&#93; The name of the API key to delete.
#' @param workspaceId &#91;required&#93; The ID of the workspace to delete.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_delete_workspace_api_key
managedgrafana_delete_workspace_api_key <- function(keyName, workspaceId) {
  op <- new_operation(
    name = "DeleteWorkspaceApiKey",
    http_method = "DELETE",
    http_path = "/workspaces/{workspaceId}/apikeys/{keyName}",
    paginator = list()
  )
  input <- .managedgrafana$delete_workspace_api_key_input(keyName = keyName, workspaceId = workspaceId)
  output <- .managedgrafana$delete_workspace_api_key_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$delete_workspace_api_key <- managedgrafana_delete_workspace_api_key

#' Displays information about one Amazon Managed Grafana workspace
#'
#' @description
#' Displays information about one Amazon Managed Grafana workspace.
#'
#' See [https://paws-r.github.io/docs/managedgrafana/describe_workspace.html](https://paws-r.github.io/docs/managedgrafana/describe_workspace.html) for full documentation.
#'
#' @param workspaceId &#91;required&#93; The ID of the workspace to display information about.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_describe_workspace
managedgrafana_describe_workspace <- function(workspaceId) {
  op <- new_operation(
    name = "DescribeWorkspace",
    http_method = "GET",
    http_path = "/workspaces/{workspaceId}",
    paginator = list()
  )
  input <- .managedgrafana$describe_workspace_input(workspaceId = workspaceId)
  output <- .managedgrafana$describe_workspace_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$describe_workspace <- managedgrafana_describe_workspace

#' Displays information about the authentication methods used in one Amazon
#' Managed Grafana workspace
#'
#' @description
#' Displays information about the authentication methods used in one Amazon Managed Grafana workspace.
#'
#' See [https://paws-r.github.io/docs/managedgrafana/describe_workspace_authentication.html](https://paws-r.github.io/docs/managedgrafana/describe_workspace_authentication.html) for full documentation.
#'
#' @param workspaceId &#91;required&#93; The ID of the workspace to return authentication information about.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_describe_workspace_authentication
managedgrafana_describe_workspace_authentication <- function(workspaceId) {
  op <- new_operation(
    name = "DescribeWorkspaceAuthentication",
    http_method = "GET",
    http_path = "/workspaces/{workspaceId}/authentication",
    paginator = list()
  )
  input <- .managedgrafana$describe_workspace_authentication_input(workspaceId = workspaceId)
  output <- .managedgrafana$describe_workspace_authentication_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$describe_workspace_authentication <- managedgrafana_describe_workspace_authentication

#' Removes the Grafana Enterprise license from a workspace
#'
#' @description
#' Removes the Grafana Enterprise license from a workspace.
#'
#' See [https://paws-r.github.io/docs/managedgrafana/disassociate_license.html](https://paws-r.github.io/docs/managedgrafana/disassociate_license.html) for full documentation.
#'
#' @param licenseType &#91;required&#93; The type of license to remove from the workspace.
#' @param workspaceId &#91;required&#93; The ID of the workspace to remove the Grafana Enterprise license from.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_disassociate_license
managedgrafana_disassociate_license <- function(licenseType, workspaceId) {
  op <- new_operation(
    name = "DisassociateLicense",
    http_method = "DELETE",
    http_path = "/workspaces/{workspaceId}/licenses/{licenseType}",
    paginator = list()
  )
  input <- .managedgrafana$disassociate_license_input(licenseType = licenseType, workspaceId = workspaceId)
  output <- .managedgrafana$disassociate_license_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$disassociate_license <- managedgrafana_disassociate_license

#' Lists the users and groups who have the Grafana Admin and Editor roles
#' in this workspace
#'
#' @description
#' Lists the users and groups who have the Grafana `Admin` and `Editor` roles in this workspace. If you use this operation without specifying `userId` or `groupId`, the operation returns the roles of all users and groups. If you specify a `userId` or a `groupId`, only the roles for that user or group are returned. If you do this, you can specify only one `userId` or one `groupId`.
#'
#' See [https://paws-r.github.io/docs/managedgrafana/list_permissions.html](https://paws-r.github.io/docs/managedgrafana/list_permissions.html) for full documentation.
#'
#' @param groupId (Optional) Limits the results to only the group that matches this ID.
#' @param maxResults The maximum number of results to include in the response.
#' @param nextToken The token to use when requesting the next set of results. You received
#' this token from a previous
#' [`list_permissions`][managedgrafana_list_permissions] operation.
#' @param userId (Optional) Limits the results to only the user that matches this ID.
#' @param userType (Optional) If you specify `SSO_USER`, then only the permissions of
#' Amazon Web Services SSO users are returned. If you specify `SSO_GROUP`,
#' only the permissions of Amazon Web Services SSO groups are returned.
#' @param workspaceId &#91;required&#93; The ID of the workspace to list permissions for. This parameter is
#' required.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_list_permissions
managedgrafana_list_permissions <- function(groupId = NULL, maxResults = NULL, nextToken = NULL, userId = NULL, userType = NULL, workspaceId) {
  op <- new_operation(
    name = "ListPermissions",
    http_method = "GET",
    http_path = "/workspaces/{workspaceId}/permissions",
    paginator = list()
  )
  input <- .managedgrafana$list_permissions_input(groupId = groupId, maxResults = maxResults, nextToken = nextToken, userId = userId, userType = userType, workspaceId = workspaceId)
  output <- .managedgrafana$list_permissions_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$list_permissions <- managedgrafana_list_permissions

#' The ListTagsForResource operation returns the tags that are associated
#' with the Amazon Managed Service for Grafana resource specified by the
#' resourceArn
#'
#' @description
#' The [`list_tags_for_resource`][managedgrafana_list_tags_for_resource] operation returns the tags that are associated with the Amazon Managed Service for Grafana resource specified by the `resourceArn`. Currently, the only resource that can be tagged is a workspace.
#'
#' See [https://paws-r.github.io/docs/managedgrafana/list_tags_for_resource.html](https://paws-r.github.io/docs/managedgrafana/list_tags_for_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource the list of tags are associated with.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_list_tags_for_resource
managedgrafana_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .managedgrafana$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .managedgrafana$list_tags_for_resource_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$list_tags_for_resource <- managedgrafana_list_tags_for_resource

#' Returns a list of Amazon Managed Grafana workspaces in the account, with
#' some information about each workspace
#'
#' @description
#' Returns a list of Amazon Managed Grafana workspaces in the account, with some information about each workspace. For more complete information about one workspace, use [`describe_workspace`][managedgrafana_describe_workspace].
#'
#' See [https://paws-r.github.io/docs/managedgrafana/list_workspaces.html](https://paws-r.github.io/docs/managedgrafana/list_workspaces.html) for full documentation.
#'
#' @param maxResults The maximum number of workspaces to include in the results.
#' @param nextToken The token for the next set of workspaces to return. (You receive this
#' token from a previous
#' [`list_workspaces`][managedgrafana_list_workspaces] operation.)
#'
#' @keywords internal
#'
#' @rdname managedgrafana_list_workspaces
managedgrafana_list_workspaces <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListWorkspaces",
    http_method = "GET",
    http_path = "/workspaces",
    paginator = list()
  )
  input <- .managedgrafana$list_workspaces_input(maxResults = maxResults, nextToken = nextToken)
  output <- .managedgrafana$list_workspaces_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$list_workspaces <- managedgrafana_list_workspaces

#' The TagResource operation associates tags with an Amazon Managed Grafana
#' resource
#'
#' @description
#' The [`tag_resource`][managedgrafana_tag_resource] operation associates tags with an Amazon Managed Grafana resource. Currently, the only resource that can be tagged is workspaces.
#'
#' See [https://paws-r.github.io/docs/managedgrafana/tag_resource.html](https://paws-r.github.io/docs/managedgrafana/tag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource the tag is associated with.
#' @param tags &#91;required&#93; The list of tag keys and values to associate with the resource. You can
#' associate tag keys only, tags (key and values) only or a combination of
#' tag keys and tags.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_tag_resource
managedgrafana_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .managedgrafana$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .managedgrafana$tag_resource_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$tag_resource <- managedgrafana_tag_resource

#' The UntagResource operation removes the association of the tag with the
#' Amazon Managed Grafana resource
#'
#' @description
#' The [`untag_resource`][managedgrafana_untag_resource] operation removes the association of the tag with the Amazon Managed Grafana resource.
#'
#' See [https://paws-r.github.io/docs/managedgrafana/untag_resource.html](https://paws-r.github.io/docs/managedgrafana/untag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource the tag association is removed from.
#' @param tagKeys &#91;required&#93; The key values of the tag to be removed from the resource.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_untag_resource
managedgrafana_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .managedgrafana$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .managedgrafana$untag_resource_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$untag_resource <- managedgrafana_untag_resource

#' Updates which users in a workspace have the Grafana Admin or Editor
#' roles
#'
#' @description
#' Updates which users in a workspace have the Grafana `Admin` or `Editor` roles.
#'
#' See [https://paws-r.github.io/docs/managedgrafana/update_permissions.html](https://paws-r.github.io/docs/managedgrafana/update_permissions.html) for full documentation.
#'
#' @param updateInstructionBatch &#91;required&#93; An array of structures that contain the permission updates to make.
#' @param workspaceId &#91;required&#93; The ID of the workspace to update.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_update_permissions
managedgrafana_update_permissions <- function(updateInstructionBatch, workspaceId) {
  op <- new_operation(
    name = "UpdatePermissions",
    http_method = "PATCH",
    http_path = "/workspaces/{workspaceId}/permissions",
    paginator = list()
  )
  input <- .managedgrafana$update_permissions_input(updateInstructionBatch = updateInstructionBatch, workspaceId = workspaceId)
  output <- .managedgrafana$update_permissions_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$update_permissions <- managedgrafana_update_permissions

#' Modifies an existing Amazon Managed Grafana workspace
#'
#' @description
#' Modifies an existing Amazon Managed Grafana workspace. If you use this operation and omit any optional parameters, the existing values of those parameters are not changed.
#'
#' See [https://paws-r.github.io/docs/managedgrafana/update_workspace.html](https://paws-r.github.io/docs/managedgrafana/update_workspace.html) for full documentation.
#'
#' @param accountAccessType Specifies whether the workspace can access Amazon Web Services resources
#' in this Amazon Web Services account only, or whether it can also access
#' Amazon Web Services resources in other accounts in the same
#' organization. If you specify `ORGANIZATION`, you must specify which
#' organizational units the workspace can access in the
#' `workspaceOrganizationalUnits` parameter.
#' @param organizationRoleName The name of an IAM role that already exists to use to access resources
#' through Organizations.
#' @param permissionType If you specify `Service Managed`, Amazon Managed Grafana automatically
#' creates the IAM roles and provisions the permissions that the workspace
#' needs to use Amazon Web Services data sources and notification channels.
#' 
#' If you specify `CUSTOMER_MANAGED`, you will manage those roles and
#' permissions yourself. If you are creating this workspace in a member
#' account of an organization and that account is not a delegated
#' administrator account, and you want the workspace to access data sources
#' in other Amazon Web Services accounts in the organization, you must
#' choose `CUSTOMER_MANAGED`.
#' 
#' For more information, see [Amazon Managed Grafana permissions and
#' policies for Amazon Web Services data sources and notification
#' channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html)
#' @param stackSetName The name of the CloudFormation stack set to use to generate IAM roles to
#' be used for this workspace.
#' @param workspaceDataSources Specify the Amazon Web Services data sources that you want to be queried
#' in this workspace. Specifying these data sources here enables Amazon
#' Managed Grafana to create IAM roles and permissions that allow Amazon
#' Managed Grafana to read data from these sources. You must still add them
#' as data sources in the Grafana console in the workspace.
#' 
#' If you don't specify a data source here, you can still add it as a data
#' source later in the workspace console. However, you will then have to
#' manually configure permissions for it.
#' @param workspaceDescription A description for the workspace. This is used only to help you identify
#' this workspace.
#' @param workspaceId &#91;required&#93; The ID of the workspace to update.
#' @param workspaceName A new name for the workspace to update.
#' @param workspaceNotificationDestinations Specify the Amazon Web Services notification channels that you plan to
#' use in this workspace. Specifying these data sources here enables Amazon
#' Managed Grafana to create IAM roles and permissions that allow Amazon
#' Managed Grafana to use these channels.
#' @param workspaceOrganizationalUnits Specifies the organizational units that this workspace is allowed to use
#' data sources from, if this workspace is in an account that is part of an
#' organization.
#' @param workspaceRoleArn The workspace needs an IAM role that grants permissions to the Amazon
#' Web Services resources that the workspace will view data from. If you
#' already have a role that you want to use, specify it here. If you omit
#' this field and you specify some Amazon Web Services resources in
#' `workspaceDataSources` or `workspaceNotificationDestinations`, a new IAM
#' role with the necessary permissions is automatically created.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_update_workspace
managedgrafana_update_workspace <- function(accountAccessType = NULL, organizationRoleName = NULL, permissionType = NULL, stackSetName = NULL, workspaceDataSources = NULL, workspaceDescription = NULL, workspaceId, workspaceName = NULL, workspaceNotificationDestinations = NULL, workspaceOrganizationalUnits = NULL, workspaceRoleArn = NULL) {
  op <- new_operation(
    name = "UpdateWorkspace",
    http_method = "PUT",
    http_path = "/workspaces/{workspaceId}",
    paginator = list()
  )
  input <- .managedgrafana$update_workspace_input(accountAccessType = accountAccessType, organizationRoleName = organizationRoleName, permissionType = permissionType, stackSetName = stackSetName, workspaceDataSources = workspaceDataSources, workspaceDescription = workspaceDescription, workspaceId = workspaceId, workspaceName = workspaceName, workspaceNotificationDestinations = workspaceNotificationDestinations, workspaceOrganizationalUnits = workspaceOrganizationalUnits, workspaceRoleArn = workspaceRoleArn)
  output <- .managedgrafana$update_workspace_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$update_workspace <- managedgrafana_update_workspace

#' Use this operation to define the identity provider (IdP) that this
#' workspace authenticates users from, using SAML
#'
#' @description
#' Use this operation to define the identity provider (IdP) that this workspace authenticates users from, using SAML. You can also map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the `Admin` and `Editor` roles in the workspace.
#'
#' See [https://paws-r.github.io/docs/managedgrafana/update_workspace_authentication.html](https://paws-r.github.io/docs/managedgrafana/update_workspace_authentication.html) for full documentation.
#'
#' @param authenticationProviders &#91;required&#93; Specifies whether this workspace uses SAML 2.0, Amazon Web Services
#' Single Sign On, or both to authenticate users for using the Grafana
#' console within a workspace. For more information, see [User
#' authentication in Amazon Managed
#' Grafana](https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html).
#' @param samlConfiguration If the workspace uses SAML, use this structure to map SAML assertion
#' attributes to workspace user information and define which groups in the
#' assertion attribute are to have the `Admin` and `Editor` roles in the
#' workspace.
#' @param workspaceId &#91;required&#93; The ID of the workspace to update the authentication for.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_update_workspace_authentication
managedgrafana_update_workspace_authentication <- function(authenticationProviders, samlConfiguration = NULL, workspaceId) {
  op <- new_operation(
    name = "UpdateWorkspaceAuthentication",
    http_method = "POST",
    http_path = "/workspaces/{workspaceId}/authentication",
    paginator = list()
  )
  input <- .managedgrafana$update_workspace_authentication_input(authenticationProviders = authenticationProviders, samlConfiguration = samlConfiguration, workspaceId = workspaceId)
  output <- .managedgrafana$update_workspace_authentication_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$update_workspace_authentication <- managedgrafana_update_workspace_authentication
