% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_update_auto_scaling_group}
\alias{autoscaling_update_auto_scaling_group}
\title{We strongly recommend that all Auto Scaling groups use launch templates
to ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2}
\usage{
autoscaling_update_auto_scaling_group(
  AutoScalingGroupName,
  LaunchConfigurationName = NULL,
  LaunchTemplate = NULL,
  MixedInstancesPolicy = NULL,
  MinSize = NULL,
  MaxSize = NULL,
  DesiredCapacity = NULL,
  DefaultCooldown = NULL,
  AvailabilityZones = NULL,
  HealthCheckType = NULL,
  HealthCheckGracePeriod = NULL,
  PlacementGroup = NULL,
  VPCZoneIdentifier = NULL,
  TerminationPolicies = NULL,
  NewInstancesProtectedFromScaleIn = NULL,
  ServiceLinkedRoleARN = NULL,
  MaxInstanceLifetime = NULL,
  CapacityRebalance = NULL,
  Context = NULL,
  DesiredCapacityType = NULL,
  DefaultInstanceWarmup = NULL
)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{LaunchConfigurationName}{The name of the launch configuration. If you specify
\code{LaunchConfigurationName} in your update request, you can't specify
\code{LaunchTemplate} or \code{MixedInstancesPolicy}.}

\item{LaunchTemplate}{The launch template and version to use to specify the updates. If you
specify \code{LaunchTemplate} in your update request, you can't specify
\code{LaunchConfigurationName} or \code{MixedInstancesPolicy}.}

\item{MixedInstancesPolicy}{An embedded object that specifies a mixed instances policy. For more
information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html}{Auto Scaling groups with multiple instance types and purchase options}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{MinSize}{The minimum size of the Auto Scaling group.}

\item{MaxSize}{The maximum size of the Auto Scaling group.

With a mixed instances policy that uses instance weighting, Amazon EC2
Auto Scaling may need to go above \code{MaxSize} to meet your capacity
requirements. In this event, Amazon EC2 Auto Scaling will never go above
\code{MaxSize} by more than your largest instance weight (weights that define
how many units each instance contributes to the desired capacity of the
group).}

\item{DesiredCapacity}{The desired capacity is the initial capacity of the Auto Scaling group
after this operation completes and the capacity it attempts to maintain.
This number must be greater than or equal to the minimum size of the
group and less than or equal to the maximum size of the group.}

\item{DefaultCooldown}{\emph{Only needed if you use simple scaling policies.}

The amount of time, in seconds, between one scaling activity ending and
another one starting due to simple scaling policies. For more
information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html}{Scaling cooldowns for Amazon EC2 Auto Scaling}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{AvailabilityZones}{One or more Availability Zones for the group.}

\item{HealthCheckType}{The service to use for the health checks. The valid values are \code{EC2} and
\code{ELB}. If you configure an Auto Scaling group to use \code{ELB} health
checks, it considers the instance unhealthy if it fails either the EC2
status checks or the load balancer health checks.}

\item{HealthCheckGracePeriod}{The amount of time, in seconds, that Amazon EC2 Auto Scaling waits
before checking the health status of an EC2 instance that has come into
service and marking it unhealthy due to a failed Elastic Load Balancing
or custom health check. This is useful if your instances do not
immediately pass these health checks after they enter the \code{InService}
state. For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-health-checks.html#health-check-grace-period}{Health check grace period}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{PlacementGroup}{The name of an existing placement group into which to launch your
instances. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html}{Placement groups}
in the \emph{Amazon EC2 User Guide for Linux Instances}.

A \emph{cluster} placement group is a logical grouping of instances within a
single Availability Zone. You cannot specify multiple Availability Zones
and a cluster placement group.}

\item{VPCZoneIdentifier}{A comma-separated list of subnet IDs for a virtual private cloud (VPC).
If you specify \code{VPCZoneIdentifier} with \code{AvailabilityZones}, the subnets
that you specify must reside in those Availability Zones.}

\item{TerminationPolicies}{A policy or a list of policies that are used to select the instances to
terminate. The policies are executed in the order that you list them.
For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html}{Work with Amazon EC2 Auto Scaling termination policies}
in the \emph{Amazon EC2 Auto Scaling User Guide}.

Valid values: \code{Default} | \code{AllocationStrategy} |
\code{ClosestToNextInstanceHour} | \code{NewestInstance} | \code{OldestInstance} |
\code{OldestLaunchConfiguration} | \code{OldestLaunchTemplate} |
\verb{arn:aws:lambda:region:account-id:function:my-function:my-alias}}

\item{NewInstancesProtectedFromScaleIn}{Indicates whether newly launched instances are protected from
termination by Amazon EC2 Auto Scaling when scaling in. For more
information about preventing instances from terminating on scale in, see
\href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html}{Using instance scale-in protection}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{ServiceLinkedRoleARN}{The Amazon Resource Name (ARN) of the service-linked role that the Auto
Scaling group uses to call other Amazon Web Services on your behalf. For
more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html}{Service-linked roles}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{MaxInstanceLifetime}{The maximum amount of time, in seconds, that an instance can be in
service. The default is null. If specified, the value must be either 0
or a number equal to or greater than 86,400 seconds (1 day). To clear a
previously set value, specify a new value of 0. For more information,
see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html}{Replacing Auto Scaling instances based on maximum instance lifetime}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{CapacityRebalance}{Enables or disables Capacity Rebalancing. For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html}{Use Capacity Rebalancing to handle Amazon EC2 Spot Interruptions}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{Context}{Reserved.}

\item{DesiredCapacityType}{The unit of measurement for the value specified for desired capacity.
Amazon EC2 Auto Scaling supports \code{DesiredCapacityType} for
attribute-based instance type selection only. For more information, see
\href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html}{Creating an Auto Scaling group using attribute-based instance type selection}
in the \emph{Amazon EC2 Auto Scaling User Guide}.

By default, Amazon EC2 Auto Scaling specifies \code{units}, which translates
into number of instances.

Valid values: \code{units} | \code{vcpu} | \code{memory-mib}}

\item{DefaultInstanceWarmup}{The amount of time, in seconds, until a newly launched instance can
contribute to the Amazon CloudWatch metrics. This delay lets an instance
finish initializing before Amazon EC2 Auto Scaling aggregates instance
metrics, resulting in more reliable usage data. Set this value equal to
the amount of time that it takes for resource consumption to become
stable after an instance reaches the \code{InService} state. For more
information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html}{Set the default instance warmup for an Auto Scaling group}
in the \emph{Amazon EC2 Auto Scaling User Guide}.

To manage your warm-up settings at the group level, we recommend that
you set the default instance warmup, \emph{even if its value is set to 0
seconds}. This also optimizes the performance of scaling policies that
scale continuously, such as target tracking and step scaling policies.

If you need to remove a value that you previously set, include the
property but specify \code{-1} for the value. However, we strongly recommend
keeping the default instance warmup enabled by specifying a minimum
value of \code{0}.}
}
\description{
\strong{We strongly recommend that all Auto Scaling groups use launch templates to ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2.}

See \url{https://paws-r.github.io/docs/autoscaling/update_auto_scaling_group.html} for full documentation.
}
\keyword{internal}
