% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_activate_type}
\alias{cloudformation_activate_type}
\title{Activates a public third-party extension, making it available for use in
stack templates}
\usage{
cloudformation_activate_type(
  Type = NULL,
  PublicTypeArn = NULL,
  PublisherId = NULL,
  TypeName = NULL,
  TypeNameAlias = NULL,
  AutoUpdate = NULL,
  LoggingConfig = NULL,
  ExecutionRoleArn = NULL,
  VersionBump = NULL,
  MajorVersion = NULL
)
}
\arguments{
\item{Type}{The extension type.

Conditional: You must specify \code{PublicTypeArn}, or \code{TypeName}, \code{Type},
and \code{PublisherId}.}

\item{PublicTypeArn}{The Amazon Resource Name (ARN) of the public extension.

Conditional: You must specify \code{PublicTypeArn}, or \code{TypeName}, \code{Type},
and \code{PublisherId}.}

\item{PublisherId}{The ID of the extension publisher.

Conditional: You must specify \code{PublicTypeArn}, or \code{TypeName}, \code{Type},
and \code{PublisherId}.}

\item{TypeName}{The name of the extension.

Conditional: You must specify \code{PublicTypeArn}, or \code{TypeName}, \code{Type},
and \code{PublisherId}.}

\item{TypeNameAlias}{An alias to assign to the public extension, in this account and region.
If you specify an alias for the extension, CloudFormation treats the
alias as the extension type name within this account and region. You
must use the alias to refer to the extension in your templates, API
calls, and CloudFormation console.

An extension alias must be unique within a given account and region. You
can activate the same public resource multiple times in the same account
and region, using different type name aliases.}

\item{AutoUpdate}{Whether to automatically update the extension in this account and region
when a new \emph{minor} version is published by the extension publisher.
Major versions released by the publisher must be manually updated.

The default is \code{true}.}

\item{LoggingConfig}{}

\item{ExecutionRoleArn}{The name of the IAM execution role to use to activate the extension.}

\item{VersionBump}{Manually updates a previously-activated type to a new major or minor
version, if available. You can also use this parameter to update the
value of \code{AutoUpdate}.
\itemize{
\item \code{MAJOR}: CloudFormation updates the extension to the newest major
version, if one is available.
\item \code{MINOR}: CloudFormation updates the extension to the newest minor
version, if one is available.
}}

\item{MajorVersion}{The major version of this extension you want to activate, if multiple
major versions are available. The default is the latest major version.
CloudFormation uses the latest available \emph{minor} version of the major
version selected.

You can specify \code{MajorVersion} or \code{VersionBump}, but not both.}
}
\description{
Activates a public third-party extension, making it available for use in stack templates. For more information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html}{Using public extensions} in the \emph{CloudFormation User Guide}.

See \url{https://paws-r.github.io/docs/cloudformation/activate_type.html} for full documentation.
}
\keyword{internal}
