% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_get_compliance_details_by_resource}
\alias{configservice_get_compliance_details_by_resource}
\title{Returns the evaluation results for the specified Amazon Web Services
resource}
\usage{
configservice_get_compliance_details_by_resource(
  ResourceType,
  ResourceId,
  ComplianceTypes = NULL,
  NextToken = NULL
)
}
\arguments{
\item{ResourceType}{[required] The type of the Amazon Web Services resource for which you want
compliance information.}

\item{ResourceId}{[required] The ID of the Amazon Web Services resource for which you want compliance
information.}

\item{ComplianceTypes}{Filters the results by compliance.

The allowed values are \code{COMPLIANT}, \code{NON_COMPLIANT}, and
\code{NOT_APPLICABLE}.}

\item{NextToken}{The \code{nextToken} string returned on a previous page that you use to get
the next page of results in a paginated response.}
}
\description{
Returns the evaluation results for the specified Amazon Web Services resource. The results indicate which Config rules were used to evaluate the resource, when each rule was last used, and whether the resource complies with each rule.

See \url{https://paws-r.github.io/docs/configservice/get_compliance_details_by_resource.html} for full documentation.
}
\keyword{internal}
