% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/health_operations.R
\name{health_describe_events}
\alias{health_describe_events}
\title{Returns information about events that meet the specified filter criteria}
\usage{
health_describe_events(
  filter = NULL,
  nextToken = NULL,
  maxResults = NULL,
  locale = NULL
)
}
\arguments{
\item{filter}{Values to narrow the results returned.}

\item{nextToken}{If the results of a search are large, only a portion of the results are
returned, and a \code{nextToken} pagination token is returned in the
response. To retrieve the next batch of results, reissue the search
request and include the returned token. When all results have been
returned, the response does not contain a pagination token value.}

\item{maxResults}{The maximum number of items to return in one batch, between 10 and 100,
inclusive.}

\item{locale}{The locale (language) to return information in. English (en) is the
default and the only supported value at this time.}
}
\description{
Returns information about events that meet the specified filter criteria. Events are returned in a summary form and do not include the detailed description, any additional metadata that depends on the event type, or any affected resources. To retrieve that information, use the \code{\link[=health_describe_event_details]{describe_event_details}} and \code{\link[=health_describe_affected_entities]{describe_affected_entities}} operations.

See \url{https://paws-r.github.io/docs/health/describe_events.html} for full documentation.
}
\keyword{internal}
